/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.AsciiWriter;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SamRecordIntervalIteratorFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Very simple command that just reads a SAM or BAM file andwrites out the header and each record to standard out. When an (optional) intervalsfile is specified, only records overlapping those intervals will be output.\nAll reads, just the aligned reads, or just the unaligned reads can be printed out bysetting AlignmentStatus accordingly. The SAM or BAM header can be printed out separatelyusing HEADER_ONLY. Only the alignment records can be printed using RECORDS_ONLY.However, HEADER_ONLY and RECORDS_ONLY cannot both be specified at one time.<p><h4>Usage example: </h4><pre>java -jar picard.jar ViewSam  <br />      I=sample.bam  <br />      HEADER_ONLY=true</pre>", oneLineSummary="Prints a SAM or BAM file to the screen", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class ViewSam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Prints a SAM or BAM file to the screen";
    static final String USAGE_DETAILS = "Very simple command that just reads a SAM or BAM file andwrites out the header and each record to standard out. When an (optional) intervalsfile is specified, only records overlapping those intervals will be output.\nAll reads, just the aligned reads, or just the unaligned reads can be printed out bysetting AlignmentStatus accordingly. The SAM or BAM header can be printed out separatelyusing HEADER_ONLY. Only the alignment records can be printed using RECORDS_ONLY.However, HEADER_ONLY and RECORDS_ONLY cannot both be specified at one time.<p><h4>Usage example: </h4><pre>java -jar picard.jar ViewSam  <br />      I=sample.bam  <br />      HEADER_ONLY=true</pre>";
    public final String USAGE = this.getStandardUsagePreamble() + "Prints a SAM or BAM file to the screen.";
    @Argument(shortName="I", doc="The SAM or BAM file or GA4GH url to view.")
    public String INPUT;
    @Argument(doc="Print out all reads, just the aligned reads or just the unaligned reads.")
    public AlignmentStatus ALIGNMENT_STATUS = AlignmentStatus.All;
    @Argument(doc="Print out all reads, just the PF reads or just the non-PF reads.")
    public PfStatus PF_STATUS = PfStatus.All;
    @Argument(doc="Print the SAM header only.", optional=true)
    public boolean HEADER_ONLY = false;
    @Argument(doc="Print the alignment records only.", optional=true)
    public boolean RECORDS_ONLY = false;
    @Argument(doc="An intervals file used to restrict what records are output.", optional=true)
    public File INTERVAL_LIST;

    public static void main(String[] args) {
        new ViewSam().instanceMain(args);
    }

    @Override
    protected int doWork() {
        return this.writeSamText(System.out);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.HEADER_ONLY && this.RECORDS_ONLY) {
            return new String[]{"Cannot specify both HEADER_ONLY=true and RECORDS_ONLY=true."};
        }
        return super.customCommandLineValidation();
    }

    int writeSamText(PrintStream printStream) {
        try {
            SAMRecordIterator samRecordsIterator;
            SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(SamInputResource.of((String)this.INPUT));
            if (this.HEADER_ONLY || this.INTERVAL_LIST == null) {
                samRecordsIterator = samReader.iterator();
            } else {
                IOUtil.assertFileIsReadable((File)this.INTERVAL_LIST);
                List intervals = IntervalList.fromFile((File)this.INTERVAL_LIST).uniqued().getIntervals();
                samRecordsIterator = new SamRecordIntervalIteratorFactory().makeSamRecordIntervalIterator(samReader, intervals, samReader.hasIndex());
            }
            AsciiWriter writer = new AsciiWriter((OutputStream)printStream);
            SAMFileHeader header = samReader.getFileHeader();
            if (!this.RECORDS_ONLY) {
                if (header.getTextHeader() != null) {
                    writer.write(header.getTextHeader());
                } else {
                    new SAMTextHeaderCodec().encode((Writer)writer, header, true);
                }
            }
            if (!this.HEADER_ONLY) {
                while (samRecordsIterator.hasNext()) {
                    SAMRecord rec = (SAMRecord)samRecordsIterator.next();
                    if (printStream.checkError()) {
                        return 1;
                    }
                    if (this.ALIGNMENT_STATUS == AlignmentStatus.Aligned && rec.getReadUnmappedFlag() || this.ALIGNMENT_STATUS == AlignmentStatus.Unaligned && !rec.getReadUnmappedFlag() || this.PF_STATUS == PfStatus.PF && rec.getReadFailsVendorQualityCheckFlag() || this.PF_STATUS == PfStatus.NonPF && !rec.getReadFailsVendorQualityCheckFlag()) continue;
                    writer.write(rec.getSAMString());
                }
            }
            writer.flush();
            if (printStream.checkError()) {
                return 1;
            }
            CloserUtil.close((Object)writer);
            CloserUtil.close((Object)samRecordsIterator);
            return 0;
        }
        catch (IOException e) {
            throw new PicardException("Exception writing SAM text", e);
        }
    }

    public static enum PfStatus {
        PF,
        NonPF,
        All;

    }

    public static enum AlignmentStatus {
        Aligned,
        Unaligned,
        All;

    }
}

