/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.SamRecordTrackingBuffer;
import htsjdk.samtools.util.SamRecordWithOrdinal;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import picard.PicardException;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.MarkQueue;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import picard.sam.markduplicates.util.ReadEnds;
import picard.sam.markduplicates.util.ReadEndsForMateCigar;
import picard.sam.markduplicates.util.SamRecordWithOrdinalAndSetDuplicateReadFlag;

public class MarkDuplicatesWithMateCigarIterator
implements SAMRecordIterator {
    private SAMFileHeader header = null;
    private PeekableIterator<SAMRecord> backingIterator = null;
    private int backingIteratorRecordIndex = 0;
    private boolean removeDuplicates = false;
    private boolean skipPairsWithNoMateCigar = true;
    private int numRecordsWithNoMateCigar = 0;
    private boolean foundUnmappedEOFReads = false;
    private int referenceIndex = 0;
    private SamRecordTrackingBuffer outputBuffer = null;
    private final MarkQueue toMarkQueue;
    private SAMRecord nextRecord = null;
    private final LibraryIdGenerator libraryIdGenerator;
    private OpticalDuplicateFinder opticalDuplicateFinder = null;
    private final SAMRecordCoordinateComparator sortComparator = new SAMRecordCoordinateComparator();
    boolean isClosed = false;

    public MarkDuplicatesWithMateCigarIterator(SAMFileHeader header, CloseableIterator<SAMRecord> iterator, OpticalDuplicateFinder opticalDuplicateFinder, DuplicateScoringStrategy.ScoringStrategy duplicateScoringStrategy, int toMarkQueueMinimumDistance, boolean removeDuplicates, boolean skipPairsWithNoMateCigar, int maxRecordsInRam, int blockSize, List<File> tmpDirs) throws PicardException {
        if (header.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException(this.getClass().getName() + " expects the input to be in coordinate sort order.");
        }
        this.header = header;
        this.backingIterator = new PeekableIterator(iterator);
        this.outputBuffer = new SamRecordTrackingBuffer(maxRecordsInRam, blockSize, tmpDirs, header, SamRecordWithOrdinalAndSetDuplicateReadFlag.class);
        this.removeDuplicates = removeDuplicates;
        this.skipPairsWithNoMateCigar = skipPairsWithNoMateCigar;
        this.opticalDuplicateFinder = opticalDuplicateFinder;
        this.toMarkQueue = new MarkQueue(duplicateScoringStrategy);
        this.libraryIdGenerator = new LibraryIdGenerator(header);
        if (duplicateScoringStrategy == DuplicateScoringStrategy.ScoringStrategy.SUM_OF_BASE_QUALITIES) {
            throw new PicardException("SUM_OF_BASE_QUALITIES not supported as this may cause inconsistencies across ends in a pair.  Please use a different scoring strategy.");
        }
        for (SAMReadGroupRecord readGroup : header.getReadGroups()) {
            String library = LibraryIdGenerator.getReadGroupLibraryName(readGroup);
            DuplicationMetrics metrics = this.libraryIdGenerator.getMetricsByLibrary(library);
            if (metrics != null) continue;
            metrics = new DuplicationMetrics();
            metrics.LIBRARY = library;
            this.libraryIdGenerator.addMetricsByLibrary(library, metrics);
        }
        this.toMarkQueue.setToMarkQueueMinimumDistance(toMarkQueueMinimumDistance);
        this.nextRecord = this.markDuplicatesAndGetTheNextAvailable();
    }

    public void logMemoryStats(Log log) {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        log.info(new Object[]{"freeMemory: " + runtime.freeMemory() + "; totalMemory: " + runtime.totalMemory() + "; maxMemory: " + runtime.maxMemory() + "; output buffer size: " + this.outputBuffer.size() + "; duplicate queue size: " + this.toMarkQueue.size()});
    }

    public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
        if (sortOrder != SAMFileHeader.SortOrder.coordinate) {
            throw new IllegalStateException("Cannot assort " + sortOrder + " when expecting coordinate sorted input");
        }
        return this;
    }

    public boolean hasNext() {
        if (null != this.nextRecord) {
            return true;
        }
        return this.backingIterator.hasNext() || !this.outputBuffer.isEmpty();
    }

    public SAMRecord next() throws PicardException {
        SAMRecord toReturn = this.nextRecord;
        if (null == toReturn) {
            throw new NoSuchElementException();
        }
        this.nextRecord = this.hasNext() ? this.markDuplicatesAndGetTheNextAvailable() : null;
        if (null != this.nextRecord && 0 < this.sortComparator.fileOrderCompare(toReturn, this.nextRecord)) {
            System.err.print("Previous record: " + toReturn.getSAMString());
            System.err.print("Current record:" + this.nextRecord.getSAMString());
            throw new PicardException("Records were not found coordinate sort order");
        }
        return toReturn;
    }

    private boolean ignoreDueToMissingMateCigar(SamRecordWithOrdinal samRecordWithOrdinal) {
        SAMRecord record = samRecordWithOrdinal.getRecord();
        if (record.getReadPairedFlag() && !record.getMateUnmappedFlag() && null == SAMUtils.getMateCigar((SAMRecord)record)) {
            DuplicationMetrics metrics = this.getMetrics(record);
            if (record.isSecondaryOrSupplementary()) {
                ++metrics.SECONDARY_OR_SUPPLEMENTARY_RDS;
            } else if (record.getReadUnmappedFlag()) {
                ++metrics.UNMAPPED_READS;
            } else if (!record.getReadPairedFlag() || record.getMateUnmappedFlag()) {
                ++metrics.UNPAIRED_READS_EXAMINED;
            } else {
                ++metrics.READ_PAIRS_EXAMINED;
            }
            if (this.skipPairsWithNoMateCigar) {
                this.addRecordToTheOutputBuffer(samRecordWithOrdinal);
                ++this.backingIteratorRecordIndex;
                this.outputBuffer.setResultState(samRecordWithOrdinal, false);
                ++this.numRecordsWithNoMateCigar;
                this.backingIterator.next();
                return true;
            }
            throw new PicardException("Read " + record.getReadName() + " was mapped and had a mapped mate, but no mate cigar (\"MC\") tag.");
        }
        return false;
    }

    private SAMRecord nextIfRecordIsUnmappedAtEOF(SAMRecord record) {
        if (this.foundUnmappedEOFReads) {
            SAMRecord unmappedRecord = (SAMRecord)this.backingIterator.next();
            if (!record.isSecondaryOrSupplementary()) {
                DuplicationMetrics metrics = this.getMetrics(record);
                ++metrics.UNMAPPED_READS;
            }
            if (!this.outputBuffer.isEmpty()) {
                throw new PicardException("Encountered unmapped reads at the end of the file, but the alignment start buffer was not empty.");
            }
            return unmappedRecord;
        }
        this.foundUnmappedEOFReads = true;
        this.referenceIndex = this.header.getSequenceDictionary().getSequences().size();
        this.tryPollingTheToMarkQueue(true, null);
        return this.markDuplicatesAndGetTheNextAvailable();
    }

    private void checkForMinimumDistanceFailure(ReadEndsForMateCigar current) {
        if (!this.toMarkQueue.isEmpty()) {
            ReadEndsForMateCigar other = this.toMarkQueue.peek();
            if (other.read1ReferenceIndex == current.read1ReferenceIndex && this.toMarkQueue.getToMarkQueueMinimumDistance() <= other.read1Coordinate - current.read1Coordinate) {
                if (this.checkCigarForSkips(other.getRecord().getCigar())) {
                    throw new PicardException("Found a samRecordWithOrdinal with sufficiently large code length that we may have\n missed including it in an early duplicate marking iteration.  Alignment contains skipped reference bases (N's). If this is an\n RNAseq aligned bam, please use MarkDuplicates instead, as this tool does not work well with spliced reads.\n Minimum distance set to " + this.toMarkQueue.getToMarkQueueMinimumDistance() + " but " + (other.read1Coordinate - current.read1Coordinate - 1) + " would be required.\n" + "Record was: " + other.getRecord().getSAMString());
                }
                System.err.print("record #1: " + other.getRecord().getSAMString());
                System.err.print("record #2: " + current.getRecord().getSAMString());
                throw new PicardException("Found a samRecordWithOrdinal with sufficiently large clipping that we may have\n missed including it in an early duplicate marking iteration.  Please increase the minimum distance to at least " + (other.read1Coordinate - current.read1Coordinate - 1) + "bp\nto ensure it is considered (was " + this.toMarkQueue.getToMarkQueueMinimumDistance() + ").\n" + "Record was: " + other.getRecord().getSAMString());
            }
        }
    }

    private SAMRecord markDuplicatesAndGetTheNextAvailable() {
        SAMRecord record = this.flush();
        if (null != record) {
            return record;
        }
        if (!this.backingIterator.hasNext()) {
            if (this.toMarkQueue.isEmpty()) {
                if (this.outputBuffer.isEmpty()) {
                    return null;
                }
            } else {
                this.tryPollingTheToMarkQueue(true, null);
            }
            this.referenceIndex = this.header.getSequenceDictionary().getSequences().size();
            return this.markDuplicatesAndGetTheNextAvailable();
        }
        while (this.backingIterator.hasNext()) {
            DuplicationMetrics metrics;
            record = (SAMRecord)this.backingIterator.peek();
            SamRecordWithOrdinalAndSetDuplicateReadFlag samRecordWithOrdinal = new SamRecordWithOrdinalAndSetDuplicateReadFlag(record, this.backingIteratorRecordIndex);
            ReadEndsForMateCigar readEnds = null;
            boolean performedChunkAndMarkTheDuplicates = false;
            record.setDuplicateReadFlag(false);
            if (this.ignoreDueToMissingMateCigar(samRecordWithOrdinal)) continue;
            if (record.getReadUnmappedFlag()) {
                if (-1 == record.getReferenceIndex()) {
                    return this.nextIfRecordIsUnmappedAtEOF(record);
                }
                if (!record.isSecondaryOrSupplementary()) {
                    metrics = this.getMetrics(record);
                    ++metrics.UNMAPPED_READS;
                }
            } else {
                if (-1 == this.toMarkQueue.getToMarkQueueMinimumDistance()) {
                    this.toMarkQueue.setToMarkQueueMinimumDistance(Math.max(2 * record.getReadBases().length, 100));
                }
                readEnds = new ReadEndsForMateCigar(this.header, samRecordWithOrdinal, this.opticalDuplicateFinder, this.libraryIdGenerator.getLibraryId(samRecordWithOrdinal.getRecord()));
                this.checkForMinimumDistanceFailure(readEnds);
                performedChunkAndMarkTheDuplicates = this.tryPollingTheToMarkQueue(false, readEnds);
            }
            this.backingIterator.next();
            this.addRecordToTheOutputBuffer(samRecordWithOrdinal);
            ++this.backingIteratorRecordIndex;
            metrics = this.getMetrics(record);
            if (record.isSecondaryOrSupplementary() || record.getReadUnmappedFlag()) {
                this.outputBuffer.setResultState((SamRecordWithOrdinal)samRecordWithOrdinal, false);
                if (record.isSecondaryOrSupplementary()) {
                    ++metrics.SECONDARY_OR_SUPPLEMENTARY_RDS;
                }
            } else {
                if (!record.getReadPairedFlag() || record.getMateUnmappedFlag()) {
                    ++metrics.UNPAIRED_READS_EXAMINED;
                } else {
                    ++metrics.READ_PAIRS_EXAMINED;
                }
                this.toMarkQueue.add(readEnds, this.outputBuffer, this.getMetrics(readEnds.getRecord()));
            }
            if (!performedChunkAndMarkTheDuplicates || null == (record = this.flush())) continue;
            return record;
        }
        return this.markDuplicatesAndGetTheNextAvailable();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.backingIterator.close();
        this.outputBuffer.close();
        this.isClosed = true;
    }

    private boolean checkCigarForSkips(Cigar cigar) {
        List elements = cigar.getCigarElements();
        for (CigarElement el : elements) {
            if (el.getOperator() != CigarOperator.N) continue;
            return true;
        }
        return false;
    }

    private void enforceClosed() {
        if (!this.isClosed) {
            throw new PicardException("Calling a method that assumes the iterator is closed");
        }
    }

    public int getNumRecordsWithNoMateCigar() {
        this.enforceClosed();
        return this.numRecordsWithNoMateCigar;
    }

    public int getNumDuplicates() {
        this.enforceClosed();
        return this.toMarkQueue.getNumDuplicates();
    }

    public LibraryIdGenerator getLibraryIdGenerator() {
        this.enforceClosed();
        return this.libraryIdGenerator;
    }

    public Histogram<Short> getOpticalDupesByLibraryId() {
        this.enforceClosed();
        return this.libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap();
    }

    private SAMRecord flush() {
        while (!this.outputBuffer.isEmpty() && this.outputBuffer.canEmit()) {
            SAMRecord record = this.outputBuffer.next().getRecord();
            if (this.removeDuplicates && record.getDuplicateReadFlag()) continue;
            return record;
        }
        return null;
    }

    private void addRecordToTheOutputBuffer(SamRecordWithOrdinal samRecordWithOrdinal) throws PicardException {
        int recordReferenceIndex = samRecordWithOrdinal.getRecord().getReferenceIndex();
        if (recordReferenceIndex < this.referenceIndex) {
            throw new PicardException("Records out of order: " + recordReferenceIndex + " < " + this.referenceIndex);
        }
        if (this.referenceIndex < recordReferenceIndex) {
            this.tryPollingTheToMarkQueue(true, null);
            this.referenceIndex = recordReferenceIndex;
        }
        this.outputBuffer.add(samRecordWithOrdinal);
    }

    private boolean tryPollingTheToMarkQueue(boolean flush, ReadEndsForMateCigar current) {
        boolean performedChunkAndMarkTheDuplicates = false;
        if (!flush && null == current) {
            throw new PicardException("Flush cannot be false and current be null");
        }
        if (this.toMarkQueue.isEmpty()) {
            return false;
        }
        if (!this.toMarkQueue.isEmpty() && this.outputBuffer.isEmpty()) {
            throw new PicardException("0 < toMarkQueue && outputBuffer.isEmpty()");
        }
        while (!this.toMarkQueue.isEmpty() && (flush || this.referenceIndex != current.read1ReferenceIndex || this.toMarkQueue.getToMarkQueueMinimumDistance() < current.read1Coordinate - this.toMarkQueue.peek().read1Coordinate)) {
            Set<ReadEnds> locations;
            ReadEndsForMateCigar next = this.toMarkQueue.poll(this.outputBuffer, this.header, this.opticalDuplicateFinder, this.libraryIdGenerator);
            performedChunkAndMarkTheDuplicates = true;
            if (!this.toMarkQueue.shouldBeInLocations(next) || !next.getRecord().getFirstOfPairFlag() || (locations = this.toMarkQueue.getLocations(next)).isEmpty()) continue;
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(new ArrayList<ReadEnds>(locations), null, this.opticalDuplicateFinder, this.libraryIdGenerator);
        }
        return performedChunkAndMarkTheDuplicates;
    }

    private DuplicationMetrics getMetrics(SAMRecord record) {
        String library = LibraryIdGenerator.getLibraryName(this.header, record);
        DuplicationMetrics metrics = this.libraryIdGenerator.getMetricsByLibrary(library);
        if (metrics == null) {
            metrics = new DuplicationMetrics();
            metrics.LIBRARY = library;
            this.libraryIdGenerator.addMetricsByLibrary(library, metrics);
        }
        return metrics;
    }
}

