/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IntervalListScatterer {
    private final Mode mode;

    public IntervalListScatterer(Mode mode) {
        this.mode = mode;
    }

    private int deduceIdealSplitLength(IntervalList uniquedList, int scatterCount) {
        int splitWidth = Math.max((int)Math.floor((double)uniquedList.getBaseCount() / (1.0 * (double)scatterCount)), 1);
        switch (this.mode) {
            case INTERVAL_SUBDIVISION: {
                return splitWidth;
            }
            case BALANCING_WITHOUT_INTERVAL_SUBDIVISION: 
            case BALANCING_WITHOUT_INTERVAL_SUBDIVISION_WITH_OVERFLOW: {
                int widestIntervalLength = ((Interval)Collections.max(uniquedList.getIntervals(), (o1, o2) -> Integer.valueOf(o1.length()).compareTo(o2.length()))).length();
                return Math.max(widestIntervalLength, splitWidth);
            }
        }
        throw new IllegalStateException();
    }

    public List<IntervalList> scatter(IntervalList uniquedIntervalList, int scatterCount) {
        return this.scatter(uniquedIntervalList, scatterCount, false);
    }

    private boolean shouldAddToRunningIntervalList(long idealSplitLength, long projectedSize, double projectedSizeOfRemainingDivisions) {
        switch (this.mode) {
            case BALANCING_WITHOUT_INTERVAL_SUBDIVISION_WITH_OVERFLOW: {
                return projectedSize <= idealSplitLength || (double)idealSplitLength < projectedSizeOfRemainingDivisions;
            }
        }
        return projectedSize <= idealSplitLength;
    }

    public List<IntervalList> scatter(IntervalList sourceIntervalList, int scatterCount, boolean isUniqued) {
        if (scatterCount < 1) {
            throw new IllegalArgumentException("scatterCount < 1");
        }
        IntervalList uniquedList = isUniqued ? sourceIntervalList : sourceIntervalList.uniqued();
        long idealSplitLength = this.deduceIdealSplitLength(uniquedList, scatterCount);
        System.err.println("idealSplitLength=" + idealSplitLength);
        ArrayList<IntervalList> accumulatedIntervalLists = new ArrayList<IntervalList>();
        IntervalList runningIntervalList = new IntervalList(uniquedList.getHeader());
        ArrayDeque<Interval> intervalQueue = new ArrayDeque<Interval>(uniquedList.getIntervals());
        long numBasesLeft = uniquedList.getBaseCount();
        while (!intervalQueue.isEmpty() && accumulatedIntervalLists.size() < scatterCount - 1) {
            double projectedSizeOfRemainingDivisions;
            Interval interval = (Interval)intervalQueue.pollFirst();
            long projectedSize = runningIntervalList.getBaseCount() + (long)interval.length();
            if (this.shouldAddToRunningIntervalList(idealSplitLength, projectedSize, projectedSizeOfRemainingDivisions = (double)(numBasesLeft - runningIntervalList.getBaseCount()) / (double)(scatterCount - accumulatedIntervalLists.size() - 1))) {
                runningIntervalList.add(interval);
            } else {
                switch (this.mode) {
                    case INTERVAL_SUBDIVISION: {
                        int amountToConsume = (int)(idealSplitLength - runningIntervalList.getBaseCount());
                        Interval left = new Interval(interval.getContig(), interval.getStart(), interval.getStart() + amountToConsume - 1, interval.isNegativeStrand(), interval.getName());
                        Interval right = new Interval(interval.getContig(), interval.getStart() + amountToConsume, interval.getEnd(), interval.isNegativeStrand(), interval.getName());
                        runningIntervalList.add(left);
                        intervalQueue.addFirst(right);
                        break;
                    }
                    case BALANCING_WITHOUT_INTERVAL_SUBDIVISION: 
                    case BALANCING_WITHOUT_INTERVAL_SUBDIVISION_WITH_OVERFLOW: {
                        if (runningIntervalList.getIntervals().isEmpty()) {
                            runningIntervalList.add(interval);
                            break;
                        }
                        intervalQueue.addFirst(interval);
                        numBasesLeft -= runningIntervalList.getBaseCount();
                        accumulatedIntervalLists.add(runningIntervalList.uniqued());
                        runningIntervalList = new IntervalList(uniquedList.getHeader());
                    }
                }
            }
            if (runningIntervalList.getBaseCount() < idealSplitLength) continue;
            numBasesLeft -= runningIntervalList.getBaseCount();
            accumulatedIntervalLists.add(runningIntervalList.uniqued());
            runningIntervalList = new IntervalList(uniquedList.getHeader());
        }
        while (!intervalQueue.isEmpty()) {
            runningIntervalList.add((Interval)intervalQueue.pollFirst());
        }
        if (!runningIntervalList.getIntervals().isEmpty()) {
            accumulatedIntervalLists.add(runningIntervalList.uniqued());
        }
        long maximumIntervalSize = -1L;
        long minimumIntervalSize = Integer.MAX_VALUE;
        for (IntervalList intervalList : accumulatedIntervalLists) {
            long baseCount = intervalList.getBaseCount();
            if (baseCount < minimumIntervalSize) {
                minimumIntervalSize = baseCount;
            }
            if (maximumIntervalSize >= baseCount) continue;
            maximumIntervalSize = baseCount;
        }
        return accumulatedIntervalLists;
    }

    public static enum Mode {
        INTERVAL_SUBDIVISION,
        BALANCING_WITHOUT_INTERVAL_SUBDIVISION,
        BALANCING_WITHOUT_INTERVAL_SUBDIVISION_WITH_OVERFLOW;

    }
}

