/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.IntervalsManipulationProgramGroup;

@CommandLineProgramProperties(summary="Lifts over an interval list from one reference build to another. This tool adjusts the coordinates in an interval list on one reference to its homologous interval list on another reference, based on a chain file that describes the correspondence between the two references. It is based on the UCSC LiftOver tool (see: http://genome.ucsc.edu/cgi-bin/hgLiftOver) and uses a UCSC chain file to guide its operation. It accepts both Picard interval_list files or VCF files as interval inputs.\n\n<h3>Usage example:</h3>java -jar picard.jar LiftOverIntervalList \\\n      I=input.interval_list \\\n      O=output.interval_list \\\n      SD=reference_sequence.dict \\\n      CHAIN=build.chain</pre>\n<h3>Return codes</h3>\nIf all the intervals lifted over successfully, program will return 0. It will return 1 otherwise.\n\n<h3>Caveats</h3>\nAn interval is \"lifted\" in its entirety, but it might intersect (a \"hit\") with multiple chain-blocks. Instead of placing the interval in multiple hits, it is lifted over using the first hit that passes the threshold of MIN_LIFTOVER_PCT. For large enough MIN_LIFTOVER_PCT this is non-ambiguous, but if one uses small values of MIN_LIFTOVER_PCT (perhaps in order to increase the rate of successful hits...) the liftover could end up going to the smaller of two good hits. On the other hand, if none of the hits pass the threshold a warning will be emitted and the interval will not be lifted.", oneLineSummary="Lifts over an interval list from one reference build to another. ", programGroup=IntervalsManipulationProgramGroup.class)
@DocumentedFeature
public class LiftOverIntervalList
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Lifts over an interval list from one reference build to another. ";
    static final String USAGE_DETAILS = "This tool adjusts the coordinates in an interval list on one reference to its homologous interval list on another reference, based on a chain file that describes the correspondence between the two references. It is based on the UCSC LiftOver tool (see: http://genome.ucsc.edu/cgi-bin/hgLiftOver) and uses a UCSC chain file to guide its operation. It accepts both Picard interval_list files or VCF files as interval inputs.\n\n<h3>Usage example:</h3>java -jar picard.jar LiftOverIntervalList \\\n      I=input.interval_list \\\n      O=output.interval_list \\\n      SD=reference_sequence.dict \\\n      CHAIN=build.chain</pre>\n<h3>Return codes</h3>\nIf all the intervals lifted over successfully, program will return 0. It will return 1 otherwise.\n\n<h3>Caveats</h3>\nAn interval is \"lifted\" in its entirety, but it might intersect (a \"hit\") with multiple chain-blocks. Instead of placing the interval in multiple hits, it is lifted over using the first hit that passes the threshold of MIN_LIFTOVER_PCT. For large enough MIN_LIFTOVER_PCT this is non-ambiguous, but if one uses small values of MIN_LIFTOVER_PCT (perhaps in order to increase the rate of successful hits...) the liftover could end up going to the smaller of two good hits. On the other hand, if none of the hits pass the threshold a warning will be emitted and the interval will not be lifted.";
    private static final Log LOG = Log.getInstance(LiftOverIntervalList.class);
    @Argument(doc="The input interval list to be lifted over.", shortName="I")
    public File INPUT;
    @Argument(doc="The output interval list file.", shortName="O")
    public File OUTPUT;
    @Argument(doc="Sequence dictionary to place in the output interval list. (This should be the dictionary of the target reference.)", shortName="SD")
    public File SEQUENCE_DICTIONARY;
    @Argument(doc="Chain file that guides the LiftOver process.")
    public File CHAIN;
    @Argument(doc="Minimum percentage of bases in each input interval that must map to output interval for liftover of that interval to occur. If the program fails to find a good target for an interval, a warning will be emitted and the interval will be dropped from the output. ")
    public double MIN_LIFTOVER_PCT = 0.95;
    @Argument(doc="Interval List file for intervals that were rejected", optional=true)
    public File REJECT = null;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsReadable((File)this.CHAIN);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.REJECT != null) {
            IOUtil.assertFileIsWritable((File)this.REJECT);
        }
        LiftOver liftOver = new LiftOver(this.CHAIN);
        liftOver.setLiftOverMinMatch(this.MIN_LIFTOVER_PCT);
        IntervalList intervalList = IntervalList.fromFile((File)this.INPUT);
        IntervalList rejects = new IntervalList(intervalList.getHeader());
        long baseCount = intervalList.getBaseCount();
        LOG.info(new Object[]{"Lifting over " + intervalList.getIntervals().size() + " intervals, encompassing " + baseCount + " bases."});
        SAMFileHeader toHeader = SamReaderFactory.makeDefault().getFileHeader(this.SEQUENCE_DICTIONARY);
        liftOver.validateToSequences(toHeader.getSequenceDictionary());
        IntervalList toIntervals = new IntervalList(toHeader);
        for (Interval fromInterval : intervalList) {
            Interval toInterval = liftOver.liftOver(fromInterval);
            if (toInterval != null) {
                toIntervals.add(toInterval);
                continue;
            }
            rejects.add(fromInterval);
            LOG.warn(new Object[]{"Liftover failed for ", fromInterval, " (len ", fromInterval.length(), ")"});
            List partials = liftOver.diagnosticLiftover(fromInterval);
            for (LiftOver.PartialLiftover partial : partials) {
                LOG.info(new Object[]{partial});
            }
        }
        toIntervals.sorted().write(this.OUTPUT);
        if (this.REJECT != null) {
            rejects.write(this.REJECT);
        }
        long rejectBaseCount = rejects.getBaseCount();
        LOG.info(new Object[]{String.format("Liftover Complete. \n%d of %d intervals failed (%g%%) to liftover, encompassing %d of %d bases (%g%%).", rejects.getIntervals().size(), intervalList.getIntervals().size(), (double)(100 * rejects.getIntervals().size()) / (double)intervalList.getIntervals().size(), rejectBaseCount, baseCount, (double)(100L * rejectBaseCount) / (double)baseCount)});
        return rejects.getIntervals().isEmpty() ? 0 : 1;
    }
}

