/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Replaces or fixes a VCF header.This tool will either replace the header in the input VCF file (INPUT) with the given VCF header (HEADER) or will attempt to fill in any field definitions that are missing in the input header by examining the variants in the input VCF file (INPUT).  In the   latter case, this tool will perform two passes over the input VCF, and any INFO and FORMAT fields found in the VCF records but not found in the input VCF header will be added to the output VCF header with dummy descriptions.<br /><h4>Replace header usage example:</h4><pre>java -jar picard.jar FixVcfHeader \\<br />     I=input.vcf \\<br />     O=fixed.vcf \\<br />     HEADER=header.vcf</pre><h4>Fix header usage example:</h4><pre>java -jar picard.jar FixVcfHeader \\<br />     I=input.vcf \\<br />     O=fixed.vcf \\<br /></pre><hr />", oneLineSummary="Replaces or fixes a VCF header.", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class FixVcfHeader
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Replaces or fixes a VCF header.";
    static final String USAGE_DETAILS = "This tool will either replace the header in the input VCF file (INPUT) with the given VCF header (HEADER) or will attempt to fill in any field definitions that are missing in the input header by examining the variants in the input VCF file (INPUT).  In the   latter case, this tool will perform two passes over the input VCF, and any INFO and FORMAT fields found in the VCF records but not found in the input VCF header will be added to the output VCF header with dummy descriptions.<br /><h4>Replace header usage example:</h4><pre>java -jar picard.jar FixVcfHeader \\<br />     I=input.vcf \\<br />     O=fixed.vcf \\<br />     HEADER=header.vcf</pre><h4>Fix header usage example:</h4><pre>java -jar picard.jar FixVcfHeader \\<br />     I=input.vcf \\<br />     O=fixed.vcf \\<br /></pre><hr />";
    @Argument(shortName="I", doc="The input VCF/BCF file.")
    public File INPUT;
    @Argument(shortName="O", doc="The output VCF/BCF file.")
    public File OUTPUT;
    @Argument(shortName="N", doc="Check only the first N records when searching for missing INFO and FORMAT fields.", optional=true)
    public int CHECK_FIRST_N_RECORDS = -1;
    @Argument(shortName="H", doc="The replacement VCF header.", optional=true)
    public File HEADER = null;
    @Argument(doc="Enforce that the samples are the same (and in the same order) when replacing the VCF header.", optional=true)
    public boolean ENFORCE_SAME_SAMPLES = true;
    private final Log log = Log.getInstance(FixVcfHeader.class);

    public static void main(String[] args) {
        new FixVcfHeader().instanceMainWithExit(args);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.HEADER != null && 0 <= this.CHECK_FIRST_N_RECORDS) {
            return new String[]{"CHECK_FIRST_N_RECORDS should no be specified when HEADER is specified"};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected int doWork() {
        VCFHeader outHeader;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        if (this.HEADER != null) {
            IOUtil.assertFileIsReadable((File)this.HEADER);
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        VCFFileReader reader = new VCFFileReader(this.INPUT, false);
        if (this.HEADER != null) {
            VCFFileReader headerReader = new VCFFileReader(this.HEADER, false);
            if (this.ENFORCE_SAME_SAMPLES) {
                outHeader = headerReader.getFileHeader();
                this.enforceSameSamples(reader.getFileHeader(), outHeader);
            } else {
                outHeader = new VCFHeader(headerReader.getFileHeader().getMetaDataInInputOrder(), (List)reader.getFileHeader().getSampleNamesInOrder());
            }
            CloserUtil.close((Object)headerReader);
            outHeader.getInfoHeaderLines().stream().filter(infoHeaderLine -> !reader.getFileHeader().hasInfoLine(infoHeaderLine.getID())).forEach(infoHeaderLine -> this.log.info(new Object[]{"INFO line found in HEADER will be added to OUTPUT: " + infoHeaderLine.getID()}));
            outHeader.getFormatHeaderLines().stream().filter(formatHeaderLine -> !reader.getFileHeader().hasInfoLine(formatHeaderLine.getID())).forEach(formatHeaderLine -> this.log.info(new Object[]{"FORMAT line found in HEADER will be added to OUTPUT: " + formatHeaderLine.getID()}));
        } else {
            ProgressLogger progress = new ProgressLogger(this.log, 1000000, "read");
            VCFFileReader in = new VCFFileReader(this.INPUT, false);
            VCFHeader inHeader = in.getFileHeader();
            HashMap<String, VCFInfoHeaderLine> infoHeaderLines = new HashMap<String, VCFInfoHeaderLine>();
            HashMap<String, VCFFormatHeaderLine> formatHeaderLines = new HashMap<String, VCFFormatHeaderLine>();
            this.log.info(new Object[]{"Reading in records to re-build the header."});
            for (VariantContext ctx : in) {
                for (Map.Entry attribute : ctx.getAttributes().entrySet()) {
                    String id = (String)attribute.getKey();
                    if (inHeader.hasInfoLine(id) || infoHeaderLines.containsKey(id)) continue;
                    this.log.info(new Object[]{"Will add an INFO line with id: " + id});
                    infoHeaderLines.put(id, new VCFInfoHeaderLine(id, VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Missing description: this INFO line was added by Picard's FixVCFHeader"));
                }
                for (Genotype genotype : ctx.getGenotypes()) {
                    for (Map.Entry attribute : genotype.getExtendedAttributes().entrySet()) {
                        String id = (String)attribute.getKey();
                        if (inHeader.hasFormatLine(id) || formatHeaderLines.containsKey(id)) continue;
                        this.log.info(new Object[]{"Will add FORMAT line with id: " + id});
                        formatHeaderLines.put(id, new VCFFormatHeaderLine(id, VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Missing description: this FORMAT line was added by Picard's FixVCFHeader"));
                    }
                }
                progress.record(ctx.getContig(), ctx.getStart());
                if (0 >= this.CHECK_FIRST_N_RECORDS || (long)this.CHECK_FIRST_N_RECORDS > progress.getCount()) continue;
                break;
            }
            CloserUtil.close((Object)in);
            HashSet headerLines = new HashSet(inHeader.getMetaDataInInputOrder());
            VCFStandardHeaderLines.addStandardFormatLines(headerLines, (boolean)false, (Collection)Genotype.PRIMARY_KEYS);
            headerLines.addAll(infoHeaderLines.values());
            headerLines.addAll(formatHeaderLines.values());
            outHeader = new VCFHeader(headerLines, (List)inHeader.getSampleNamesInOrder());
            this.log.info(new Object[]{"VCF header re-built."});
        }
        VariantContextWriter writer = new VariantContextWriterBuilder().setOption(Options.INDEX_ON_THE_FLY).setOutputFile(this.OUTPUT).setReferenceDictionary(outHeader.getSequenceDictionary()).build();
        writer.writeHeader(outHeader);
        this.log.info(new Object[]{"Writing the output VCF."});
        ProgressLogger progress = new ProgressLogger(this.log, 1000000, "read");
        for (VariantContext ctx : reader) {
            writer.add(ctx);
            progress.record(ctx.getContig(), ctx.getStart());
        }
        writer.close();
        CloserUtil.close((Object)reader);
        return 0;
    }

    private void enforceSameSamples(VCFHeader readerHeader, VCFHeader inputHeader) {
        ArrayList readerSamples = readerHeader.getSampleNamesInOrder();
        ArrayList inputSamples = inputHeader.getSampleNamesInOrder();
        if (readerSamples.size() != inputSamples.size()) {
            throw new PicardException("The input VCF had a different # of samples than the input VCF header.");
        }
        for (int i = 0; i < readerSamples.size(); ++i) {
            if (((String)readerSamples.get(i)).equals(inputSamples.get(i))) continue;
            throw new PicardException(String.format("Mismatch in the %dth sample: '%s' != '%s'", i, readerSamples.get(i), inputSamples.get(i)));
        }
    }
}

