/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.MergingIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(oneLineSummary="Combines multiple variant files into a single variant file", summary="<p>Combines multiple variant files into a single variant file.</p><h3>Inputs</h3><ul>      <li>One or more input file in VCF format (can be gzipped, i.e. ending in \".vcf.gz\", or binary compressed, i.e. ending in \".bcf\").</li>      <li>Optionally a sequence dictionary file (typically name ending in .dict) if the input VCF does not contain a          complete contig list and if the output index is to be created (true by default).</li>  </ul>  <p>  The input variant data must adhere to the following rules:</p>     <ul>         <li>If there are samples, those must be the same across all input files.</li>         <li>Input file headers must be contain compatible declarations for common annotations (INFO, FORMAT fields) and filters.</li>         <li>Input files variant records must be sorted by their contig and position following the sequence dictionary provided         or the header contig list.</li>     </ul> <p>You can either directly specify the list of files by specifying <code>INPUT</code> multiple times, or provide a list     in a file with name ending in \".list\" to <code>INPUT</code>.</p> <h3>Outputs</h3> <p>A VCF sorted (i) according to the dictionary and (ii) by coordiante.</p> <h3>Usage examples</h3> <h4>Example 1:</h4> <p>We combine several variant files in different formats, where at least one of them contains the contig list in its header.</p> <pre>java -jar picard.jar MergeVcfs \\\n          I=input_variants.01.vcf \\\n          I=input_variants.02.vcf.gz \\\n          O=output_variants.vcf.gz</pre> <h4>Example 2:</h4> <p>Similar to example 1 but we use an input list file to specify the input files:</p> <pre>java -jar picard.jar MergeVcfs \\\n          I=input_variant_files.list \\\n          O=output_variants.vcf.gz</pre><hr/>", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class MergeVcfs
extends CommandLineProgram {
    static final String SUMMARY_FIRST_SENTENCE = "Combines multiple variant files into a single variant file";
    static final String SUMMARY = "<p>Combines multiple variant files into a single variant file.</p><h3>Inputs</h3><ul>      <li>One or more input file in VCF format (can be gzipped, i.e. ending in \".vcf.gz\", or binary compressed, i.e. ending in \".bcf\").</li>      <li>Optionally a sequence dictionary file (typically name ending in .dict) if the input VCF does not contain a          complete contig list and if the output index is to be created (true by default).</li>  </ul>  <p>  The input variant data must adhere to the following rules:</p>     <ul>         <li>If there are samples, those must be the same across all input files.</li>         <li>Input file headers must be contain compatible declarations for common annotations (INFO, FORMAT fields) and filters.</li>         <li>Input files variant records must be sorted by their contig and position following the sequence dictionary provided         or the header contig list.</li>     </ul> <p>You can either directly specify the list of files by specifying <code>INPUT</code> multiple times, or provide a list     in a file with name ending in \".list\" to <code>INPUT</code>.</p> <h3>Outputs</h3> <p>A VCF sorted (i) according to the dictionary and (ii) by coordiante.</p> <h3>Usage examples</h3> <h4>Example 1:</h4> <p>We combine several variant files in different formats, where at least one of them contains the contig list in its header.</p> <pre>java -jar picard.jar MergeVcfs \\\n          I=input_variants.01.vcf \\\n          I=input_variants.02.vcf.gz \\\n          O=output_variants.vcf.gz</pre> <h4>Example 2:</h4> <p>Similar to example 1 but we use an input list file to specify the input files:</p> <pre>java -jar picard.jar MergeVcfs \\\n          I=input_variant_files.list \\\n          O=output_variants.vcf.gz</pre><hr/>";
    @Argument(shortName="I", doc="VCF or BCF input files (File format is determined by file extension), or a file having a '.list' suffix containing the path to the files, one per line.", minElements=1)
    public List<File> INPUT;
    @Argument(shortName="O", doc="The merged VCF or BCF file. File format is determined by file extension.")
    public File OUTPUT;
    @Argument(shortName="D", doc="The index sequence dictionary to use instead of the sequence dictionary in the input files", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(MergeVcfs.class);

    public static void main(String[] argv) {
        new MergeVcfs().instanceMainWithExit(argv);
    }

    public MergeVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ProgressLogger progress = new ProgressLogger(this.log, 10000);
        ArrayList sampleList = new ArrayList();
        this.INPUT = IOUtil.unrollFiles(this.INPUT, (String[])IOUtil.VCF_EXTENSIONS);
        ArrayList<CloseableIterator> iteratorCollection = new ArrayList<CloseableIterator>(this.INPUT.size());
        HashSet<VCFHeader> headers = new HashSet<VCFHeader>(this.INPUT.size());
        VariantContextComparator variantContextComparator = null;
        SAMSequenceDictionary sequenceDictionary = null;
        if (this.SEQUENCE_DICTIONARY != null) {
            sequenceDictionary = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.SEQUENCE_DICTIONARY).getFileHeader().getSequenceDictionary();
        }
        for (File file : this.INPUT) {
            IOUtil.assertFileIsReadable((File)file);
            VCFFileReader fileReader = new VCFFileReader(file, false);
            VCFHeader fileHeader = fileReader.getFileHeader();
            if (variantContextComparator == null) {
                variantContextComparator = fileHeader.getVCFRecordComparator();
            } else if (!variantContextComparator.isCompatible((Collection)fileHeader.getContigLines())) {
                throw new IllegalArgumentException("The contig entries in input file " + file.getAbsolutePath() + " are not compatible with the others.");
            }
            if (sequenceDictionary == null) {
                sequenceDictionary = fileHeader.getSequenceDictionary();
            }
            if (sampleList.isEmpty()) {
                sampleList.addAll(fileHeader.getSampleNamesInOrder());
            } else if (!sampleList.equals(fileHeader.getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + file.getAbsolutePath() + " has sample entries that don't match the other files.");
            }
            headers.add(fileHeader);
            iteratorCollection.add(fileReader.iterator());
        }
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sequenceDictionary);
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        } else {
            builder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter writer = builder.build();
        writer.writeHeader(new VCFHeader(VCFUtils.smartMergeHeaders(headers, (boolean)false), sampleList));
        MergingIterator mergingIterator = new MergingIterator((Comparator)variantContextComparator, iteratorCollection);
        while (mergingIterator.hasNext()) {
            VariantContext context = (VariantContext)mergingIterator.next();
            writer.add(context);
            progress.record(context.getContig(), context.getStart());
        }
        CloserUtil.close((Object)mergingIterator);
        writer.close();
        return 0;
    }
}

