/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamPairUtil;
import java.util.EnumSet;
import java.util.Set;

public class ChimeraUtil {
    public static int DEFAULT_INSERT_SIZE_LIMIT = 100000;
    public static Set<SamPairUtil.PairOrientation> DEFAULT_EXPECTED_ORIENTATIONS = EnumSet.of(SamPairUtil.PairOrientation.FR);

    public static boolean isChimeric(SAMRecord sAMRecord, int n, Set<SamPairUtil.PairOrientation> set) {
        return ChimeraUtil.isMappedPair(sAMRecord) && (Math.abs(sAMRecord.getInferredInsertSize()) > n || !sAMRecord.getReferenceIndex().equals(sAMRecord.getMateReferenceIndex()) || !ChimeraUtil.matchesExpectedOrientations(sAMRecord, set));
    }

    public static boolean isChimeric(SAMRecord sAMRecord, SAMRecord sAMRecord2, int n, Set<SamPairUtil.PairOrientation> set) {
        return ChimeraUtil.isMappedPair(sAMRecord) && (Math.abs(sAMRecord.getInferredInsertSize()) > n || !sAMRecord.getReferenceIndex().equals(sAMRecord2.getReferenceIndex()) || !ChimeraUtil.matchesExpectedOrientations(sAMRecord, set) || sAMRecord2.getAttribute("SA") != null);
    }

    private static boolean isMappedPair(SAMRecord sAMRecord) {
        return sAMRecord.getReadPairedFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag();
    }

    private static boolean matchesExpectedOrientations(SAMRecord sAMRecord, Set<SamPairUtil.PairOrientation> set) {
        return set.contains(SamPairUtil.getPairOrientation((SAMRecord)sAMRecord)) && sAMRecord.getAttribute("SA") == null;
    }
}

