/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Collect metrics about reads that pass quality thresholds and Illumina-specific filters.  This tool evaluates the overall quality of reads within a bam file containing one read group. The output indicates the total numbers of bases within a read group that pass a minimum base quality score threshold and (in the case of Illumina data) pass Illumina quality filters as described in the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. <br /><h4>Note on base quality score options</h4>If the quality score of read bases has been modified in a previous data processing step such as <a href='https://www.broadinstitute.org/gatk/guide/article?id=44'>GATK Base Recalibration</a> and an OQ tag is available, this tool can be set to use the OQ value instead of the primary quality value for the evaluation. <br /><br />Note that the default behaviour of this program changed as of November 6th 2015 to no longer include secondary and supplemental alignments in the computation. <br /><h4>Usage Example:</h4><pre>java -jar picard.jar CollectQualityYieldMetrics \\<br />       I=input.bam \\<br />       O=quality_yield_metrics.txt \\<br /></pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectQualityYieldMetrics.QualityYieldMetrics'>the QualityYieldMetrics documentation</a> for details and explanations of the output metrics.<hr />", usageShort="Collect metrics about reads that pass quality thresholds and Illumina-specific filters.  ", programGroup=Metrics.class)
public class CollectQualityYieldMetrics
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "Collect metrics about reads that pass quality thresholds and Illumina-specific filters.  ";
    static final String USAGE_DETAILS = "This tool evaluates the overall quality of reads within a bam file containing one read group. The output indicates the total numbers of bases within a read group that pass a minimum base quality score threshold and (in the case of Illumina data) pass Illumina quality filters as described in the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. <br /><h4>Note on base quality score options</h4>If the quality score of read bases has been modified in a previous data processing step such as <a href='https://www.broadinstitute.org/gatk/guide/article?id=44'>GATK Base Recalibration</a> and an OQ tag is available, this tool can be set to use the OQ value instead of the primary quality value for the evaluation. <br /><br />Note that the default behaviour of this program changed as of November 6th 2015 to no longer include secondary and supplemental alignments in the computation. <br /><h4>Usage Example:</h4><pre>java -jar picard.jar CollectQualityYieldMetrics \\<br />       I=input.bam \\<br />       O=quality_yield_metrics.txt \\<br /></pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectQualityYieldMetrics.QualityYieldMetrics'>the QualityYieldMetrics documentation</a> for details and explanations of the output metrics.<hr />";
    @Option(shortName="OQ", doc="If available in the OQ tag, use the original quality scores as inputs instead of the quality scores in the QUAL field.")
    public boolean USE_ORIGINAL_QUALITIES = true;
    @Option(doc="If true, include bases from secondary alignments in metrics. Setting to true may cause double-counting of bases if there are secondary alignments in the input file.")
    public boolean INCLUDE_SECONDARY_ALIGNMENTS = false;
    @Option(doc="If true, include bases from supplemental alignments in metrics. Setting to true may cause double-counting of bases if there are supplemental alignments in the input file.")
    public boolean INCLUDE_SUPPLEMENTAL_ALIGNMENTS = false;
    private final QualityYieldMetrics metrics = new QualityYieldMetrics();

    @Override
    protected boolean usesNoRefReads() {
        return true;
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        byte[] byArray;
        boolean bl;
        if (!this.INCLUDE_SECONDARY_ALIGNMENTS && sAMRecord.getNotPrimaryAlignmentFlag()) {
            return;
        }
        if (!this.INCLUDE_SUPPLEMENTAL_ALIGNMENTS && sAMRecord.getSupplementaryAlignmentFlag()) {
            return;
        }
        int n = sAMRecord.getReadLength();
        ++this.metrics.TOTAL_READS;
        this.metrics.TOTAL_BASES += (long)n;
        boolean bl2 = bl = !sAMRecord.getReadFailsVendorQualityCheckFlag();
        if (bl) {
            ++this.metrics.PF_READS;
            this.metrics.PF_BASES += (long)n;
        }
        if (this.USE_ORIGINAL_QUALITIES) {
            byte[] byArray2 = sAMRecord.getOriginalBaseQualities();
            if (byArray2 == null) {
                byArray2 = sAMRecord.getBaseQualities();
            }
            byArray = byArray2;
        } else {
            byArray = sAMRecord.getBaseQualities();
        }
        for (byte by : byArray) {
            this.metrics.Q20_EQUIVALENT_YIELD += (long)by;
            if (by >= 20) {
                ++this.metrics.Q20_BASES;
            }
            if (by >= 30) {
                ++this.metrics.Q30_BASES;
            }
            if (!bl) continue;
            this.metrics.PF_Q20_EQUIVALENT_YIELD += (long)by;
            if (by >= 20) {
                ++this.metrics.PF_Q20_BASES;
            }
            if (by < 30) continue;
            ++this.metrics.PF_Q30_BASES;
        }
    }

    @Override
    protected void finish() {
        MetricsFile metricsFile = this.getMetricsFile();
        this.metrics.READ_LENGTH = this.metrics.TOTAL_READS == 0 ? 0 : (int)(this.metrics.TOTAL_BASES / (long)this.metrics.TOTAL_READS);
        this.metrics.Q20_EQUIVALENT_YIELD /= 20L;
        this.metrics.PF_Q20_EQUIVALENT_YIELD /= 20L;
        metricsFile.addMetric((MetricBase)this.metrics);
        metricsFile.write(this.OUTPUT);
    }

    public static class QualityYieldMetrics
    extends MetricBase {
        public int TOTAL_READS = 0;
        public int PF_READS = 0;
        public int READ_LENGTH = 0;
        public long TOTAL_BASES;
        public long PF_BASES = 0L;
        public long Q20_BASES = 0L;
        public long PF_Q20_BASES = 0L;
        public long Q30_BASES = 0L;
        public long PF_Q30_BASES = 0L;
        public long Q20_EQUIVALENT_YIELD = 0L;
        public long PF_Q20_EQUIVALENT_YIELD = 0L;
    }
}

