/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.BAMRecord;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import picard.analysis.AdapterUtility;
import picard.analysis.ChimeraUtil;
import picard.analysis.CollectWgsMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.QuerySortedReadPairIteratorUtil;

@Deprecated
@CommandLineProgramProperties(usage="Computes a number of metrics that are useful for evaluating coverage and performance of sequencing experiments.", usageShort="Writes sequencing-related metrics for a SAM or BAM file", programGroup=Metrics.class)
public class CollectWgsMetricsFromQuerySorted
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="Output metrics file.")
    public File OUTPUT;
    @Option(shortName="USABLE_MQ", doc="Minimum mapping quality for a read to contribute to usable coverage.", overridable=true, optional=true)
    public int MINIMUM_USABLE_MAPPING_QUALITY = 20;
    @Option(shortName="USABLE_Q", doc="Minimum base quality for a base to contribute to usable coverage.", overridable=true, optional=true)
    public int MINIMUM_USABLE_BASE_QUALITY = 20;
    @Option(shortName="RAW_MQ", doc="Minimum mapping quality for a read to contribute to raw coverage.", overridable=true, optional=true)
    public int MINIMUM_RAW_MAPPING_QUALITY = 0;
    @Option(shortName="RAW_Q", doc="Minimum base quality for a base to contribute to raw coverage.", overridable=true, optional=true)
    public int MINIMUM_RAW_BASE_QUALITY = 3;
    @Option(doc="The number of bases in the genome build of the input file to be used for calculating MEAN_COVERAGE. If not provided, we will assume that ALL bases in the genome should be used (including e.g. Ns)", overridable=true, optional=true)
    public Long GENOME_TERRITORY = null;
    private final Log log = Log.getInstance(CollectWgsMetricsFromQuerySorted.class);
    private AdapterUtility adapterUtility;

    public static void main(String[] stringArray) {
        new CollectWgsMetricsFromQuerySorted().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        long l;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 50000000, "Processed", "read pairs");
        SamReader samReader = SamReaderFactory.makeDefault().open(this.INPUT);
        PeekableIterator peekableIterator = new PeekableIterator((Iterator)samReader.iterator());
        IntermediateMetrics intermediateMetrics = new IntermediateMetrics();
        intermediateMetrics.metrics.TYPE = FILTERING_STRINGENCY.USABLE;
        IntermediateMetrics intermediateMetrics2 = new IntermediateMetrics();
        intermediateMetrics2.metrics.TYPE = FILTERING_STRINGENCY.RAW;
        this.adapterUtility = new AdapterUtility(AdapterUtility.DEFAULT_ADAPTER_SEQUENCE);
        QuerySortedReadPairIteratorUtil.ReadPair readPair = QuerySortedReadPairIteratorUtil.getNextReadPair((PeekableIterator<SAMRecord>)peekableIterator);
        while (readPair != null) {
            this.calculateMetricsForRead(readPair, intermediateMetrics, this.MINIMUM_USABLE_MAPPING_QUALITY, this.MINIMUM_USABLE_BASE_QUALITY);
            this.calculateMetricsForRead(readPair, intermediateMetrics2, this.MINIMUM_RAW_MAPPING_QUALITY, this.MINIMUM_RAW_BASE_QUALITY);
            progressLogger.record(readPair.read1);
            readPair = QuerySortedReadPairIteratorUtil.getNextReadPair((PeekableIterator<SAMRecord>)peekableIterator);
        }
        intermediateMetrics.metrics.GENOME_TERRITORY = l = this.GENOME_TERRITORY == null || this.GENOME_TERRITORY < 1L ? samReader.getFileHeader().getSequenceDictionary().getReferenceLength() : this.GENOME_TERRITORY.longValue();
        this.finalizeMetrics(intermediateMetrics);
        intermediateMetrics2.metrics.GENOME_TERRITORY = l;
        this.finalizeMetrics(intermediateMetrics2);
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addMetric((MetricBase)intermediateMetrics.metrics);
        metricsFile.addMetric((MetricBase)intermediateMetrics2.metrics);
        metricsFile.write(this.OUTPUT);
        return 0;
    }

    private void calculateMetricsForRead(QuerySortedReadPairIteratorUtil.ReadPair readPair, IntermediateMetrics intermediateMetrics, int n, int n2) {
        if (readPair.read1.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        boolean bl = readPair.read2 != null;
        int n3 = readPair.read1.getReadLength();
        int n4 = bl ? readPair.read2.getReadLength() : 0;
        int n5 = n3 + n4;
        intermediateMetrics.metrics.PF_BASES += (long)n5;
        if (this.isNoiseRead(readPair.read1)) {
            ++intermediateMetrics.metrics.PF_NOISE_READS;
        }
        if (!readPair.read1.getReadUnmappedFlag()) {
            ++intermediateMetrics.metrics.PF_READS_ALIGNED;
        } else if (this.isAdapterRead(readPair.read1)) {
            ++intermediateMetrics.metrics.PF_ADAPTER_READS;
        }
        if (bl) {
            ++intermediateMetrics.metrics.PF_READ_PAIRS;
            if (!readPair.read2.getReadUnmappedFlag()) {
                ++intermediateMetrics.metrics.PF_READS_ALIGNED;
            } else if (this.isAdapterRead(readPair.read2)) {
                ++intermediateMetrics.metrics.PF_ADAPTER_READS;
            }
            if (this.isChimericReadPair(readPair, n)) {
                ++intermediateMetrics.metrics.PF_CHIMERIC_PAIRS;
            }
        }
        if (!bl || readPair.read1.getMateUnmappedFlag() || readPair.read2.getMateUnmappedFlag()) {
            intermediateMetrics.basesExcludedByPairing += (long)n5;
        } else if (readPair.read1.getDuplicateReadFlag()) {
            ++intermediateMetrics.metrics.PF_DUPE_PAIRS;
            intermediateMetrics.basesExcludedByDupes += (long)n5;
        } else {
            int n6;
            BaseExclusionHelper baseExclusionHelper = this.determineBaseExclusions(readPair.read1, n, n2);
            BaseExclusionHelper baseExclusionHelper2 = this.determineBaseExclusions(readPair.read2, n, n2);
            intermediateMetrics.basesExcludedByMapq += (long)(baseExclusionHelper.basesExcludedByMapq + baseExclusionHelper2.basesExcludedByMapq);
            intermediateMetrics.basesExcludedByBaseq += (long)(baseExclusionHelper.lowBQcount + baseExclusionHelper2.lowBQcount);
            int n7 = n5;
            n7 -= baseExclusionHelper.basesExcludedByMapq + baseExclusionHelper.lowBQcount;
            n7 -= baseExclusionHelper2.basesExcludedByMapq + baseExclusionHelper2.lowBQcount;
            if (baseExclusionHelper.basesExcludedByMapq == 0 && baseExclusionHelper2.basesExcludedByMapq == 0) {
                n6 = this.getOverlappingBaseCount(baseExclusionHelper, baseExclusionHelper2, n2);
                intermediateMetrics.basesExcludedByOverlap += (long)n6;
                n7 -= n6;
            }
            intermediateMetrics.metrics.PF_PASSING_BASES += (long)n7;
            n6 = Math.abs(readPair.read1.getInferredInsertSize());
            if (n6 > 0 && readPair.read1.getProperPairFlag()) {
                ++intermediateMetrics.metrics.PF_ORIENTED_PAIRS;
                intermediateMetrics.insertSizeSum += (double)n6;
            }
        }
    }

    private void finalizeMetrics(IntermediateMetrics intermediateMetrics) {
        this.setUnusedMetrics(intermediateMetrics.metrics);
        intermediateMetrics.metrics.MEAN_COVERAGE = (double)intermediateMetrics.metrics.PF_PASSING_BASES / (double)intermediateMetrics.metrics.GENOME_TERRITORY;
        intermediateMetrics.metrics.PCT_EXC_DUPE = (double)intermediateMetrics.basesExcludedByDupes / (double)intermediateMetrics.metrics.PF_BASES;
        intermediateMetrics.metrics.PCT_EXC_MAPQ = (double)intermediateMetrics.basesExcludedByMapq / (double)intermediateMetrics.metrics.PF_BASES;
        intermediateMetrics.metrics.PCT_EXC_UNPAIRED = (double)intermediateMetrics.basesExcludedByPairing / (double)intermediateMetrics.metrics.PF_BASES;
        intermediateMetrics.metrics.PCT_EXC_BASEQ = (double)intermediateMetrics.basesExcludedByBaseq / (double)intermediateMetrics.metrics.PF_BASES;
        intermediateMetrics.metrics.PCT_EXC_OVERLAP = (double)intermediateMetrics.basesExcludedByOverlap / (double)intermediateMetrics.metrics.PF_BASES;
        double d = intermediateMetrics.metrics.PF_BASES - intermediateMetrics.metrics.PF_PASSING_BASES;
        intermediateMetrics.metrics.PCT_EXC_TOTAL = d / (double)intermediateMetrics.metrics.PF_BASES;
        intermediateMetrics.metrics.MEAN_INSERT_SIZE = intermediateMetrics.insertSizeSum / (double)intermediateMetrics.metrics.PF_ORIENTED_PAIRS;
    }

    private boolean isNoiseRead(SAMRecord sAMRecord) {
        Object object = sAMRecord.getAttribute("XN");
        return object != null && object.equals(1);
    }

    private boolean isAdapterRead(SAMRecord sAMRecord) {
        byte[] byArray = sAMRecord.getReadBases();
        if (!(sAMRecord instanceof BAMRecord)) {
            StringUtil.toUpperCase((byte[])byArray);
        }
        return this.adapterUtility.isAdapterSequence(byArray);
    }

    private boolean isChimericReadPair(QuerySortedReadPairIteratorUtil.ReadPair readPair, int n) {
        return readPair.read1.getMappingQuality() >= n && readPair.read2.getMappingQuality() >= n && ChimeraUtil.isChimeric(readPair.read1, readPair.read2, ChimeraUtil.DEFAULT_INSERT_SIZE_LIMIT, ChimeraUtil.DEFAULT_EXPECTED_ORIENTATIONS);
    }

    private int getLowQualityOrSoftclipBaseCount(BaseExclusionHelper baseExclusionHelper, int n) {
        byte[] byArray = baseExclusionHelper.read.getBaseQualities();
        int n2 = baseExclusionHelper.firstUnclippedBaseIndex + (byArray.length - baseExclusionHelper.firstTrailingClippedBaseIndex);
        for (int i = baseExclusionHelper.firstUnclippedBaseIndex; i < baseExclusionHelper.firstTrailingClippedBaseIndex; ++i) {
            if (byArray[i] >= n) continue;
            ++n2;
        }
        return n2;
    }

    private void setUnusedMetrics(QuerySortedSeqMetrics querySortedSeqMetrics) {
        querySortedSeqMetrics.SD_COVERAGE = -1.0;
        querySortedSeqMetrics.MEDIAN_COVERAGE = -1.0;
        querySortedSeqMetrics.MAD_COVERAGE = -1.0;
        querySortedSeqMetrics.PCT_1X = -1.0;
        querySortedSeqMetrics.PCT_5X = -1.0;
        querySortedSeqMetrics.PCT_10X = -1.0;
        querySortedSeqMetrics.PCT_15X = -1.0;
        querySortedSeqMetrics.PCT_20X = -1.0;
        querySortedSeqMetrics.PCT_25X = -1.0;
        querySortedSeqMetrics.PCT_30X = -1.0;
        querySortedSeqMetrics.PCT_40X = -1.0;
        querySortedSeqMetrics.PCT_50X = -1.0;
        querySortedSeqMetrics.PCT_60X = -1.0;
        querySortedSeqMetrics.PCT_70X = -1.0;
        querySortedSeqMetrics.PCT_80X = -1.0;
        querySortedSeqMetrics.PCT_90X = -1.0;
        querySortedSeqMetrics.PCT_100X = -1.0;
        querySortedSeqMetrics.PCT_EXC_CAPPED = -1.0;
    }

    private int getOverlappingBaseCount(BaseExclusionHelper baseExclusionHelper, BaseExclusionHelper baseExclusionHelper2, int n) {
        if (baseExclusionHelper2.read.getAlignmentStart() < baseExclusionHelper.read.getAlignmentStart()) {
            return this.getOverlappingBaseCount(baseExclusionHelper2, baseExclusionHelper, n);
        }
        if (baseExclusionHelper.read.getAlignmentEnd() < baseExclusionHelper2.read.getAlignmentStart() || !baseExclusionHelper.read.getReferenceIndex().equals(baseExclusionHelper2.read.getReferenceIndex())) {
            return 0;
        }
        byte[] byArray = baseExclusionHelper.read.getBaseQualities();
        byte[] byArray2 = baseExclusionHelper2.read.getBaseQualities();
        int n2 = baseExclusionHelper.read.getReadPositionAtReferencePosition(baseExclusionHelper2.read.getAlignmentStart(), true) - 1;
        int n3 = baseExclusionHelper.firstTrailingClippedBaseIndex - n2;
        int n4 = Math.min(n3, baseExclusionHelper2.firstTrailingClippedBaseIndex - baseExclusionHelper2.firstUnclippedBaseIndex);
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = baseExclusionHelper.firstTrailingClippedBaseIndex - n4 + i;
            int n7 = baseExclusionHelper2.firstUnclippedBaseIndex + i;
            if (byArray[n6] < n || byArray2[n7] < n) continue;
            ++n5;
        }
        return n5;
    }

    private BaseExclusionHelper determineBaseExclusions(SAMRecord sAMRecord, int n, int n2) {
        BaseExclusionHelper baseExclusionHelper = new BaseExclusionHelper(sAMRecord);
        if (sAMRecord.getMappingQuality() < n) {
            baseExclusionHelper.basesExcludedByMapq = sAMRecord.getReadLength();
        } else {
            baseExclusionHelper.lowBQcount = this.getLowQualityOrSoftclipBaseCount(baseExclusionHelper, n2);
        }
        return baseExclusionHelper;
    }

    private static class BaseExclusionHelper {
        public SAMRecord read;
        public int firstUnclippedBaseIndex;
        public int firstTrailingClippedBaseIndex;
        public int basesExcludedByMapq = 0;
        public int lowBQcount = 0;

        public BaseExclusionHelper(SAMRecord sAMRecord) {
            CigarOperator cigarOperator;
            this.read = sAMRecord;
            List list = sAMRecord.getCigar().getCigarElements();
            this.firstUnclippedBaseIndex = 0;
            for (CigarElement cigarElement : list) {
                cigarOperator = cigarElement.getOperator();
                if (cigarOperator == CigarOperator.SOFT_CLIP) {
                    this.firstUnclippedBaseIndex = cigarElement.getLength();
                    continue;
                }
                if (cigarOperator == CigarOperator.HARD_CLIP) continue;
                break;
            }
            this.firstTrailingClippedBaseIndex = sAMRecord.getReadLength();
            for (int i = list.size() - 1; i >= 0; --i) {
                CigarElement cigarElement;
                cigarElement = (CigarElement)list.get(i);
                cigarOperator = cigarElement.getOperator();
                if (cigarOperator == CigarOperator.SOFT_CLIP) {
                    this.firstTrailingClippedBaseIndex -= cigarElement.getLength();
                    continue;
                }
                if (cigarOperator != CigarOperator.HARD_CLIP) break;
            }
        }
    }

    private class IntermediateMetrics {
        final QuerySortedSeqMetrics metrics = new QuerySortedSeqMetrics();
        long basesExcludedByDupes = 0L;
        long basesExcludedByMapq = 0L;
        long basesExcludedByPairing = 0L;
        long basesExcludedByBaseq = 0L;
        long basesExcludedByOverlap = 0L;
        double insertSizeSum = 0.0;

        private IntermediateMetrics() {
        }
    }

    public static class QuerySortedSeqMetrics
    extends CollectWgsMetrics.WgsMetrics {
        public FILTERING_STRINGENCY TYPE;
        public long PF_BASES = 0L;
        public long PF_PASSING_BASES = 0L;
        public long PF_READ_PAIRS = 0L;
        public long PF_DUPE_PAIRS = 0L;
        public long PF_READS_ALIGNED = 0L;
        public long PF_NOISE_READS = 0L;
        public long PF_CHIMERIC_PAIRS = 0L;
        public long PF_ADAPTER_READS = 0L;
        public long PF_ORIENTED_PAIRS = 0L;
        public double MEAN_INSERT_SIZE = 0.0;
    }

    public static enum FILTERING_STRINGENCY {
        RAW,
        USABLE;

    }
}

