/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.List;
import picard.PicardException;
import picard.analysis.CollectWgsMetrics;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Alpha;
import picard.filter.CountingFilter;
import picard.filter.CountingPairedFilter;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.This tool collects metrics about the percentages of reads that pass base- and mapping- quality filters as well as coverage (read-depth) levels. Both minimum base- and mapping-quality values as well as the maximum read depths (coverage cap) are user defined.  This extends CollectWgsMetrics by including metrics related only to siteswith non-zero (>0) coverage.<h4>Usage Example:</h4><pre>java -jar picard.jar CollectWgsMetricsWithNonZeroCoverage \\<br />       I=input.bam \\<br />       O=collect_wgs_metrics.txt \\<br />       CHART=collect_wgs_metrics.pdf  \\<br />       R=reference_sequence.fasta </pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetricsWithNonZeroCoverage.WgsMetricsWithNonZeroCoverage'>the WgsMetricsWithNonZeroCoverage documentation</a> for detailed explanations of the output metrics.<hr />", usageShort="Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.", programGroup=Alpha.class)
public class CollectWgsMetricsWithNonZeroCoverage
extends CollectWgsMetrics {
    static final String USAGE_SUMMARY = "Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.";
    static final String USAGE_DETAILS = "This tool collects metrics about the percentages of reads that pass base- and mapping- quality filters as well as coverage (read-depth) levels. Both minimum base- and mapping-quality values as well as the maximum read depths (coverage cap) are user defined.  This extends CollectWgsMetrics by including metrics related only to siteswith non-zero (>0) coverage.<h4>Usage Example:</h4><pre>java -jar picard.jar CollectWgsMetricsWithNonZeroCoverage \\<br />       I=input.bam \\<br />       O=collect_wgs_metrics.txt \\<br />       CHART=collect_wgs_metrics.pdf  \\<br />       R=reference_sequence.fasta </pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetricsWithNonZeroCoverage.WgsMetricsWithNonZeroCoverage'>the WgsMetricsWithNonZeroCoverage documentation</a> for detailed explanations of the output metrics.<hr />";
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    private final Log log = Log.getInstance(CollectWgsMetricsWithNonZeroCoverage.class);
    private WgsMetricsWithNonZeroCoverageCollector collector = null;

    public static void main(String[] stringArray) {
        new CollectWgsMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        this.collector = new WgsMetricsWithNonZeroCoverageCollector(this.COVERAGE_CAP);
        List list = this.getSamFileHeader().getReadGroups();
        String string = list.size() == 1 ? StringUtil.asEmptyIfNull((Object)((SAMReadGroupRecord)list.get(0)).getLibrary()) : "";
        super.doWork();
        if (this.collector.areHistogramsEmpty()) {
            this.log.warn(new Object[]{"No valid bases found in input file. No plot will be produced."});
        } else {
            int n = RExecutor.executeFromClasspath("picard/analysis/wgsHistogram.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), string);
            if (n != 0) {
                throw new PicardException("R script wgsHistogram.R failed with return code " + n);
            }
        }
        return 0;
    }

    @Override
    protected WgsMetricsWithNonZeroCoverage generateWgsMetrics() {
        return new WgsMetricsWithNonZeroCoverage();
    }

    @Override
    protected CollectWgsMetrics.WgsMetricsCollector getCollector(int n) {
        assert (n == this.collector.coverageCap);
        return this.collector;
    }

    protected class WgsMetricsWithNonZeroCoverageCollector
    extends CollectWgsMetrics.WgsMetricsCollector {
        Histogram<Integer> depthHistogram;

        public WgsMetricsWithNonZeroCoverageCollector(int n) {
            super(n);
            this.depthHistogram = null;
        }

        @Override
        public void addToMetricsFile(MetricsFile<CollectWgsMetrics.WgsMetrics, Integer> metricsFile, boolean bl, CountingFilter countingFilter, CountingFilter countingFilter2, CountingPairedFilter countingPairedFilter) {
            this.depthHistogram = this.getDepthHistogram();
            Histogram<Integer> histogram = this.depthHistogramNonZero();
            WgsMetricsWithNonZeroCoverage wgsMetricsWithNonZeroCoverage = (WgsMetricsWithNonZeroCoverage)this.getMetrics(this.depthHistogram, countingFilter, countingFilter2, countingPairedFilter);
            WgsMetricsWithNonZeroCoverage wgsMetricsWithNonZeroCoverage2 = (WgsMetricsWithNonZeroCoverage)this.getMetrics(histogram, countingFilter, countingFilter2, countingPairedFilter);
            wgsMetricsWithNonZeroCoverage.CATEGORY = WgsMetricsWithNonZeroCoverage.Category.WHOLE_GENOME;
            wgsMetricsWithNonZeroCoverage2.CATEGORY = WgsMetricsWithNonZeroCoverage.Category.NON_ZERO_REGIONS;
            metricsFile.addMetric((MetricBase)wgsMetricsWithNonZeroCoverage);
            metricsFile.addMetric((MetricBase)wgsMetricsWithNonZeroCoverage2);
            if (bl) {
                this.addBaseQHistogram(metricsFile);
            }
        }

        private Histogram<Integer> depthHistogramNonZero() {
            Histogram histogram = new Histogram("coverage", "count");
            for (int i = 1; i < this.histogramArray.length; ++i) {
                histogram.increment((Comparable)Integer.valueOf(i), (double)this.histogramArray[i]);
            }
            return histogram;
        }

        public boolean areHistogramsEmpty() {
            return null == this.depthHistogram || this.depthHistogram.isEmpty();
        }
    }

    public static class WgsMetricsWithNonZeroCoverage
    extends CollectWgsMetrics.WgsMetrics {
        public Category CATEGORY;

        public static enum Category {
            WHOLE_GENOME,
            NON_ZERO_REGIONS;

        }
    }
}

