/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import picard.PicardException;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Collect mean quality by cycle.This tool generates a data table and chart of mean quality by cycle from a BAM file. It is intended to be used on a single lane or read group's worth of data, but can be applied to merged BAMs if needed. <br /><br />This metric gives an overall snapshot of sequencing machine performance. For most types of sequencing data, the output is expected to show a slight reduction in overall base quality scores towards the end of each read. Spikes in quality within reads are not expected and may indicate that technical problems occurred during sequencing.<br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar MeanQualityByCycle \\<br />      I=input.bam \\<br />      O=mean_qual_by_cycle.txt \\<br />      CHART=mean_qual_by_cycle.pdf</pre><hr />", usageShort="Collect mean quality by cycle.", programGroup=Metrics.class)
public class MeanQualityByCycle
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "Collect mean quality by cycle.";
    static final String USAGE_DETAILS = "This tool generates a data table and chart of mean quality by cycle from a BAM file. It is intended to be used on a single lane or read group's worth of data, but can be applied to merged BAMs if needed. <br /><br />This metric gives an overall snapshot of sequencing machine performance. For most types of sequencing data, the output is expected to show a slight reduction in overall base quality scores towards the end of each read. Spikes in quality within reads are not expected and may indicate that technical problems occurred during sequencing.<br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar MeanQualityByCycle \\<br />      I=input.bam \\<br />      O=mean_qual_by_cycle.txt \\<br />      CHART=mean_qual_by_cycle.pdf</pre><hr />";
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Option(doc="If set to true, calculate mean quality over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="If set to true calculate mean quality over PF reads only.")
    public boolean PF_READS_ONLY = false;
    private final HistogramGenerator q = new HistogramGenerator(false);
    private final HistogramGenerator oq = new HistogramGenerator(true);
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(MeanQualityByCycle.class);

    public static void main(String[] stringArray) {
        System.exit(new MeanQualityByCycle().instanceMain(stringArray));
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        List list = sAMFileHeader.getReadGroups();
        if (list.size() == 1) {
            this.plotSubtitle = StringUtil.asEmptyIfNull((Object)((SAMReadGroupRecord)list.get(0)).getLibrary());
        }
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        if (this.PF_READS_ONLY && sAMRecord.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && sAMRecord.getReadUnmappedFlag()) {
            return;
        }
        if (sAMRecord.isSecondaryOrSupplementary()) {
            return;
        }
        this.q.addRecord(sAMRecord);
        this.oq.addRecord(sAMRecord);
    }

    @Override
    protected void finish() {
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addHistogram(this.q.getMeanQualityHistogram());
        if (!this.oq.isEmpty()) {
            metricsFile.addHistogram(this.oq.getMeanQualityHistogram());
        }
        metricsFile.write(this.OUTPUT);
        if (this.q.isEmpty() && this.oq.isEmpty()) {
            this.log.warn(new Object[]{"No valid bases found in input file. No plot will be produced."});
        } else {
            int n = RExecutor.executeFromClasspath("picard/analysis/meanQualityByCycle.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle);
            if (n != 0) {
                throw new PicardException("R script meanQualityByCycle.R failed with return code " + n);
            }
        }
    }

    private static final class HistogramGenerator {
        final boolean useOriginalQualities;
        int maxLengthSoFar = 0;
        double[] firstReadTotalsByCycle = new double[this.maxLengthSoFar];
        long[] firstReadCountsByCycle = new long[this.maxLengthSoFar];
        double[] secondReadTotalsByCycle = new double[this.maxLengthSoFar];
        long[] secondReadCountsByCycle = new long[this.maxLengthSoFar];

        private HistogramGenerator(boolean bl) {
            this.useOriginalQualities = bl;
        }

        void addRecord(SAMRecord sAMRecord) {
            byte[] byArray;
            byte[] byArray2 = byArray = this.useOriginalQualities ? sAMRecord.getOriginalBaseQualities() : sAMRecord.getBaseQualities();
            if (byArray == null) {
                return;
            }
            int n = byArray.length;
            boolean bl = sAMRecord.getReadNegativeStrandFlag();
            this.ensureArraysBigEnough(n + 1);
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3 = n2 = bl ? n - i : i + 1;
                if (sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag()) {
                    int n4 = n2;
                    this.secondReadTotalsByCycle[n4] = this.secondReadTotalsByCycle[n4] + (double)byArray[i];
                    int n5 = n2;
                    this.secondReadCountsByCycle[n5] = this.secondReadCountsByCycle[n5] + 1L;
                    continue;
                }
                int n6 = n2;
                this.firstReadTotalsByCycle[n6] = this.firstReadTotalsByCycle[n6] + (double)byArray[i];
                int n7 = n2;
                this.firstReadCountsByCycle[n7] = this.firstReadCountsByCycle[n7] + 1L;
            }
        }

        private void ensureArraysBigEnough(int n) {
            if (n > this.maxLengthSoFar) {
                this.firstReadTotalsByCycle = Arrays.copyOf(this.firstReadTotalsByCycle, n);
                this.firstReadCountsByCycle = Arrays.copyOf(this.firstReadCountsByCycle, n);
                this.secondReadTotalsByCycle = Arrays.copyOf(this.secondReadTotalsByCycle, n);
                this.secondReadCountsByCycle = Arrays.copyOf(this.secondReadCountsByCycle, n);
                this.maxLengthSoFar = n;
            }
        }

        Histogram<Integer> getMeanQualityHistogram() {
            int n;
            String string = this.useOriginalQualities ? "MEAN_ORIGINAL_QUALITY" : "MEAN_QUALITY";
            Histogram histogram = new Histogram("CYCLE", string);
            int n2 = 0;
            for (n = 0; n < this.firstReadTotalsByCycle.length; ++n) {
                if (!(this.firstReadTotalsByCycle[n] > 0.0)) continue;
                histogram.increment((Comparable)Integer.valueOf(n), this.firstReadTotalsByCycle[n] / (double)this.firstReadCountsByCycle[n]);
                n2 = n;
            }
            for (n = 0; n < this.secondReadTotalsByCycle.length; ++n) {
                if (this.secondReadCountsByCycle[n] <= 0L) continue;
                int n3 = n2 + n;
                histogram.increment((Comparable)Integer.valueOf(n3), this.secondReadTotalsByCycle[n] / (double)this.secondReadCountsByCycle[n]);
            }
            return histogram;
        }

        boolean isEmpty() {
            return this.maxLengthSoFar == 0;
        }
    }
}

