/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;

public abstract class SinglePassSamProgram
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="File to write the output to.")
    public File OUTPUT;
    @Option(doc="If true (default), then the sort order in the header file will be ignored.", shortName="AS")
    public boolean ASSUME_SORTED = true;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public long STOP_AFTER = 0L;
    private static final Log log = Log.getInstance(SinglePassSamProgram.class);

    @Override
    protected final int doWork() {
        SinglePassSamProgram.makeItSo(this.INPUT, this.REFERENCE_SEQUENCE, this.ASSUME_SORTED, this.STOP_AFTER, Arrays.asList(this));
        return 0;
    }

    public static void makeItSo(File file, File file2, boolean bl, long l, Collection<SinglePassSamProgram> collection) {
        ReferenceSequenceFileWalker referenceSequenceFileWalker;
        IOUtil.assertFileIsReadable((File)file);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(file2).open(file);
        if (file2 == null) {
            referenceSequenceFileWalker = null;
        } else {
            IOUtil.assertFileIsReadable((File)file2);
            referenceSequenceFileWalker = new ReferenceSequenceFileWalker(file2);
            if (!samReader.getFileHeader().getSequenceDictionary().isEmpty()) {
                SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)samReader.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)referenceSequenceFileWalker.getSequenceDictionary());
            }
        }
        SAMFileHeader.SortOrder sortOrder = samReader.getFileHeader().getSortOrder();
        if (sortOrder != SAMFileHeader.SortOrder.coordinate) {
            if (bl) {
                log.warn(new Object[]{"File reports sort order '" + sortOrder + "', assuming it's coordinate sorted anyway."});
            } else {
                throw new PicardException("File " + file.getAbsolutePath() + " should be coordinate sorted but the header says the sort order is " + sortOrder + ". If you believe the file to be coordinate sorted you may pass ASSUME_SORTED=true");
            }
        }
        boolean bl2 = false;
        for (SinglePassSamProgram object : collection) {
            object.setup(samReader.getFileHeader(), file);
            bl2 = bl2 || object.usesNoRefReads();
        }
        ProgressLogger progressLogger = new ProgressLogger(log);
        for (SAMRecord sAMRecord : samReader) {
            ReferenceSequence referenceSequence = referenceSequenceFileWalker == null || sAMRecord.getReferenceIndex() == -1 ? null : referenceSequenceFileWalker.get(sAMRecord.getReferenceIndex().intValue());
            for (SinglePassSamProgram singlePassSamProgram : collection) {
                singlePassSamProgram.acceptRead(sAMRecord, referenceSequence);
            }
            progressLogger.record(sAMRecord);
            if ((l <= 0L || progressLogger.getCount() < l) && (bl2 || sAMRecord.getReferenceIndex() != -1)) continue;
            break;
        }
        CloserUtil.close((Object)samReader);
        for (SinglePassSamProgram singlePassSamProgram : collection) {
            singlePassSamProgram.finish();
        }
    }

    protected boolean usesNoRefReads() {
        return true;
    }

    protected abstract void setup(SAMFileHeader var1, File var2);

    protected abstract void acceptRead(SAMRecord var1, ReferenceSequence var2);

    protected abstract void finish();
}

