/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ListMap;
import htsjdk.samtools.util.SequenceUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;

class ContextAccumulator {
    private final boolean expectedTandemReads;
    private final Map<String, AlignmentAccumulator[]> artifactMap;

    public ContextAccumulator(Set<String> set, boolean bl) {
        this.expectedTandemReads = bl;
        this.artifactMap = new HashMap<String, AlignmentAccumulator[]>();
        for (String string : set) {
            if ((string.length() & 1) == 0) {
                throw new PicardException("Contexts cannot have an even number of bases: " + string);
            }
            AlignmentAccumulator[] alignmentAccumulatorArray = new AlignmentAccumulator[Transition.Base.values().length];
            for (int i = 0; i < Transition.Base.values().length; ++i) {
                alignmentAccumulatorArray[i] = new AlignmentAccumulator();
            }
            this.artifactMap.put(string, alignmentAccumulatorArray);
        }
    }

    public void countRecord(String string, char c, SAMRecord sAMRecord) {
        this.artifactMap.get(string)[Transition.baseIndexMap[c]].countRecord(sAMRecord);
    }

    public ListMap<Transition, SequencingArtifactMetrics.DetailPair> calculateMetrics(String string, String string2) {
        ListMap listMap = new ListMap();
        for (String string3 : new TreeSet<String>(this.artifactMap.keySet())) {
            if ((string3.length() & 1) == 0) {
                throw new PicardException("Contexts cannot have an even number of bases: " + string3 + ".  This should never happen here!");
            }
            char c = string3.charAt(string3.length() / 2);
            for (Transition.Base base : Transition.Base.values()) {
                Transition transition = Transition.transitionOf(c, (char)base.base);
                SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics = new SequencingArtifactMetrics.PreAdapterDetailMetrics();
                SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics = new SequencingArtifactMetrics.BaitBiasDetailMetrics();
                preAdapterDetailMetrics.SAMPLE_ALIAS = string;
                preAdapterDetailMetrics.LIBRARY = string2;
                preAdapterDetailMetrics.CONTEXT = string3;
                preAdapterDetailMetrics.REF_BASE = transition.ref();
                preAdapterDetailMetrics.ALT_BASE = transition.call();
                baitBiasDetailMetrics.SAMPLE_ALIAS = string;
                baitBiasDetailMetrics.LIBRARY = string2;
                baitBiasDetailMetrics.CONTEXT = string3;
                baitBiasDetailMetrics.REF_BASE = transition.ref();
                baitBiasDetailMetrics.ALT_BASE = transition.call();
                AlignmentAccumulator[] alignmentAccumulatorArray = this.artifactMap.get(string3);
                AlignmentAccumulator[] alignmentAccumulatorArray2 = this.artifactMap.get(SequenceUtil.reverseComplement((String)string3));
                AlignmentAccumulator alignmentAccumulator = alignmentAccumulatorArray[Transition.baseIndexMap[transition.ref()]];
                AlignmentAccumulator alignmentAccumulator2 = alignmentAccumulatorArray[Transition.baseIndexMap[transition.call()]];
                AlignmentAccumulator alignmentAccumulator3 = alignmentAccumulatorArray2[Transition.baseIndexMap[transition.complement().ref()]];
                AlignmentAccumulator alignmentAccumulator4 = alignmentAccumulatorArray2[Transition.baseIndexMap[transition.complement().call()]];
                if (this.expectedTandemReads) {
                    preAdapterDetailMetrics.PRO_REF_BASES = alignmentAccumulator.R1_POS + alignmentAccumulator.R2_POS + alignmentAccumulator3.R1_NEG + alignmentAccumulator3.R2_NEG;
                    preAdapterDetailMetrics.PRO_ALT_BASES = alignmentAccumulator2.R1_POS + alignmentAccumulator2.R2_POS + alignmentAccumulator4.R1_NEG + alignmentAccumulator4.R2_NEG;
                    preAdapterDetailMetrics.CON_REF_BASES = alignmentAccumulator.R1_NEG + alignmentAccumulator.R2_NEG + alignmentAccumulator3.R1_POS + alignmentAccumulator3.R2_POS;
                    preAdapterDetailMetrics.CON_ALT_BASES = alignmentAccumulator2.R1_NEG + alignmentAccumulator2.R2_NEG + alignmentAccumulator4.R1_POS + alignmentAccumulator4.R2_POS;
                } else {
                    preAdapterDetailMetrics.PRO_REF_BASES = alignmentAccumulator.R1_POS + alignmentAccumulator.R2_NEG + alignmentAccumulator3.R1_NEG + alignmentAccumulator3.R2_POS;
                    preAdapterDetailMetrics.PRO_ALT_BASES = alignmentAccumulator2.R1_POS + alignmentAccumulator2.R2_NEG + alignmentAccumulator4.R1_NEG + alignmentAccumulator4.R2_POS;
                    preAdapterDetailMetrics.CON_REF_BASES = alignmentAccumulator.R1_NEG + alignmentAccumulator.R2_POS + alignmentAccumulator3.R1_POS + alignmentAccumulator3.R2_NEG;
                    preAdapterDetailMetrics.CON_ALT_BASES = alignmentAccumulator2.R1_NEG + alignmentAccumulator2.R2_POS + alignmentAccumulator4.R1_POS + alignmentAccumulator4.R2_NEG;
                }
                baitBiasDetailMetrics.FWD_CXT_REF_BASES = alignmentAccumulator.R1_POS + alignmentAccumulator.R1_NEG + alignmentAccumulator.R2_POS + alignmentAccumulator.R2_NEG;
                baitBiasDetailMetrics.FWD_CXT_ALT_BASES = alignmentAccumulator2.R1_POS + alignmentAccumulator2.R1_NEG + alignmentAccumulator2.R2_POS + alignmentAccumulator2.R2_NEG;
                baitBiasDetailMetrics.REV_CXT_REF_BASES = alignmentAccumulator3.R1_POS + alignmentAccumulator3.R1_NEG + alignmentAccumulator3.R2_POS + alignmentAccumulator3.R2_NEG;
                baitBiasDetailMetrics.REV_CXT_ALT_BASES = alignmentAccumulator4.R1_POS + alignmentAccumulator4.R1_NEG + alignmentAccumulator4.R2_POS + alignmentAccumulator4.R2_NEG;
                preAdapterDetailMetrics.calculateDerivedStatistics();
                baitBiasDetailMetrics.calculateDerivedStatistics();
                listMap.add((Object)transition, (Object)new SequencingArtifactMetrics.DetailPair(preAdapterDetailMetrics, baitBiasDetailMetrics));
            }
        }
        return listMap;
    }

    private static class AlignmentAccumulator {
        private long R1_POS = 0L;
        private long R1_NEG = 0L;
        private long R2_POS = 0L;
        private long R2_NEG = 0L;

        private AlignmentAccumulator() {
        }

        private void countRecord(SAMRecord sAMRecord) {
            boolean bl;
            boolean bl2 = sAMRecord.getReadNegativeStrandFlag();
            boolean bl3 = bl = sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag();
            if (bl) {
                if (bl2) {
                    ++this.R2_NEG;
                } else {
                    ++this.R2_POS;
                }
            } else if (bl2) {
                ++this.R1_NEG;
            } else {
                ++this.R1_POS;
            }
        }
    }
}

