/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.analysis.InsertSizeMetrics;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.InsertSizeCollectorArgs;
import picard.metrics.MultiLevelCollector;
import picard.metrics.PerUnitMetricCollector;

public class InsertSizeMetricsCollector
extends MultiLevelCollector<InsertSizeMetrics, Integer, InsertSizeCollectorArgs> {
    private final double minimumPct;
    private final double deviations;
    private final Integer histogramWidth;
    private final boolean includeDuplicates;

    public InsertSizeMetricsCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, double d, Integer n, double d2, boolean bl) {
        this.minimumPct = d;
        this.histogramWidth = n;
        this.deviations = d2;
        this.includeDuplicates = bl;
        this.setup(set, list);
    }

    @Override
    protected InsertSizeCollectorArgs makeArg(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        int n = Math.abs(sAMRecord.getInferredInsertSize());
        SamPairUtil.PairOrientation pairOrientation = SamPairUtil.getPairOrientation((SAMRecord)sAMRecord);
        return new InsertSizeCollectorArgs(n, pairOrientation);
    }

    @Override
    protected PerUnitMetricCollector<InsertSizeMetrics, Integer, InsertSizeCollectorArgs> makeChildCollector(String string, String string2, String string3) {
        return new PerUnitInsertSizeMetricsCollector(string, string2, string3);
    }

    @Override
    public void acceptRecord(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        if (!sAMRecord.getReadPairedFlag() || sAMRecord.getReadUnmappedFlag() || sAMRecord.getMateUnmappedFlag() || sAMRecord.getFirstOfPairFlag() || sAMRecord.isSecondaryOrSupplementary() || sAMRecord.getDuplicateReadFlag() && !this.includeDuplicates || sAMRecord.getInferredInsertSize() == 0) {
            return;
        }
        super.acceptRecord(sAMRecord, referenceSequence);
    }

    public class PerUnitInsertSizeMetricsCollector
    implements PerUnitMetricCollector<InsertSizeMetrics, Integer, InsertSizeCollectorArgs> {
        final EnumMap<SamPairUtil.PairOrientation, Histogram<Integer>> histograms = new EnumMap(SamPairUtil.PairOrientation.class);
        final String sample;
        final String library;
        final String readGroup;
        private double totalInserts = 0.0;

        public PerUnitInsertSizeMetricsCollector(String string, String string2, String string3) {
            this.sample = string;
            this.library = string2;
            this.readGroup = string3;
            String string4 = null;
            string4 = this.readGroup != null ? this.readGroup + "." : (this.library != null ? this.library + "." : (this.sample != null ? this.sample + "." : "All_Reads."));
            this.histograms.put(SamPairUtil.PairOrientation.FR, (Histogram<Integer>)new Histogram("insert_size", string4 + "fr_count"));
            this.histograms.put(SamPairUtil.PairOrientation.TANDEM, (Histogram<Integer>)new Histogram("insert_size", string4 + "tandem_count"));
            this.histograms.put(SamPairUtil.PairOrientation.RF, (Histogram<Integer>)new Histogram("insert_size", string4 + "rf_count"));
        }

        @Override
        public void acceptRecord(InsertSizeCollectorArgs insertSizeCollectorArgs) {
            this.histograms.get(insertSizeCollectorArgs.getPairOrientation()).increment((Comparable)Integer.valueOf(insertSizeCollectorArgs.getInsertSize()));
        }

        @Override
        public void finish() {
        }

        public double getTotalInserts() {
            return this.totalInserts;
        }

        @Override
        public void addMetricsToFile(MetricsFile<InsertSizeMetrics, Integer> metricsFile) {
            for (Histogram<Integer> object : this.histograms.values()) {
                this.totalInserts += object.getCount();
            }
            if (0.0 == this.totalInserts) {
                return;
            }
            for (Map.Entry entry : this.histograms.entrySet()) {
                SamPairUtil.PairOrientation pairOrientation = (SamPairUtil.PairOrientation)entry.getKey();
                Histogram histogram = (Histogram)entry.getValue();
                double d = histogram.getCount();
                if (!(d >= this.totalInserts * InsertSizeMetricsCollector.this.minimumPct)) continue;
                InsertSizeMetrics insertSizeMetrics = new InsertSizeMetrics();
                insertSizeMetrics.SAMPLE = this.sample;
                insertSizeMetrics.LIBRARY = this.library;
                insertSizeMetrics.READ_GROUP = this.readGroup;
                insertSizeMetrics.PAIR_ORIENTATION = pairOrientation;
                if (!histogram.isEmpty()) {
                    insertSizeMetrics.READ_PAIRS = (long)d;
                    insertSizeMetrics.MAX_INSERT_SIZE = (int)histogram.getMax();
                    insertSizeMetrics.MIN_INSERT_SIZE = (int)histogram.getMin();
                    insertSizeMetrics.MEDIAN_INSERT_SIZE = histogram.getMedian();
                    insertSizeMetrics.MEDIAN_ABSOLUTE_DEVIATION = histogram.getMedianAbsoluteDeviation();
                    double d2 = histogram.getMedian();
                    double d3 = 0.0;
                    double d4 = d2;
                    for (double d5 = d2; d4 >= histogram.getMin() || d5 <= histogram.getMax(); d4 -= 1.0, d5 += 1.0) {
                        Histogram.Bin bin;
                        Histogram.Bin bin2 = (Histogram.Bin)histogram.get((Object)((int)d4));
                        if (bin2 != null) {
                            d3 += bin2.getValue();
                        }
                        if (d4 != d5 && (bin = (Histogram.Bin)histogram.get((Object)((int)d5))) != null) {
                            d3 += bin.getValue();
                        }
                        double d6 = d3 / d;
                        int n = (int)(d5 - d4) + 1;
                        if (d6 >= 0.1 && insertSizeMetrics.WIDTH_OF_10_PERCENT == 0) {
                            insertSizeMetrics.WIDTH_OF_10_PERCENT = n;
                        }
                        if (d6 >= 0.2 && insertSizeMetrics.WIDTH_OF_20_PERCENT == 0) {
                            insertSizeMetrics.WIDTH_OF_20_PERCENT = n;
                        }
                        if (d6 >= 0.3 && insertSizeMetrics.WIDTH_OF_30_PERCENT == 0) {
                            insertSizeMetrics.WIDTH_OF_30_PERCENT = n;
                        }
                        if (d6 >= 0.4 && insertSizeMetrics.WIDTH_OF_40_PERCENT == 0) {
                            insertSizeMetrics.WIDTH_OF_40_PERCENT = n;
                        }
                        if (d6 >= 0.5 && insertSizeMetrics.WIDTH_OF_50_PERCENT == 0) {
                            insertSizeMetrics.WIDTH_OF_50_PERCENT = n;
                        }
                        if (d6 >= 0.6 && insertSizeMetrics.WIDTH_OF_60_PERCENT == 0) {
                            insertSizeMetrics.WIDTH_OF_60_PERCENT = n;
                        }
                        if (d6 >= 0.7 && insertSizeMetrics.WIDTH_OF_70_PERCENT == 0) {
                            insertSizeMetrics.WIDTH_OF_70_PERCENT = n;
                        }
                        if (d6 >= 0.8 && insertSizeMetrics.WIDTH_OF_80_PERCENT == 0) {
                            insertSizeMetrics.WIDTH_OF_80_PERCENT = n;
                        }
                        if (d6 >= 0.9 && insertSizeMetrics.WIDTH_OF_90_PERCENT == 0) {
                            insertSizeMetrics.WIDTH_OF_90_PERCENT = n;
                        }
                        if (!(d6 >= 0.99) || insertSizeMetrics.WIDTH_OF_99_PERCENT != 0) continue;
                        insertSizeMetrics.WIDTH_OF_99_PERCENT = n;
                    }
                }
                Histogram histogram2 = histogram;
                histogram2.trimByWidth(this.getWidthToTrimTo(insertSizeMetrics));
                if (!histogram2.isEmpty()) {
                    insertSizeMetrics.MEAN_INSERT_SIZE = histogram2.getMean();
                    insertSizeMetrics.STANDARD_DEVIATION = histogram2.getStandardDeviation();
                }
                metricsFile.addHistogram(histogram2);
                metricsFile.addMetric((MetricBase)insertSizeMetrics);
            }
        }

        private int getWidthToTrimTo(InsertSizeMetrics insertSizeMetrics) {
            if (InsertSizeMetricsCollector.this.histogramWidth == null) {
                return (int)(insertSizeMetrics.MEDIAN_INSERT_SIZE + InsertSizeMetricsCollector.this.deviations * insertSizeMetrics.MEDIAN_ABSOLUTE_DEVIATION);
            }
            return InsertSizeMetricsCollector.this.histogramWidth;
        }
    }
}

