/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.QualityUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.TheoreticalSensitivity;
import picard.analysis.directed.TargetMetrics;
import picard.filter.CountingMapQFilter;
import picard.metrics.MultilevelMetrics;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordMultiLevelCollector;

public abstract class TargetMetricsCollector<METRIC_TYPE extends MultilevelMetrics>
extends SAMRecordMultiLevelCollector<METRIC_TYPE, Integer> {
    public static final int NEAR_PROBE_DISTANCE_DEFAULT = 250;
    private int nearProbeDistance = 250;
    private final File perTargetCoverage;
    private final File perBaseCoverage;
    private final String probeSetName;
    private static final Log log = Log.getInstance(TargetMetricsCollector.class);
    private final IntervalList allProbes;
    private final IntervalList allTargets;
    private final OverlapDetector<Interval> targetDetector;
    private final OverlapDetector<Interval> probeDetector;
    private Map<Interval, Double> intervalToGc = null;
    private final long probeTerritory;
    private final long targetTerritory;
    private final long genomeSize;
    private final int coverageCap;
    private final int sampleSize;
    private final Histogram<Integer> baseQHistogram = new Histogram("value", "baseq_count");
    private final Histogram<Integer> depthHistogram = new Histogram("coverage", "count");
    private static final double LOG_ODDS_THRESHOLD = 3.0;
    private final int minimumMappingQuality;
    private final int minimumBaseQuality;
    private final boolean clipOverlappingReads;
    private boolean noSideEffects;
    private final Map<Interval, Coverage> coverageByTargetForRead;
    private final Coverage[] cov;

    public int getNearProbeDistance() {
        return this.nearProbeDistance;
    }

    public void setNearProbeDistance(int n) {
        this.nearProbeDistance = n;
    }

    public abstract METRIC_TYPE convertMetric(TargetMetrics var1);

    public void setNoSideEffects(boolean bl) {
        this.noSideEffects = bl;
    }

    public static int getNumBasesPassingMinimumBaseQuality(SAMRecord sAMRecord, AlignmentBlock alignmentBlock, int n) {
        int n2 = 0;
        byte[] byArray = sAMRecord.getBaseQualities();
        for (int i = alignmentBlock.getReadStart(); i <= CoordMath.getEnd((int)alignmentBlock.getLength(), (int)alignmentBlock.getReadStart()); ++i) {
            if (n > byArray[i - 1]) continue;
            ++n2;
        }
        return n2;
    }

    protected static <MT extends MetricBase> void reflectiveCopy(TargetMetrics targetMetrics, MT MT, String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            if (stringArray2 != null) {
                throw new PicardException("Target keys is null but output keys == " + StringUtil.join((String)",", (Object[])stringArray2));
            }
            if (stringArray != null) {
                throw new PicardException("Output keys is null but target keys == " + StringUtil.join((String)",", (Object[])stringArray));
            }
        } else if (stringArray.length != stringArray2.length) {
            throw new PicardException("Target keys and output keys do not have the same length: targetKeys == (" + StringUtil.join((String)",", (Object[])stringArray) + ") outputKeys == (" + StringUtil.join((String)",", (Object[])stringArray2) + ")");
        }
        Class<?> clazz = MT.getClass();
        Set set = CollectionUtil.makeSet((Object[])TargetMetrics.class.getFields());
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            set.remove(string);
        }
        HashSet hashSet = new HashSet();
        for (Field field : MT.getClass().getFields()) {
            hashSet.add(field.getName());
        }
        for (Field field : set) {
            if (!hashSet.contains(field.getName())) continue;
            try {
                Field field2 = clazz.getField(field.getName());
                field2.set(MT, field.get((Object)targetMetrics));
            }
            catch (Exception exception) {
                throw new PicardException("Exception while copying targetMetrics to " + MT.getClass().getName(), exception);
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Field field = TargetMetrics.class.getField(stringArray[i]);
                Field field3 = clazz.getField(stringArray2[i]);
                field3.set(MT, field.get((Object)targetMetrics));
                continue;
            }
            catch (Exception exception) {
                throw new PicardException("Exception while copying TargetMetrics." + stringArray[i] + " to " + clazz.getName() + "." + stringArray2[i], exception);
            }
        }
    }

    public TargetMetricsCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, ReferenceSequenceFile referenceSequenceFile, File file, File file2, IntervalList intervalList, IntervalList intervalList2, String string, int n, int n2, int n3, boolean bl, int n4, int n5) {
        this(set, list, referenceSequenceFile, file, file2, intervalList, intervalList2, string, n, n2, n3, bl, false, n4, n5);
    }

    public TargetMetricsCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, ReferenceSequenceFile referenceSequenceFile, File file, File file2, IntervalList intervalList, IntervalList intervalList2, String string, int n, int n2, int n3, boolean bl, boolean bl2, int n4, int n5) {
        this.perTargetCoverage = file;
        this.perBaseCoverage = file2;
        this.probeSetName = string;
        this.nearProbeDistance = n;
        this.allProbes = intervalList2;
        this.allTargets = intervalList;
        this.coverageCap = n4;
        this.sampleSize = n5;
        List list2 = this.allProbes.uniqued().getIntervals();
        this.probeDetector = new OverlapDetector(-this.nearProbeDistance, 0);
        this.probeDetector.addAll(list2, list2);
        this.probeTerritory = Interval.countBases((Collection)list2);
        List list3 = this.allTargets.uniqued().getIntervals();
        this.targetDetector = new OverlapDetector(0, 0);
        this.targetDetector.addAll(list3, list3);
        this.targetTerritory = Interval.countBases((Collection)list3);
        int n6 = 0;
        this.cov = new Coverage[list3.size()];
        this.coverageByTargetForRead = new LinkedHashMap<Interval, Coverage>(list3.size() * 2, 0.5f);
        for (Interval interval : list3) {
            Iterator iterator = new Coverage(interval, 0);
            this.coverageByTargetForRead.put(interval, (Coverage)((Object)iterator));
            this.cov[n6++] = iterator;
        }
        long l = 0L;
        for (SAMSequenceRecord sAMSequenceRecord : this.allProbes.getHeader().getSequenceDictionary().getSequences()) {
            l += (long)sAMSequenceRecord.getSequenceLength();
        }
        this.genomeSize = l;
        if (referenceSequenceFile != null) {
            this.intervalToGc = new HashMap<Interval, Double>();
            for (SAMSequenceRecord sAMSequenceRecord : list3) {
                ReferenceSequence referenceSequence = referenceSequenceFile.getSubsequenceAt(sAMSequenceRecord.getSequence(), (long)sAMSequenceRecord.getStart(), (long)sAMSequenceRecord.getEnd());
                this.intervalToGc.put((Interval)sAMSequenceRecord, SequenceUtil.calculateGc((byte[])referenceSequence.getBases()));
            }
        }
        this.minimumMappingQuality = n2;
        this.minimumBaseQuality = n3;
        this.clipOverlappingReads = bl;
        this.noSideEffects = bl2;
        this.setup(set, list);
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeChildCollector(String string, String string2, String string3) {
        PerUnitTargetMetricCollector perUnitTargetMetricCollector = new PerUnitTargetMetricCollector(this.probeSetName, this.coverageByTargetForRead.keySet(), string, string2, string3, this.probeTerritory, this.targetTerritory, this.genomeSize, this.intervalToGc, this.minimumMappingQuality, this.minimumBaseQuality, this.clipOverlappingReads);
        if (this.probeSetName != null) {
            perUnitTargetMetricCollector.setBaitSetName(this.probeSetName);
        }
        return perUnitTargetMetricCollector;
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeAllReadCollector() {
        PerUnitTargetMetricCollector perUnitTargetMetricCollector = (PerUnitTargetMetricCollector)this.makeChildCollector(null, null, null);
        if (this.perTargetCoverage != null) {
            perUnitTargetMetricCollector.setPerTargetOutput(this.perTargetCoverage);
        }
        if (this.perBaseCoverage != null) {
            perUnitTargetMetricCollector.setPerBaseOutput(this.perBaseCoverage);
        }
        return perUnitTargetMetricCollector;
    }

    public static class Coverage {
        private final Interval interval;
        private final int[] depths;

        public Coverage(Interval interval, int n) {
            this.interval = interval;
            this.depths = new int[this.interval.length() + 2 * n];
        }

        public void addBase(int n) {
            if (n >= 0 && n < this.depths.length && this.depths[n] < Integer.MAX_VALUE) {
                int n2 = n;
                this.depths[n2] = this.depths[n2] + 1;
            }
        }

        public boolean hasCoverage() {
            for (int n : this.depths) {
                if (n <= 0) continue;
                return true;
            }
            return false;
        }

        public int[] getDepths() {
            return this.depths;
        }

        public int getTotal() {
            int n = 0;
            for (int i = 0; i < this.depths.length; ++i) {
                n += this.depths[i];
            }
            return n;
        }

        public String toString() {
            return "TargetedMetricCollector(interval=" + this.interval + ", depths = [" + StringUtil.intValuesToString((int[])this.depths) + "])";
        }
    }

    public class PerUnitTargetMetricCollector
    implements PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> {
        private final Map<Interval, Double> intervalToGc;
        private File perTargetOutput;
        private File perBaseOutput;
        final long[] baseQHistogramArray = new long[127];
        private final Map<Interval, Coverage> coverageByTarget;
        private final TargetMetrics metrics = new TargetMetrics();
        private final int minimumBaseQuality;
        private final CountingMapQFilter mapQFilter;
        private final boolean clipOverlappingReads;

        public PerUnitTargetMetricCollector(String string, Set<Interval> set, String string2, String string3, String string4, long l, long l2, long l3, Map<Interval, Double> map, int n, int n2, boolean bl) {
            this.metrics.SAMPLE = string2;
            this.metrics.LIBRARY = string3;
            this.metrics.READ_GROUP = string4;
            this.metrics.PROBE_SET = string;
            this.metrics.PROBE_TERRITORY = l;
            this.metrics.TARGET_TERRITORY = l2;
            this.metrics.GENOME_SIZE = l3;
            this.coverageByTarget = new LinkedHashMap<Interval, Coverage>(set.size() * 2, 0.5f);
            for (Interval interval : set) {
                this.coverageByTarget.put(interval, new Coverage(interval, 0));
            }
            this.mapQFilter = new CountingMapQFilter(n);
            this.minimumBaseQuality = n2;
            this.intervalToGc = map;
            this.clipOverlappingReads = bl;
        }

        public void setPerTargetOutput(File file) {
            this.perTargetOutput = file;
        }

        public void setPerBaseOutput(File file) {
            this.perBaseOutput = file;
        }

        public void setBaitSetName(String string) {
            this.metrics.PROBE_SET = string;
        }

        @Override
        public void acceptRecord(SAMRecord sAMRecord) {
            SAMRecord sAMRecord2;
            int n;
            int n2;
            Object object2;
            if (sAMRecord.getNotPrimaryAlignmentFlag()) {
                return;
            }
            boolean bl = sAMRecord.getReadPairedFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag() && !sAMRecord.getSupplementaryAlignmentFlag();
            byte[] byArray = sAMRecord.getBaseQualities();
            int n3 = 0;
            if (!sAMRecord.getReadUnmappedFlag()) {
                for (Object object2 : sAMRecord.getAlignmentBlocks()) {
                    n3 += object2.getLength();
                }
            }
            if (!sAMRecord.getSupplementaryAlignmentFlag()) {
                ++this.metrics.TOTAL_READS;
                if (!sAMRecord.getReadFailsVendorQualityCheckFlag()) {
                    ++this.metrics.PF_READS;
                    if (!sAMRecord.getDuplicateReadFlag()) {
                        ++this.metrics.PF_UNIQUE_READS;
                        if (!sAMRecord.getReadUnmappedFlag()) {
                            ++this.metrics.PF_UQ_READS_ALIGNED;
                        }
                    }
                }
            }
            if (sAMRecord.getReadFailsVendorQualityCheckFlag()) {
                return;
            }
            if (!sAMRecord.getSupplementaryAlignmentFlag()) {
                this.metrics.PF_BASES += (long)sAMRecord.getReadLength();
            }
            if (!sAMRecord.getReadUnmappedFlag()) {
                this.metrics.PF_BASES_ALIGNED += (long)n3;
                if (!sAMRecord.getDuplicateReadFlag()) {
                    this.metrics.PF_UQ_BASES_ALIGNED += (long)n3;
                }
            }
            if (sAMRecord.getReadUnmappedFlag()) {
                return;
            }
            Interval interval = new Interval(sAMRecord.getReferenceName(), sAMRecord.getAlignmentStart(), sAMRecord.getAlignmentEnd());
            object2 = TargetMetricsCollector.this.targetDetector.getOverlaps(interval);
            Collection collection = TargetMetricsCollector.this.probeDetector.getOverlaps(interval);
            if (!sAMRecord.getSupplementaryAlignmentFlag() && sAMRecord.getReadPairedFlag() && sAMRecord.getFirstOfPairFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag() && !collection.isEmpty()) {
                ++this.metrics.PF_SELECTED_PAIRS;
                if (!sAMRecord.getDuplicateReadFlag()) {
                    ++this.metrics.PF_SELECTED_UNIQUE_PAIRS;
                }
            }
            int n4 = n3;
            int n5 = 0;
            if (!collection.isEmpty()) {
                for (Interval interval2 : collection) {
                    for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
                        n2 = CoordMath.getEnd((int)alignmentBlock.getReferenceStart(), (int)alignmentBlock.getLength());
                        for (n = alignmentBlock.getReferenceStart(); n <= n2; ++n) {
                            if (n < interval2.getStart() || n > interval2.getEnd()) continue;
                            ++n5;
                        }
                    }
                }
                this.metrics.ON_PROBE_BASES += (long)n5;
                this.metrics.NEAR_PROBE_BASES += (long)(n4 - n5);
            } else {
                this.metrics.OFF_PROBE_BASES += (long)n4;
            }
            if (sAMRecord.getDuplicateReadFlag()) {
                this.metrics.PCT_EXC_DUPE += (double)n3;
                return;
            }
            if (this.mapQFilter.filterOut(sAMRecord)) {
                return;
            }
            if (this.clipOverlappingReads) {
                n5 = SAMUtils.getNumOverlappingAlignedBasesToClip((SAMRecord)sAMRecord);
                sAMRecord2 = SAMUtils.clipOverlappingAlignedBases((SAMRecord)sAMRecord, (int)n5, (boolean)TargetMetricsCollector.this.noSideEffects);
                this.metrics.PCT_EXC_OVERLAP += (double)n5;
            } else {
                sAMRecord2 = sAMRecord;
            }
            for (AlignmentBlock alignmentBlock : sAMRecord2.getAlignmentBlocks()) {
                int n6 = alignmentBlock.getLength();
                int n7 = alignmentBlock.getReferenceStart();
                int n8 = alignmentBlock.getReadStart();
                for (n2 = 0; n2 < n6; ++n2) {
                    n = n7 + n2;
                    int n9 = n8 + n2;
                    byte by = byArray[n9 - 1];
                    if (by < this.minimumBaseQuality) {
                        this.metrics.PCT_EXC_BASEQ += 1.0;
                        continue;
                    }
                    boolean bl2 = false;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Interval interval3 = (Interval)iterator.next();
                        if (n < interval3.getStart() || n > interval3.getEnd()) continue;
                        bl2 = true;
                        ++this.metrics.ON_TARGET_BASES;
                        if (bl) {
                            ++this.metrics.ON_TARGET_FROM_PAIR_BASES;
                        }
                        int n10 = n - interval3.getStart();
                        Coverage coverage = this.coverageByTarget.get(interval3);
                        coverage.addBase(n10);
                        byte by2 = byArray[n2];
                        this.baseQHistogramArray[by2] = this.baseQHistogramArray[by2] + 1L;
                    }
                    if (bl2) continue;
                    this.metrics.PCT_EXC_OFF_TARGET += 1.0;
                }
            }
        }

        @Override
        public void finish() {
            int n;
            this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS = (double)this.metrics.PF_UNIQUE_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS_ALIGNED = (double)this.metrics.PF_UQ_READS_ALIGNED / (double)this.metrics.PF_UNIQUE_READS;
            double d = this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES + this.metrics.OFF_PROBE_BASES;
            this.metrics.PCT_SELECTED_BASES = (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES) / d;
            this.metrics.PCT_OFF_PROBE = (double)this.metrics.OFF_PROBE_BASES / d;
            this.metrics.ON_PROBE_VS_SELECTED = (double)this.metrics.ON_PROBE_BASES / (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES);
            this.metrics.MEAN_PROBE_COVERAGE = (double)this.metrics.ON_PROBE_BASES / (double)this.metrics.PROBE_TERRITORY;
            this.metrics.FOLD_ENRICHMENT = (double)this.metrics.ON_PROBE_BASES / d / ((double)this.metrics.PROBE_TERRITORY / (double)this.metrics.GENOME_SIZE);
            this.metrics.PCT_EXC_DUPE /= (double)this.metrics.PF_BASES_ALIGNED;
            this.metrics.PCT_EXC_MAPQ = (double)this.mapQFilter.getFilteredBases() / (double)this.metrics.PF_BASES_ALIGNED;
            this.metrics.PCT_EXC_BASEQ /= (double)this.metrics.PF_BASES_ALIGNED;
            this.metrics.PCT_EXC_OVERLAP /= (double)this.metrics.PF_BASES_ALIGNED;
            this.metrics.PCT_EXC_OFF_TARGET /= (double)this.metrics.PF_BASES_ALIGNED;
            double[] dArray = this.calculateTargetCoverageMetrics();
            for (n = 0; n < this.baseQHistogramArray.length; ++n) {
                TargetMetricsCollector.this.baseQHistogram.increment((Comparable)Integer.valueOf(n), (double)this.baseQHistogramArray[n]);
            }
            for (n = 0; n < dArray.length; ++n) {
                TargetMetricsCollector.this.depthHistogram.increment((Comparable)Integer.valueOf(n), dArray[n]);
            }
            double[] dArray2 = TheoreticalSensitivity.normalizeHistogram((Histogram<Integer>)TargetMetricsCollector.this.depthHistogram);
            double[] dArray3 = TheoreticalSensitivity.normalizeHistogram((Histogram<Integer>)TargetMetricsCollector.this.baseQHistogram);
            this.metrics.HET_SNP_SENSITIVITY = TheoreticalSensitivity.hetSNPSensitivity(dArray2, dArray3, TargetMetricsCollector.this.sampleSize, 3.0);
            this.metrics.HET_SNP_Q = QualityUtil.getPhredScoreFromErrorProbability((double)(1.0 - this.metrics.HET_SNP_SENSITIVITY));
            this.calculateGcMetrics();
            this.emitPerBaseCoverageIfRequested();
        }

        private double[] calculateTargetCoverageMetrics() {
            int[] nArray = new int[(int)this.metrics.TARGET_TERRITORY];
            double[] dArray = new double[TargetMetricsCollector.this.coverageCap + 1];
            int n = 0;
            int n2 = 0;
            double d = 0.0;
            int[] nArray2 = new int[]{0, 1, 2, 10, 20, 30, 40, 50, 100};
            int[] nArray3 = new int[nArray2.length];
            for (Coverage coverage : this.coverageByTarget.values()) {
                boolean bl = coverage.hasCoverage();
                int[] nArray4 = coverage.getDepths();
                if (!bl) {
                    ++n;
                    dArray[0] = dArray[0] + (double)coverage.getDepths().length;
                }
                for (int n3 : nArray4) {
                    if (0 < n3) {
                        d += (double)n3;
                    }
                    if (bl) {
                        nArray[n2++] = n3;
                    }
                    int n4 = Math.min(n3, TargetMetricsCollector.this.coverageCap);
                    dArray[n4] = dArray[n4] + 1.0;
                    int n5 = 0;
                    while (n5 < nArray2.length && n3 >= nArray2[n5]) {
                        int n6 = n5++;
                        nArray3[n6] = nArray3[n6] + 1;
                    }
                }
            }
            Arrays.sort(nArray);
            this.metrics.MEAN_TARGET_COVERAGE = d / (double)this.metrics.TARGET_TERRITORY;
            this.metrics.MEDIAN_TARGET_COVERAGE = 0 == nArray.length % 2 ? (double)(nArray[nArray.length / 2 - 1] + nArray[nArray.length / 2]) / 2.0 : (double)nArray[(nArray.length - 1) / 2];
            int n7 = Math.max((int)((double)n2 * 0.2) - 1, 0);
            if (nArray.length <= 0) {
                throw new PicardException("Interval list only contains one zero-length interval.");
            }
            int n8 = nArray[n7];
            this.metrics.FOLD_80_BASE_PENALTY = this.metrics.MEAN_TARGET_COVERAGE / (double)n8;
            this.metrics.ZERO_CVG_TARGETS_PCT = (double)n / (double)TargetMetricsCollector.this.allTargets.getIntervals().size();
            this.metrics.PCT_TARGET_BASES_1X = (double)nArray3[1] / (double)nArray3[0];
            this.metrics.PCT_TARGET_BASES_2X = (double)nArray3[2] / (double)nArray3[0];
            this.metrics.PCT_TARGET_BASES_10X = (double)nArray3[3] / (double)nArray3[0];
            this.metrics.PCT_TARGET_BASES_20X = (double)nArray3[4] / (double)nArray3[0];
            this.metrics.PCT_TARGET_BASES_30X = (double)nArray3[5] / (double)nArray3[0];
            this.metrics.PCT_TARGET_BASES_40X = (double)nArray3[6] / (double)nArray3[0];
            this.metrics.PCT_TARGET_BASES_50X = (double)nArray3[7] / (double)nArray3[0];
            this.metrics.PCT_TARGET_BASES_100X = (double)nArray3[8] / (double)nArray3[0];
            return dArray;
        }

        private void emitPerBaseCoverageIfRequested() {
            if (this.perBaseOutput == null) {
                return;
            }
            PrintWriter printWriter = new PrintWriter(IOUtil.openFileForBufferedWriting((File)this.perBaseOutput));
            printWriter.println("chrom\tpos\ttarget\tcoverage");
            for (Map.Entry<Interval, Coverage> entry : this.coverageByTarget.entrySet()) {
                Interval interval = entry.getKey();
                String string = interval.getContig();
                int n = interval.getStart();
                int[] nArray = entry.getValue().getDepths();
                for (int i = 0; i < nArray.length; ++i) {
                    printWriter.print(string);
                    printWriter.print('\t');
                    printWriter.print(n + i);
                    printWriter.print('\t');
                    printWriter.print(interval.getName());
                    printWriter.print('\t');
                    printWriter.print(nArray[i]);
                    printWriter.println();
                }
            }
            printWriter.close();
        }

        private void calculateGcMetrics() {
            if (this.intervalToGc != null) {
                int n;
                double d;
                double d2;
                PrintWriter printWriter;
                log.info(new Object[]{"Calculating GC metrics"});
                FormatUtil formatUtil = new FormatUtil();
                try {
                    if (this.perTargetOutput != null) {
                        printWriter = new PrintWriter(this.perTargetOutput);
                        printWriter.println("chrom\tstart\tend\tlength\tname\t%gc\tmean_coverage\tnormalized_coverage\tmin_normalized_coverage\tmax_normalized_coverage\tmin_coverage\tmax_coverage\tpct_0x");
                    } else {
                        printWriter = null;
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException((Throwable)iOException);
                }
                long[] lArray = new long[101];
                long[] lArray2 = new long[101];
                for (Map.Entry<Interval, Coverage> entry : this.coverageByTarget.entrySet()) {
                    int n2;
                    Interval interval = entry.getKey();
                    Coverage coverage = entry.getValue();
                    if (interval.length() <= 0) {
                        log.warn(new Object[]{"interval of length zero found: " + interval + " skipped."});
                        continue;
                    }
                    double d3 = this.intervalToGc.get(interval);
                    int n3 = n2 = (int)Math.round(d3 * 100.0);
                    lArray[n3] = lArray[n3] + (long)interval.length();
                    int n4 = n2;
                    lArray2[n4] = lArray2[n4] + (long)coverage.getTotal();
                    if (printWriter == null) continue;
                    d2 = (double)coverage.getTotal() / (double)interval.length();
                    d = 2.147483647E9;
                    double d4 = -2.147483648E9;
                    double d5 = 0.0;
                    for (int n5 : coverage.getDepths()) {
                        if (0 == n5) {
                            d5 += 1.0;
                        }
                        if ((double)n5 < d) {
                            d = n5;
                        }
                        if (!(d4 < (double)n5)) continue;
                        d4 = n5;
                    }
                    printWriter.println(interval.getSequence() + "\t" + interval.getStart() + "\t" + interval.getEnd() + "\t" + interval.length() + "\t" + interval.getName() + "\t" + formatUtil.format(d3) + "\t" + formatUtil.format(d2) + "\t" + formatUtil.format(d2 / this.metrics.MEAN_TARGET_COVERAGE) + "\t" + formatUtil.format(d / this.metrics.MEAN_TARGET_COVERAGE) + "\t" + formatUtil.format(d4 / this.metrics.MEAN_TARGET_COVERAGE) + "\t" + formatUtil.format(d) + "\t" + formatUtil.format(d4) + "\t" + formatUtil.format(d5 / (double)interval.length()));
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                long l = 0L;
                long l2 = 0L;
                for (n = 0; n < lArray.length; ++n) {
                    l += lArray[n];
                    l2 += lArray2[n];
                }
                for (n = 0; n < lArray.length; ++n) {
                    d2 = (double)lArray2[n] / (double)l2;
                    double d6 = (double)lArray[n] / (double)l;
                    d = (d2 - d6) * 100.0;
                    if (!(d < 0.0)) continue;
                    d = Math.abs(d);
                    if (n <= 50) {
                        this.metrics.AT_DROPOUT += d;
                    }
                    if (n < 50) continue;
                    this.metrics.GC_DROPOUT += d;
                }
            }
        }

        @Override
        public void addMetricsToFile(MetricsFile<METRIC_TYPE, Integer> metricsFile) {
            metricsFile.addMetric(TargetMetricsCollector.this.convertMetric(this.metrics));
            metricsFile.addHistogram(TargetMetricsCollector.this.depthHistogram);
            metricsFile.addHistogram(TargetMetricsCollector.this.baseQHistogram);
        }
    }
}

