/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.replicates;

import htsjdk.samtools.DuplicateSetIterator;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.AggregateFilter;
import htsjdk.samtools.filter.AlignedFilter;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.MappingQualityFilter;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SecondaryOrSupplementaryFilter;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.ComparableTuple;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.filter.CompoundFilter;
import htsjdk.variant.variantcontext.filter.FilteringVariantContextIterator;
import htsjdk.variant.variantcontext.filter.GenotypeQualityFilter;
import htsjdk.variant.variantcontext.filter.HeterozygosityFilter;
import htsjdk.variant.variantcontext.filter.PassingVariantFilter;
import htsjdk.variant.variantcontext.filter.SnpFilter;
import htsjdk.variant.variantcontext.filter.VariantContextFilter;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import picard.analysis.replicates.IndependentReplicateMetric;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Alpha;
import picard.filter.CountingPairedFilter;

@CommandLineProgramProperties(usage="Estimates the rate of independent replication rate of reads within a bam. \nThat is, it estimates the fraction of the reads which would be marked as duplicates but are actually biological replicates, independent observations of the data. ", usageShort="Estimates the rate of independent replication of reads within a bam.", programGroup=Alpha.class)
public class CollectIndependentReplicateMetrics
extends CommandLineProgram {
    private static final int DOUBLETON_SIZE = 2;
    private static final int TRIPLETON_SIZE = 3;
    @Option(shortName="I", doc="Input (indexed) BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="Write metrics to this file")
    public File OUTPUT;
    @Option(shortName="MO", doc="Write the confusion matrix (of UMIs) to this file", optional=true)
    public File MATRIX_OUTPUT;
    @Option(shortName="V", doc="Input VCF file")
    public File VCF;
    @Option(shortName="GQ", doc="minimal value for the GQ field in the VCF to use variant site.", optional=true)
    public Integer MINIMUM_GQ = 90;
    @Option(shortName="MQ", doc="minimal value for the mapping quality of the reads to be used in the estimation.", optional=true)
    public Integer MINIMUM_MQ = 40;
    @Option(shortName="BQ", doc="minimal value for the base quality of a base to be used in the estimation.", optional=true)
    public Integer MINIMUM_BQ = 17;
    @Option(shortName="ALIAS", doc="Name of sample to look at in VCF. Can be omitted if VCF contains only one sample.", optional=true)
    public String SAMPLE = null;
    @Option(doc="Number of sets to examine before stopping.", optional=true)
    public Integer STOP_AFTER = 0;
    @Option(doc="Barcode SAM tag.", optional=true)
    public String BARCODE_TAG = "RX";
    @Option(doc="Barcode Quality SAM tag.", optional=true)
    public String BARCODE_BQ = "QX";
    @Option(shortName="MBQ", doc="minimal value for the base quality of all the bases in a molecular barcode, for it to be used.", optional=true)
    public Integer MINIMUM_BARCODE_BQ = 30;
    private static final Log log = Log.getInstance(CollectIndependentReplicateMetrics.class);

    @Override
    protected int doWork() {
        MetricsFile metricsFile;
        MetricsFile metricsFile2;
        IOUtil.assertFileIsReadable((File)this.VCF);
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.MATRIX_OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.MATRIX_OUTPUT);
        }
        VCFFileReader vCFFileReader = new VCFFileReader(this.VCF, false);
        VCFHeader vCFHeader = vCFFileReader.getFileHeader();
        ArrayList arrayList = vCFHeader.getSampleNamesInOrder();
        if (this.SAMPLE == null) {
            if (arrayList.size() != 1) {
                throw new IllegalArgumentException("When sample is null, VCF must have exactly 1 sample. found " + arrayList.size());
            }
            this.SAMPLE = (String)arrayList.get(0);
            log.info(new Object[]{"No SAMPLE given, using sample from VCF: ", this.SAMPLE});
        } else if (!arrayList.contains(this.SAMPLE)) {
            throw new IllegalArgumentException("When sample is not null, VCF must contain supplied sample. Cannot find sample " + this.SAMPLE + " in vcf.");
        }
        Histogram histogram = new Histogram("ConfusionUMI", "Count");
        Histogram histogram2 = new Histogram("ConfusionUMI", "EditDistance");
        IndependentReplicateMetric independentReplicateMetric = new IndependentReplicateMetric();
        Histogram histogram3 = new Histogram("editDistance", "diffAllelesCount");
        Histogram histogram4 = new Histogram("editDistance", "sameAllelesCount");
        Histogram histogram5 = new Histogram("alleleBalance", "alleleBalanceCount");
        SortedMap<QueryInterval, List<Allele>> sortedMap = this.getQueryIntervalsMap(this.VCF);
        Iterator<QueryInterval> iterator = sortedMap.keySet().iterator();
        log.info(new Object[]{"Found " + sortedMap.size() + " heterozygous sites in VCF."});
        SamReader samReader = SamReaderFactory.makeDefault().open(this.INPUT);
        log.info(new Object[]{"Querying BAM for sites."});
        SAMRecordIterator sAMRecordIterator = samReader.query(sortedMap.keySet().toArray(new QueryInterval[sortedMap.size()]), false);
        List list = CollectionUtil.makeList((Object[])new SamRecordFilter[]{new AlignedFilter(true), new CountingPairedFilter(), new SecondaryOrSupplementaryFilter(), new MappingQualityFilter(this.MINIMUM_MQ.intValue())});
        FilteringSamIterator filteringSamIterator = new FilteringSamIterator((Iterator)sAMRecordIterator, (SamRecordFilter)new AggregateFilter(list));
        log.info(new Object[]{"Queried BAM, getting duplicate sets."});
        DuplicateSetIterator duplicateSetIterator = new DuplicateSetIterator((CloseableIterator)filteringSamIterator, samReader.getFileHeader());
        QueryInterval queryInterval = null;
        log.info(new Object[]{"Starting iteration on reads"});
        ProgressLogger progressLogger = new ProgressLogger(log, 10000000, "examined", "duplicate sets");
        IndependentReplicateMetric independentReplicateMetric2 = new IndependentReplicateMetric();
        boolean bl2 = true;
        boolean bl3 = false;
        int n = 0;
        Allele allele = null;
        String string2 = null;
        block6: while (duplicateSetIterator.hasNext()) {
            Object object;
            int n2;
            Integer n3;
            Integer n4;
            Object object2;
            metricsFile2 = duplicateSetIterator.next();
            metricsFile = metricsFile2.getRepresentative();
            QueryInterval queryInterval2 = CollectIndependentReplicateMetrics.queryIntervalFromSamRecord((SAMRecord)metricsFile);
            progressLogger.record((SAMRecord)metricsFile);
            if (!bl2 || queryInterval != null && CollectIndependentReplicateMetrics.isCleanlyBefore(queryInterval, queryInterval2)) {
                if (!bl2) {
                    Integer n5 = independentReplicateMetric.nThreeAllelesSites;
                    independentReplicateMetric.nThreeAllelesSites = independentReplicateMetric.nThreeAllelesSites + 1;
                    object2 = independentReplicateMetric.nThreeAllelesSites;
                    if (++n < 100) {
                        log.debug(new Object[]{"Skipping a locus due to third allele: " + allele + " but expected " + sortedMap.get(queryInterval) + " queryInterval " + queryInterval + " offending read name is : " + string2});
                    }
                }
                queryInterval = null;
            }
            while (iterator.hasNext() && (queryInterval == null || CollectIndependentReplicateMetrics.isCleanlyBefore(queryInterval, queryInterval2))) {
                if (independentReplicateMetric2.nReferenceReads == 0 || independentReplicateMetric2.nAlternateReads == 0) {
                    bl2 = false;
                    log.debug(new Object[]{"will not use this locus due to lack of evidence of het site."});
                }
                if (bl2 && bl3) {
                    independentReplicateMetric.merge(independentReplicateMetric2);
                    log.debug(new Object[]{"merging metric. total nSites so far: " + independentReplicateMetric.nSites});
                    byte by = (byte)Math.round(100.0 * ((double)independentReplicateMetric2.nAlternateReads.intValue() + 0.5) / (double)(independentReplicateMetric2.nAlternateReads + independentReplicateMetric2.nReferenceReads + 1));
                    histogram5.increment((Comparable)Byte.valueOf(by));
                    bl3 = false;
                }
                queryInterval = iterator.next();
                independentReplicateMetric2 = new IndependentReplicateMetric();
                independentReplicateMetric2.nSites = 1;
                bl2 = true;
            }
            bl3 = true;
            if (queryInterval == null) break;
            int n6 = metricsFile2.size();
            object2 = independentReplicateMetric2;
            Integer.valueOf(((IndependentReplicateMetric)((Object)object2)).nTotalReads + n6);
            ((IndependentReplicateMetric)((Object)object2)).nTotalReads = ((IndependentReplicateMetric)((Object)object2)).nTotalReads;
            if (n6 > 1) {
                object2 = independentReplicateMetric2;
                n4 = ((IndependentReplicateMetric)((Object)object2)).nDuplicateSets;
                n3 = ((IndependentReplicateMetric)((Object)object2)).nDuplicateSets = Integer.valueOf(((IndependentReplicateMetric)((Object)object2)).nDuplicateSets + 1);
            }
            if (n6 == 2) {
                object2 = independentReplicateMetric2;
                n4 = ((IndependentReplicateMetric)((Object)object2)).nExactlyDouble;
                n3 = ((IndependentReplicateMetric)((Object)object2)).nExactlyDouble = Integer.valueOf(((IndependentReplicateMetric)((Object)object2)).nExactlyDouble + 1);
            } else if (n6 == 3) {
                object2 = independentReplicateMetric2;
                n4 = ((IndependentReplicateMetric)((Object)object2)).nExactlyTriple;
                n3 = ((IndependentReplicateMetric)((Object)object2)).nExactlyTriple = Integer.valueOf(((IndependentReplicateMetric)((Object)object2)).nExactlyTriple + 1);
            } else if (n6 > 3) {
                object2 = independentReplicateMetric2;
                Integer.valueOf(((IndependentReplicateMetric)((Object)object2)).nReadsInBigSets + n6);
                ((IndependentReplicateMetric)((Object)object2)).nReadsInBigSets = ((IndependentReplicateMetric)((Object)object2)).nReadsInBigSets;
            }
            log.debug(new Object[]{"set size is: " + n6});
            object2 = (List)sortedMap.get(queryInterval);
            log.debug(new Object[]{"alleles in VC: " + object2});
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            for (SAMRecord sAMRecord2 : metricsFile2.getRecords()) {
                n2 = sAMRecord2.getReadPositionAtReferencePosition(queryInterval.start) - 1;
                if (n2 == -1) {
                    log.debug(new Object[]{"got offset -1, getting new set"});
                    continue block6;
                }
                if (sAMRecord2.getBaseQualities()[n2] <= this.MINIMUM_BQ) {
                    log.debug(new Object[]{"got low read quality, getting new set"});
                    continue block6;
                }
                object = Allele.create((byte)sAMRecord2.getReadBases()[n2]);
                if (((Allele)object2.get(0)).basesMatch(object)) {
                    ++n7;
                    continue;
                }
                if (((Allele)object2.get(1)).basesMatch(object)) {
                    ++n8;
                    continue;
                }
                ++n9;
                bl2 = false;
                allele = object;
                string2 = sAMRecord2.getReadName();
            }
            Object object3 = independentReplicateMetric2;
            Integer.valueOf(((IndependentReplicateMetric)((Object)object3)).nAlternateReads + n8);
            ((IndependentReplicateMetric)((Object)object3)).nAlternateReads = ((IndependentReplicateMetric)((Object)object3)).nAlternateReads;
            object3 = independentReplicateMetric2;
            Integer.valueOf(((IndependentReplicateMetric)((Object)object3)).nReferenceReads + n7);
            ((IndependentReplicateMetric)((Object)object3)).nReferenceReads = ((IndependentReplicateMetric)((Object)object3)).nReferenceReads;
            if (n6 == 1 || n6 > 3) continue;
            object3 = CollectIndependentReplicateMetrics.classifySet(n7, n8, n9);
            log.debug(new Object[]{"Classification of set is: " + object3});
            if (n6 == 2) {
                Object object4;
                Integer n10;
                Object object5;
                Integer n11;
                Integer n12;
                Integer n13;
                boolean bl4 = !metricsFile2.getRecords().stream().map(sAMRecord -> sAMRecord.getStringAttribute(this.BARCODE_BQ)).map(string -> string == null ? "" : string).map(string -> {
                    byte[] byArray = SAMUtils.fastqToPhred((String)string);
                    return IntStream.range(0, byArray.length).map(n -> byArray[n]).anyMatch(n -> n < this.MINIMUM_BARCODE_BQ);
                }).anyMatch(bl -> bl);
                log.debug(new Object[]{"using barcodes?" + bl4});
                if (bl4) {
                    object = independentReplicateMetric2;
                    n13 = object.nGoodBarcodes;
                    n12 = object.nGoodBarcodes = Integer.valueOf(object.nGoodBarcodes + 1);
                    n11 = n13;
                } else {
                    object = independentReplicateMetric2;
                    n13 = object.nBadBarcodes;
                    n12 = object.nBadBarcodes = Integer.valueOf(object.nBadBarcodes + 1);
                    n11 = n13;
                }
                n2 = n11;
                List list2 = metricsFile2.getRecords().stream().map(sAMRecord -> sAMRecord.getStringAttribute(this.BARCODE_TAG)).map(string -> string == null ? "" : string).collect(Collectors.toList());
                log.debug(new Object[]{"found UMIs:" + list2});
                boolean bl5 = metricsFile2.getRecords().stream().map(SAMRecord::getFirstOfPairFlag).distinct().count() != 1L;
                log.debug(new Object[]{"reads have multiple orientation?" + bl5});
                byte by = CollectIndependentReplicateMetrics.calculateEditDistance((String)list2.get(0), (String)list2.get(1));
                log.debug(new Object[]{"Edit distance between umi: " + by});
                if (bl4 && by != 0) {
                    Integer n14;
                    if (bl5) {
                        object5 = independentReplicateMetric2;
                        n10 = object5.nMismatchingUMIsInContraOrientedBiDups;
                        object4 = object5.nMismatchingUMIsInContraOrientedBiDups = Integer.valueOf(object5.nMismatchingUMIsInContraOrientedBiDups + 1);
                        n14 = n10;
                    } else {
                        object5 = independentReplicateMetric2;
                        n10 = object5.nMismatchingUMIsInCoOrientedBiDups;
                        object4 = object5.nMismatchingUMIsInCoOrientedBiDups = Integer.valueOf(object5.nMismatchingUMIsInCoOrientedBiDups + 1);
                        n14 = n10;
                    }
                    int n15 = n14;
                }
                if (object3 == SetClassification.DIFFERENT_ALLELES) {
                    IndependentReplicateMetric independentReplicateMetric3 = independentReplicateMetric2;
                    object5 = independentReplicateMetric3.nDifferentAllelesBiDups;
                    n10 = independentReplicateMetric3.nDifferentAllelesBiDups = Integer.valueOf(independentReplicateMetric3.nDifferentAllelesBiDups + 1);
                    if (bl4) {
                        Integer n16;
                        histogram3.increment((Comparable)Byte.valueOf(by));
                        if (by == 0) {
                            object5 = independentReplicateMetric2;
                            n10 = object5.nMatchingUMIsInDiffBiDups;
                            object4 = object5.nMatchingUMIsInDiffBiDups = Integer.valueOf(object5.nMatchingUMIsInDiffBiDups + 1);
                            n16 = n10;
                        } else {
                            object5 = independentReplicateMetric2;
                            n10 = object5.nMismatchingUMIsInDiffBiDups;
                            object4 = object5.nMismatchingUMIsInDiffBiDups = Integer.valueOf(object5.nMismatchingUMIsInDiffBiDups + 1);
                            n16 = n10;
                        }
                        int n17 = n16;
                    }
                } else if (object3 == SetClassification.MISMATCHING_ALLELE) {
                    IndependentReplicateMetric independentReplicateMetric4 = independentReplicateMetric2;
                    object5 = independentReplicateMetric4.nMismatchingAllelesBiDups;
                    n10 = independentReplicateMetric4.nMismatchingAllelesBiDups = Integer.valueOf(independentReplicateMetric4.nMismatchingAllelesBiDups + 1);
                } else {
                    Integer n18;
                    if (object3 == SetClassification.ALTERNATE_ALLELE) {
                        object5 = independentReplicateMetric2;
                        n10 = object5.nAlternateAllelesBiDups;
                        object4 = object5.nAlternateAllelesBiDups = Integer.valueOf(object5.nAlternateAllelesBiDups + 1);
                        n18 = n10;
                    } else {
                        object5 = independentReplicateMetric2;
                        n10 = object5.nReferenceAllelesBiDups;
                        object4 = object5.nReferenceAllelesBiDups = Integer.valueOf(object5.nReferenceAllelesBiDups + 1);
                        n18 = n10;
                    }
                    int n19 = n18;
                    if (bl4) {
                        Integer n20;
                        Integer n21;
                        Integer n22;
                        histogram4.increment((Comparable)Byte.valueOf(by));
                        object5 = new ComparableTuple((Comparable)list2.get(0), (Comparable)list2.get(1));
                        histogram.increment((Comparable)object5);
                        if (!histogram2.containsKey(object5)) {
                            histogram2.increment((Comparable)object5, (double)by);
                        }
                        if (by == 0) {
                            object4 = independentReplicateMetric2;
                            n22 = ((IndependentReplicateMetric)((Object)object4)).nMatchingUMIsInSameBiDups;
                            n21 = ((IndependentReplicateMetric)((Object)object4)).nMatchingUMIsInSameBiDups = Integer.valueOf(((IndependentReplicateMetric)((Object)object4)).nMatchingUMIsInSameBiDups + 1);
                            n20 = n22;
                        } else {
                            object4 = independentReplicateMetric2;
                            n22 = ((IndependentReplicateMetric)((Object)object4)).nMismatchingUMIsInSameBiDups;
                            n21 = ((IndependentReplicateMetric)((Object)object4)).nMismatchingUMIsInSameBiDups = Integer.valueOf(((IndependentReplicateMetric)((Object)object4)).nMismatchingUMIsInSameBiDups + 1);
                            n20 = n22;
                        }
                        int n23 = n20;
                    }
                }
            }
            if (n6 == 3) {
                switch (1.$SwitchMap$picard$analysis$replicates$CollectIndependentReplicateMetrics$SetClassification[((Enum)object3).ordinal()]) {
                    case 1: {
                        IndependentReplicateMetric independentReplicateMetric5 = independentReplicateMetric2;
                        Integer n24 = independentReplicateMetric5.nMismatchingAllelesTriDups;
                        Integer n25 = independentReplicateMetric5.nMismatchingAllelesTriDups = Integer.valueOf(independentReplicateMetric5.nMismatchingAllelesTriDups + 1);
                        break;
                    }
                    case 2: {
                        IndependentReplicateMetric independentReplicateMetric6 = independentReplicateMetric2;
                        Integer n26 = independentReplicateMetric6.nDifferentAllelesTriDups;
                        Integer n27 = independentReplicateMetric6.nDifferentAllelesTriDups = Integer.valueOf(independentReplicateMetric6.nDifferentAllelesTriDups + 1);
                        break;
                    }
                    case 3: {
                        IndependentReplicateMetric independentReplicateMetric7 = independentReplicateMetric2;
                        Integer n28 = independentReplicateMetric7.nAlternateAllelesTriDups;
                        Integer n29 = independentReplicateMetric7.nAlternateAllelesTriDups = Integer.valueOf(independentReplicateMetric7.nAlternateAllelesTriDups + 1);
                        break;
                    }
                    case 4: {
                        IndependentReplicateMetric independentReplicateMetric8 = independentReplicateMetric2;
                        Integer n30 = independentReplicateMetric8.nReferenceAllelesTriDups;
                        Integer n31 = independentReplicateMetric8.nReferenceAllelesTriDups = Integer.valueOf(independentReplicateMetric8.nReferenceAllelesTriDups + 1);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Un possible!");
                    }
                }
            }
            if (this.STOP_AFTER <= 0 || progressLogger.getCount() <= (long)this.STOP_AFTER.intValue()) continue;
            break;
        }
        if (bl2 && bl3) {
            independentReplicateMetric.merge(independentReplicateMetric2);
            log.debug(new Object[]{"Merged final metric. nSites:" + independentReplicateMetric.nSites});
        } else {
            metricsFile2 = independentReplicateMetric.nThreeAllelesSites;
            independentReplicateMetric.nThreeAllelesSites = independentReplicateMetric.nThreeAllelesSites + 1;
            metricsFile = independentReplicateMetric.nThreeAllelesSites;
            log.debug(new Object[]{"didn't merge last metric, due to 3rd allele: nThreeAllelesSites =" + independentReplicateMetric.nThreeAllelesSites});
        }
        log.info(new Object[]{"Iteration done. Emitting metrics."});
        metricsFile2 = this.getMetricsFile();
        independentReplicateMetric.calculateDerivedFields();
        metricsFile2.addMetric((MetricBase)independentReplicateMetric);
        metricsFile2.addHistogram(histogram5);
        metricsFile2.addHistogram(histogram3);
        metricsFile2.addHistogram(histogram4);
        metricsFile2.write(this.OUTPUT);
        metricsFile = this.getMetricsFile();
        if (this.MATRIX_OUTPUT != null) {
            metricsFile.addHistogram(histogram);
            metricsFile.addHistogram(histogram2);
            metricsFile.write(this.MATRIX_OUTPUT);
        }
        return 0;
    }

    private static boolean isCleanlyBefore(QueryInterval queryInterval, QueryInterval queryInterval2) {
        return !queryInterval.overlaps(queryInterval2) && queryInterval.compareTo(queryInterval2) < 0;
    }

    private static SetClassification classifySet(int n, int n2, int n3) {
        if (n3 != 0) {
            return SetClassification.MISMATCHING_ALLELE;
        }
        if (n2 > 0 && n > 0) {
            return SetClassification.DIFFERENT_ALLELES;
        }
        if (n == 0) {
            return SetClassification.ALTERNATE_ALLELE;
        }
        if (n2 == 0) {
            return SetClassification.REFERENCE_ALLELE;
        }
        throw new IllegalAccessError("shouldn't be here!");
    }

    private static QueryInterval queryIntervalFromSamRecord(SAMRecord sAMRecord) {
        return new QueryInterval(sAMRecord.getReferenceIndex().intValue(), sAMRecord.getStart(), sAMRecord.getEnd());
    }

    private static byte calculateEditDistance(String string, String string2) {
        assert (string.length() == string2.length());
        byte by = 0;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == string.charAt(i)) continue;
            by = (byte)(by + 1);
        }
        return by;
    }

    private SortedMap<QueryInterval, List<Allele>> getQueryIntervalsMap(File file) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        VCFFileReader vCFFileReader = new VCFFileReader(file, false);
        CompoundFilter compoundFilter = new CompoundFilter(true);
        compoundFilter.add((Object)new SnpFilter());
        compoundFilter.add((Object)new PassingVariantFilter());
        compoundFilter.add((Object)new GenotypeQualityFilter(this.MINIMUM_GQ.intValue(), this.SAMPLE));
        compoundFilter.add((Object)new HeterozygosityFilter(true, this.SAMPLE));
        FilteringVariantContextIterator filteringVariantContextIterator = new FilteringVariantContextIterator((Iterator)vCFFileReader.iterator(), (VariantContextFilter)compoundFilter);
        for (VCFContigHeaderLine vCFContigHeaderLine : vCFFileReader.getFileHeader().getContigLines()) {
            hashMap.put(vCFContigHeaderLine.getID(), vCFContigHeaderLine.getContigIndex());
        }
        TreeMap treeMap = new TreeMap();
        while (filteringVariantContextIterator.hasNext()) {
            VCFContigHeaderLine vCFContigHeaderLine;
            vCFContigHeaderLine = (VariantContext)filteringVariantContextIterator.next();
            treeMap.put(new QueryInterval(((Integer)hashMap.get(vCFContigHeaderLine.getContig())).intValue(), vCFContigHeaderLine.getStart(), vCFContigHeaderLine.getEnd()), vCFContigHeaderLine.getGenotype(this.SAMPLE).getAlleles());
        }
        vCFFileReader.close();
        return treeMap;
    }

    private static enum SetClassification {
        MISMATCHING_ALLELE,
        DIFFERENT_ALLELES,
        REFERENCE_ALLELE,
        ALTERNATE_ALLELE;

    }
}

