/*
 * Decompiled with CFR 0.152.
 */
package picard.filter;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;

public abstract class CountingFilter
implements SamRecordFilter {
    private long filteredRecords = 0L;
    private long filteredBases = 0L;

    public long getFilteredRecords() {
        return this.filteredRecords;
    }

    public long getFilteredBases() {
        return this.filteredBases;
    }

    public final boolean filterOut(SAMRecord sAMRecord) {
        boolean bl = this.reallyFilterOut(sAMRecord);
        if (bl) {
            ++this.filteredRecords;
            for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
                this.filteredBases += (long)alignmentBlock.getLength();
            }
        }
        return bl;
    }

    public abstract boolean reallyFilterOut(SAMRecord var1);

    public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        throw new UnsupportedOperationException();
    }
}

