/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import picard.PicardException;

public enum DiploidGenotype {
    AA('A', 'A'),
    AC('A', 'C'),
    AG('A', 'G'),
    AT('A', 'T'),
    CC('C', 'C'),
    CG('C', 'G'),
    CT('C', 'T'),
    GG('G', 'G'),
    GT('G', 'T'),
    TT('T', 'T');

    private static final Map<Integer, DiploidGenotype> genotypes;
    private final byte allele1;
    private final byte allele2;

    public static DiploidGenotype fromBases(byte[] byArray) {
        if (byArray.length != 2) {
            throw new IllegalArgumentException("bases must contain 2 and only 2 bases, it actually contained " + byArray.length);
        }
        return DiploidGenotype.fromBases(byArray[0], byArray[1]);
    }

    public static DiploidGenotype fromBases(byte by, byte by2) {
        byte by3;
        byte by4 = StringUtil.toUpperCase((byte)by);
        DiploidGenotype diploidGenotype = genotypes.get(by4 + (by3 = StringUtil.toUpperCase((byte)by2)));
        if (diploidGenotype == null) {
            throw new IllegalArgumentException("Unknown genotype string [" + StringUtil.bytesToString((byte[])new byte[]{by, by2}) + "], any pair of ACTG case insensitive is acceptable");
        }
        return diploidGenotype;
    }

    public static boolean isValidBase(byte by) {
        switch (StringUtil.toUpperCase((byte)by)) {
            case 65: 
            case 67: 
            case 71: 
            case 84: {
                return true;
            }
        }
        return false;
    }

    private DiploidGenotype(char c, char c2) {
        this.allele1 = (byte)(c & 0xFF);
        this.allele2 = (byte)(c2 & 0xFF);
    }

    public byte getAllele1() {
        return this.allele1;
    }

    public byte getAllele2() {
        return this.allele2;
    }

    public boolean isHeterozygous() {
        return this.allele1 != this.allele2;
    }

    public boolean isHomomozygous() {
        return this.allele1 == this.allele2;
    }

    static {
        genotypes = new HashMap<Integer, DiploidGenotype>();
        for (DiploidGenotype diploidGenotype : DiploidGenotype.values()) {
            if (genotypes.put(diploidGenotype.allele1 + diploidGenotype.allele2, diploidGenotype) == null) continue;
            throw new PicardException("sum of allele values are not unique!!!");
        }
    }
}

