/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.NotPrimaryAlignmentFilter;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import picard.PicardException;
import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.Fingerprint;
import picard.fingerprint.FingerprintResults;
import picard.fingerprint.GenotypeReader;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeMap;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromContaminatorSequence;
import picard.fingerprint.HaplotypeProbabilitiesFromGenotype;
import picard.fingerprint.HaplotypeProbabilitiesFromGenotypeLikelihoods;
import picard.fingerprint.HaplotypeProbabilitiesFromSequence;
import picard.fingerprint.HaplotypeProbabilityOfNormalGivenTumor;
import picard.fingerprint.LocusResult;
import picard.fingerprint.MatchResults;
import picard.fingerprint.Snp;

public class FingerprintChecker {
    public static final double DEFAULT_GENOTYPING_ERROR_RATE = 0.01;
    public static final int DEFAULT_MINIMUM_MAPPING_QUALITY = 10;
    public static final int DEFAULT_MINIMUM_BASE_QUALITY = 20;
    public static final int DEFAULT_MAXIMAL_PL_DIFFERENCE = 30;
    private final HaplotypeMap haplotypes;
    private int minimumBaseQuality = 20;
    private int minimumMappingQuality = 10;
    private double genotypingErrorRate = 0.01;
    private int maximalPLDifference = 30;
    private boolean allowDuplicateReads = false;
    private double pLossofHet = 0.0;
    private final Log log = Log.getInstance(FingerprintChecker.class);

    public FingerprintChecker(File file) {
        this.haplotypes = new HaplotypeMap(file);
    }

    public FingerprintChecker(HaplotypeMap haplotypeMap) {
        this.haplotypes = haplotypeMap;
    }

    public void setMinimumBaseQuality(int n) {
        this.minimumBaseQuality = n;
    }

    public void setMinimumMappingQuality(int n) {
        this.minimumMappingQuality = n;
    }

    public void setGenotypingErrorRate(double d) {
        this.genotypingErrorRate = d;
    }

    public void setmaximalPLDifference(int n) {
        this.maximalPLDifference = n;
    }

    public SAMFileHeader getHeader() {
        return this.haplotypes.getHeader();
    }

    public void setAllowDuplicateReads(boolean bl) {
        this.allowDuplicateReads = bl;
    }

    public void setpLossofHet(double d) {
        this.pLossofHet = d;
    }

    public Map<String, Fingerprint> loadFingerprints(File file, String string) {
        IntervalList intervalList = this.haplotypes.getIntervalList();
        GenotypeReader genotypeReader = new GenotypeReader();
        GenotypeReader.VariantIterator variantIterator = genotypeReader.read(file, intervalList);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)this.haplotypes.getHeader().getSequenceDictionary(), (SAMSequenceDictionary)variantIterator.getSequenceDictionary());
        HashMap<String, Fingerprint> hashMap = new HashMap<String, Fingerprint>();
        Set set = null;
        if (string != null) {
            set = new HashSet<String>();
            set.add(string);
        }
        while (variantIterator.hasNext()) {
            Object object;
            VariantContext variantContext = (VariantContext)variantIterator.next();
            if (set == null) {
                set = variantContext.getSampleNames();
            }
            if (!FingerprintChecker.isUsableSnp(variantContext)) continue;
            HaplotypeBlock haplotypeBlock = this.haplotypes.getHaplotype(variantContext.getChr(), variantContext.getStart());
            Snp snp = this.haplotypes.getSnp(variantContext.getChr(), variantContext.getStart());
            if (haplotypeBlock == null) continue;
            boolean bl = true;
            for (Object object2 : variantContext.getAlleles()) {
                object = object2.getBases();
                if (((byte[])object).length <= 1 && (object[0] == snp.getAllele1() || object[0] == snp.getAllele2())) continue;
                bl = false;
            }
            if (!bl) {
                this.log.warn(new Object[]{"Problem with genotype file '" + file.getName() + "': Alleles " + variantContext.getAlleles() + " do not match to alleles for SNP " + snp + " with alleles " + snp.getAlleleString()});
                continue;
            }
            for (Object object3 : set) {
                Object object2;
                object2 = (Fingerprint)hashMap.get(object3);
                if (object2 == null) {
                    object2 = new Fingerprint((String)object3, file, null);
                    hashMap.put((String)object3, (Fingerprint)object2);
                }
                if ((object = (Object)variantContext.getGenotype((String)object3)) == null) {
                    throw new IllegalArgumentException("Cannot find sample " + (String)object3 + " in provided file: " + file);
                }
                if (object.hasPL()) {
                    HaplotypeProbabilitiesFromGenotypeLikelihoods haplotypeProbabilitiesFromGenotypeLikelihoods = new HaplotypeProbabilitiesFromGenotypeLikelihoods(haplotypeBlock);
                    int[] nArray = object.getPL();
                    int[] nArray2 = new int[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray2[i] = Math.min(this.maximalPLDifference, nArray[i]);
                    }
                    haplotypeProbabilitiesFromGenotypeLikelihoods.addToLogLikelihoods(snp, variantContext.getAlleles(), GenotypeLikelihoods.fromPLs((int[])nArray2).getAsVector());
                    ((Fingerprint)object2).add(haplotypeProbabilitiesFromGenotypeLikelihoods);
                    continue;
                }
                if (object.isNoCall() || ((TreeMap)object2).containsKey(haplotypeBlock)) continue;
                boolean bl2 = object.isHom();
                byte by = StringUtil.toUpperCase((byte)object.getAllele(0).getBases()[0]);
                double d = this.genotypingErrorRate / 2.0;
                double d2 = 1.0 - this.genotypingErrorRate;
                double[] dArray = new double[]{bl2 && by == snp.getAllele1() ? d2 : d, !bl2 ? d2 : d, bl2 && by == snp.getAllele2() ? d2 : d};
                ((Fingerprint)object2).add(new HaplotypeProbabilitiesFromGenotype(snp, haplotypeBlock, dArray[0], dArray[1], dArray[2]));
            }
        }
        return hashMap;
    }

    public static boolean isUsableSnp(VariantContext variantContext) {
        if (variantContext.isFiltered()) {
            return false;
        }
        if (variantContext.isIndel()) {
            return false;
        }
        if (variantContext.isMixed()) {
            return false;
        }
        for (Allele allele : variantContext.getAlleles()) {
            if (allele.length() == 1) continue;
            return false;
        }
        return true;
    }

    public IntervalList getLociToGenotype(Collection<Fingerprint> collection) {
        IntervalList intervalList = new IntervalList(this.haplotypes.getHeader());
        for (Fingerprint fingerprint : collection) {
            for (HaplotypeProbabilities haplotypeProbabilities : fingerprint.values()) {
                HaplotypeBlock haplotypeBlock = haplotypeProbabilities.getHaplotype();
                for (Snp snp : haplotypeBlock.getSnps()) {
                    intervalList.add(new Interval(snp.getChrom(), snp.getPos(), snp.getPos(), false, snp.getName()));
                }
            }
        }
        intervalList.sort();
        intervalList.unique();
        return intervalList;
    }

    public Map<SAMReadGroupRecord, Fingerprint> fingerprintSamFile(File file, IntervalList intervalList) {
        Cloneable cloneable;
        SAMFileReader sAMFileReader = new SAMFileReader(file);
        sAMFileReader.enableIndexCaching(true);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)this.haplotypes.getHeader().getSequenceDictionary(), (SAMSequenceDictionary)sAMFileReader.getFileHeader().getSequenceDictionary());
        SamLocusIterator samLocusIterator = new SamLocusIterator((SamReader)sAMFileReader, intervalList, sAMFileReader.hasIndex());
        samLocusIterator.setEmitUncoveredLoci(true);
        samLocusIterator.setMappingQualityScoreCutoff(this.minimumMappingQuality);
        samLocusIterator.setQualityScoreCutoff(this.minimumBaseQuality);
        if (this.allowDuplicateReads) {
            cloneable = new ArrayList(1);
            cloneable.add(new NotPrimaryAlignmentFilter());
            samLocusIterator.setSamFilters((List)((Object)cloneable));
        }
        cloneable = new HashMap();
        List list = sAMFileReader.getFileHeader().getReadGroups();
        for (Object object : list) {
            Object object2 = new Fingerprint(object.getSample(), file, object.getPlatformUnit() != null ? object.getPlatformUnit() : object.getId());
            cloneable.put(object, object2);
            for (HaplotypeBlock comparable : this.haplotypes.getHaplotypes()) {
                ((Fingerprint)object2).add(new HaplotypeProbabilitiesFromSequence(comparable));
            }
        }
        HashSet hashSet = new HashSet(10000);
        for (Object object2 : samLocusIterator) {
            HaplotypeBlock haplotypeBlock = this.haplotypes.getHaplotype(object2.getSequenceName(), object2.getPosition());
            Snp snp = this.haplotypes.getSnp(object2.getSequenceName(), object2.getPosition());
            for (SamLocusIterator.RecordAndOffset recordAndOffset : object2.getRecordAndPositions()) {
                Object object;
                SAMReadGroupRecord sAMReadGroupRecord = recordAndOffset.getRecord().getReadGroup();
                if (sAMReadGroupRecord == null || !cloneable.containsKey(sAMReadGroupRecord)) {
                    object = new PicardException("Unknown read group: " + sAMReadGroupRecord);
                    this.log.error((Throwable)object, new Object[0]);
                    throw object;
                }
                object = recordAndOffset.getRecord().getReadName();
                if (hashSet.contains(object)) continue;
                HaplotypeProbabilitiesFromSequence haplotypeProbabilitiesFromSequence = (HaplotypeProbabilitiesFromSequence)((Fingerprint)cloneable.get(sAMReadGroupRecord)).get(haplotypeBlock);
                byte by = StringUtil.toUpperCase((byte)recordAndOffset.getReadBase());
                byte by2 = recordAndOffset.getBaseQuality();
                haplotypeProbabilitiesFromSequence.addToProbs(snp, by, by2);
                hashSet.add(object);
            }
        }
        return cloneable;
    }

    public Map<String, Fingerprint> identifyContaminant(File file, double d, int n) {
        Cloneable cloneable;
        SamReader samReader = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES}).open(file);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)this.haplotypes.getHeader().getSequenceDictionary(), (SAMSequenceDictionary)samReader.getFileHeader().getSequenceDictionary());
        SamLocusIterator samLocusIterator = new SamLocusIterator(samReader, this.haplotypes.getIntervalList(), samReader.hasIndex());
        samLocusIterator.setEmitUncoveredLoci(true);
        samLocusIterator.setMappingQualityScoreCutoff(this.minimumMappingQuality);
        samLocusIterator.setQualityScoreCutoff(this.minimumBaseQuality);
        if (this.allowDuplicateReads) {
            cloneable = new ArrayList(1);
            cloneable.add(new NotPrimaryAlignmentFilter());
            samLocusIterator.setSamFilters((List)((Object)cloneable));
        }
        cloneable = new HashMap();
        for (Object object : samReader.getFileHeader().getReadGroups()) {
            if (cloneable.containsKey(object.getSample())) continue;
            Object object2 = new Fingerprint(object.getSample(), file, object.getSample());
            for (Comparable<HaplotypeBlock> comparable : this.haplotypes.getHaplotypes()) {
                ((Fingerprint)object2).add(new HaplotypeProbabilitiesFromContaminatorSequence((HaplotypeBlock)comparable, d));
            }
            cloneable.put(object.getSample(), object2);
        }
        HashSet hashSet = new HashSet(10000);
        for (Object object2 : samLocusIterator) {
            Comparable<HaplotypeBlock> comparable;
            HaplotypeBlock haplotypeBlock = this.haplotypes.getHaplotype(object2.getSequenceName(), object2.getPosition());
            comparable = this.haplotypes.getSnp(object2.getSequenceName(), object2.getPosition());
            List<SamLocusIterator.RecordAndOffset> list = FingerprintChecker.randomSublist(object2.getRecordAndPositions(), n);
            for (SamLocusIterator.RecordAndOffset recordAndOffset : list) {
                Object object;
                SAMReadGroupRecord sAMReadGroupRecord = recordAndOffset.getRecord().getReadGroup();
                if (sAMReadGroupRecord == null || !cloneable.containsKey(sAMReadGroupRecord.getSample())) {
                    object = new PicardException("Unknown sample: " + (sAMReadGroupRecord != null ? sAMReadGroupRecord.getSample() : "(null readgroup)"));
                    this.log.error((Throwable)object, new Object[0]);
                    throw object;
                }
                object = recordAndOffset.getRecord().getReadName();
                if (hashSet.contains(object)) continue;
                HaplotypeProbabilitiesFromContaminatorSequence haplotypeProbabilitiesFromContaminatorSequence = (HaplotypeProbabilitiesFromContaminatorSequence)((Fingerprint)cloneable.get(sAMReadGroupRecord.getSample())).get(haplotypeBlock);
                byte by = StringUtil.toUpperCase((byte)recordAndOffset.getReadBase());
                byte by2 = recordAndOffset.getBaseQuality();
                haplotypeProbabilitiesFromContaminatorSequence.addToProbs((Snp)comparable, by, by2);
                hashSet.add(object);
            }
        }
        return cloneable;
    }

    protected static <T> List<T> randomSublist(List<T> list, int n) {
        int n2 = list.size();
        if (n2 <= n) {
            return list;
        }
        int n3 = n;
        Random random = new Random();
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (T t : list) {
            if (random.nextDouble() < (double)n3 / (double)n2) {
                arrayList.add(t);
                --n3;
            }
            if (n3 == 0) break;
            --n2;
        }
        return arrayList;
    }

    public Map<SAMReadGroupRecord, Fingerprint> fingerprintSamFiles(final Collection<File> collection, int n, int n2, TimeUnit timeUnit) {
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        final IntervalList intervalList = this.haplotypes.getIntervalList();
        final ConcurrentHashMap<SAMReadGroupRecord, Fingerprint> concurrentHashMap = new ConcurrentHashMap<SAMReadGroupRecord, Fingerprint>();
        for (final File file : collection) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    concurrentHashMap.putAll(FingerprintChecker.this.fingerprintSamFile(file, intervalList));
                    if (atomicInteger.incrementAndGet() % 100 == 0) {
                        FingerprintChecker.this.log.info(new Object[]{"Processed " + atomicInteger.get() + " out of " + collection.size()});
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(n2, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            this.log.warn((Throwable)interruptedException, new Object[]{"Interrupted while waiting for executor to terminate."});
        }
        return concurrentHashMap;
    }

    public static SortedMap<String, Fingerprint> mergeFingerprintsBySample(Collection<Fingerprint> collection) {
        TreeMap<String, Fingerprint> treeMap = new TreeMap<String, Fingerprint>();
        for (Fingerprint fingerprint : collection) {
            Fingerprint fingerprint2 = (Fingerprint)treeMap.get(fingerprint.getSample());
            if (fingerprint2 == null) {
                fingerprint2 = new Fingerprint(fingerprint.getSample(), null, fingerprint.getSample());
                treeMap.put(fingerprint.getSample(), fingerprint2);
            }
            fingerprint2.merge(fingerprint);
        }
        return treeMap;
    }

    public List<FingerprintResults> checkFingerprints(List<File> list, List<File> list2, String string, boolean bl) {
        File file22;
        LinkedList<Fingerprint> linkedList = new LinkedList<Fingerprint>();
        for (File file22 : list2) {
            linkedList.addAll(this.loadFingerprints(file22, string).values());
        }
        if (linkedList.isEmpty()) {
            throw new IllegalStateException("Could not find any fingerprints in: " + list2);
        }
        ArrayList arrayList = new ArrayList();
        file22 = this.getLociToGenotype(linkedList);
        for (File file3 : list) {
            Map<SAMReadGroupRecord, Fingerprint> map = this.fingerprintSamFile(file3, (IntervalList)file22);
            if (bl) {
                Fingerprint fingerprint = new Fingerprint(string, file3, null);
                for (Fingerprint fingerprint2 : map.values()) {
                    fingerprint.merge(fingerprint2);
                }
                FingerprintResults fingerprintResults = new FingerprintResults(file3, string);
                for (Object object : linkedList) {
                    MatchResults matchResults = FingerprintChecker.calculateMatchResults(fingerprint, (Fingerprint)object, 0.0, this.pLossofHet);
                    fingerprintResults.addResults(matchResults);
                }
                arrayList.add(fingerprintResults);
                continue;
            }
            for (SAMReadGroupRecord sAMReadGroupRecord : map.keySet()) {
                Object object;
                FingerprintResults fingerprintResults = new FingerprintResults(file3, sAMReadGroupRecord.getPlatformUnit());
                object = linkedList.iterator();
                while (object.hasNext()) {
                    Fingerprint fingerprint = (Fingerprint)object.next();
                    MatchResults matchResults = FingerprintChecker.calculateMatchResults(map.get(sAMReadGroupRecord), fingerprint, 0.0, this.pLossofHet);
                    fingerprintResults.addResults(matchResults);
                }
                arrayList.add(fingerprintResults);
            }
        }
        return arrayList;
    }

    public static MatchResults calculateMatchResults(Fingerprint fingerprint, Fingerprint fingerprint2, double d, double d2) {
        ArrayList<LocusResult> arrayList = new ArrayList<LocusResult>();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = Math.log10(d);
        for (HaplotypeProbabilities haplotypeProbabilities : fingerprint2.values()) {
            HaplotypeBlock haplotypeBlock = haplotypeProbabilities.getHaplotype();
            HaplotypeProbabilities haplotypeProbabilities2 = (HaplotypeProbabilities)fingerprint.get(haplotypeBlock);
            if (haplotypeProbabilities2 == null) continue;
            HaplotypeProbabilityOfNormalGivenTumor haplotypeProbabilityOfNormalGivenTumor = new HaplotypeProbabilityOfNormalGivenTumor(haplotypeProbabilities2, d2);
            HaplotypeProbabilityOfNormalGivenTumor haplotypeProbabilityOfNormalGivenTumor2 = new HaplotypeProbabilityOfNormalGivenTumor(haplotypeProbabilities, d2);
            Snp snp = haplotypeProbabilities.getRepresentativeSnp();
            DiploidGenotype diploidGenotype = haplotypeProbabilities.getMostLikelyGenotype(snp);
            LocusResult locusResult = new LocusResult(snp, diploidGenotype, haplotypeProbabilities2.getMostLikelyGenotype(snp), haplotypeProbabilities2.getObsAllele1(), haplotypeProbabilities2.getObsAllele2(), haplotypeProbabilities2.getLodMostProbableGenotype(), haplotypeProbabilities2.shiftedLogEvidenceProbabilityGivenOtherEvidence(haplotypeProbabilities), haplotypeProbabilities2.shiftedLogEvidenceProbability(), haplotypeProbabilities.shiftedLogEvidenceProbabilityGivenOtherEvidence(haplotypeProbabilityOfNormalGivenTumor) - haplotypeProbabilities.shiftedLogEvidenceProbability(), haplotypeProbabilities2.shiftedLogEvidenceProbabilityGivenOtherEvidence(haplotypeProbabilityOfNormalGivenTumor2) - haplotypeProbabilities2.shiftedLogEvidenceProbability());
            arrayList.add(locusResult);
            if (!haplotypeProbabilities2.hasEvidence() || !haplotypeProbabilities.hasEvidence()) continue;
            double d8 = locusResult.lRandomSample();
            double d9 = Math.max(d7, locusResult.lExpectedSample());
            d3 += d9;
            d4 += d8;
            d5 += locusResult.getLodExpectedSampleTumorNormal();
            d6 += locusResult.getLodExpectedSampleNormalTumor();
        }
        return new MatchResults(fingerprint2.getSource(), fingerprint2.getSample(), d3, d4, d5, d6, arrayList);
    }

    public static MatchResults calculateMatchResults(Fingerprint fingerprint, Fingerprint fingerprint2) {
        return FingerprintChecker.calculateMatchResults(fingerprint, fingerprint2, 0.0, 0.0);
    }
}

