/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import picard.PicardException;
import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.DiploidHaplotype;
import picard.fingerprint.Snp;

public class HaplotypeBlock
implements Comparable<HaplotypeBlock> {
    private final double maf;
    private final Map<String, Snp> snpsByName = new HashMap<String, Snp>();
    private final double[] haplotypeFrequencies = new double[3];
    private Snp firstSnp;
    private String chrom;
    private int start;
    private int end;

    public HaplotypeBlock(double d) {
        this.maf = d;
        double d2 = 1.0 - d;
        this.haplotypeFrequencies[0] = d2 * d2;
        this.haplotypeFrequencies[1] = d2 * d * 2.0;
        this.haplotypeFrequencies[2] = d * d;
    }

    public double[] getHaplotypeFrequencies() {
        return this.haplotypeFrequencies;
    }

    public void addSnp(Snp snp) {
        if (this.snpsByName.isEmpty()) {
            this.chrom = snp.getChrom();
            this.start = snp.getPos();
            this.end = snp.getPos();
            this.firstSnp = snp;
        } else {
            if (!this.chrom.equals(snp.getChrom())) {
                throw new PicardException("Snp chromosome " + snp.getChrom() + " does not agree with chromosome of existing snp(s): " + this.chrom);
            }
            if (snp.getPos() < this.start) {
                this.start = snp.getPos();
                this.firstSnp = snp;
            }
            if (snp.getPos() > this.end) {
                this.end = snp.getPos();
            }
        }
        this.snpsByName.put(snp.getName(), snp);
    }

    public Snp getSnp(String string) {
        return this.snpsByName.get(string);
    }

    public Snp getFirstSnp() {
        return this.firstSnp;
    }

    public boolean contains(Snp snp) {
        Snp snp2 = this.snpsByName.get(snp.getName());
        return snp2 != null && snp2.getChrom().equals(snp.getChrom()) && snp2.getPos() == snp.getPos();
    }

    public int size() {
        return this.snpsByName.size();
    }

    public Collection<Snp> getSnps() {
        return Collections.unmodifiableCollection(this.snpsByName.values());
    }

    public double getHaplotypeFrequency(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Illegal haplotype index " + n);
        }
        return this.haplotypeFrequencies[n];
    }

    public double getMaf() {
        return this.maf;
    }

    public DiploidGenotype getSnpGenotype(Snp snp, DiploidHaplotype diploidHaplotype) {
        if (!this.contains(snp)) {
            throw new IllegalArgumentException("Snp is not part of haplotype " + snp);
        }
        return snp.getGenotype(diploidHaplotype);
    }

    public DiploidHaplotype getDiploidHaplotype(Snp snp, DiploidGenotype diploidGenotype) {
        if (!this.contains(snp)) {
            throw new IllegalArgumentException("Snp is not part of haplotype " + snp);
        }
        return DiploidHaplotype.values()[snp.indexOf(diploidGenotype)];
    }

    @Override
    public int compareTo(HaplotypeBlock haplotypeBlock) {
        int n = this.chrom.compareTo(haplotypeBlock.chrom);
        if (n == 0) {
            n = this.start - haplotypeBlock.start;
        }
        if (n == 0) {
            n = this.end - haplotypeBlock.end;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.compareTo((HaplotypeBlock)object) == 0;
    }

    public int hashCode() {
        return this.start;
    }

    public String toString() {
        return this.chrom + "[" + this.start + "-" + this.end + "]";
    }
}

