/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.QualityUtil;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesUsingLogLikelihoods;
import picard.fingerprint.Snp;

public class HaplotypeProbabilitiesFromSequence
extends HaplotypeProbabilitiesUsingLogLikelihoods {
    protected int obsAllele1;
    protected int obsAllele2;
    protected int obsAlleleOther;

    public HaplotypeProbabilitiesFromSequence(HaplotypeBlock haplotypeBlock) {
        super(haplotypeBlock);
    }

    @Override
    public boolean hasEvidence() {
        return super.hasEvidence() || this.obsAllele1 > 0 || this.obsAllele2 > 0;
    }

    public void addToProbs(Snp snp, byte by, byte by2) {
        this.assertSnpPartOfHaplotype(snp);
        double[] dArray = this.getLogLikelihoods();
        double d = QualityUtil.getErrorProbabilityFromPhredScore((int)by2);
        if (by == snp.getAllele1()) {
            ++this.obsAllele1;
            for (HaplotypeProbabilities.Genotype genotype : HaplotypeProbabilities.Genotype.values()) {
                double d2 = (double)genotype.v / 2.0;
                int n = genotype.v;
                dArray[n] = dArray[n] + Math.log10((1.0 - d2) * (1.0 - d) + d2 * d);
            }
        } else if (by == snp.getAllele2()) {
            ++this.obsAllele2;
            for (HaplotypeProbabilities.Genotype genotype : HaplotypeProbabilities.Genotype.values()) {
                double d3 = 1.0 - (double)genotype.v / 2.0;
                int n = genotype.v;
                dArray[n] = dArray[n] + Math.log10((1.0 - d3) * (1.0 - d) + d3 * d);
            }
        } else {
            ++this.obsAlleleOther;
        }
        this.setLogLikelihoods(dArray);
    }

    @Override
    public void merge(HaplotypeProbabilities haplotypeProbabilities) {
        super.merge(haplotypeProbabilities);
        if (!this.getHaplotype().equals(haplotypeProbabilities.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + haplotypeProbabilities.getHaplotype());
        }
        if (!(haplotypeProbabilities instanceof HaplotypeProbabilitiesFromSequence)) {
            throw new IllegalArgumentException("Can only merge() HaplotypeProbabilities of same class: Tried to merge a " + this.getClass().getName() + " with a " + haplotypeProbabilities.getClass().getName() + ".");
        }
        HaplotypeProbabilitiesFromSequence haplotypeProbabilitiesFromSequence = (HaplotypeProbabilitiesFromSequence)haplotypeProbabilities;
        this.obsAllele1 += haplotypeProbabilitiesFromSequence.obsAllele1;
        this.obsAllele2 += haplotypeProbabilitiesFromSequence.obsAllele2;
        this.obsAlleleOther += haplotypeProbabilitiesFromSequence.obsAlleleOther;
    }

    @Override
    public int getObsAllele1() {
        return this.obsAllele1;
    }

    @Override
    public int getObsAllele2() {
        return this.obsAllele2;
    }

    @Override
    public int getTotalObs() {
        return this.obsAllele1 + this.obsAllele2 + this.obsAlleleOther;
    }

    public double getFractionUnexpectedAlleleObs() {
        return (double)this.obsAlleleOther / (double)this.getTotalObs();
    }
}

