/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;

public class HaplotypeProbabilityOfNormalGivenTumor
extends HaplotypeProbabilities {
    private final double[][] transitionMatrix;
    private final HaplotypeProbabilities hpOfTumor;

    public HaplotypeProbabilityOfNormalGivenTumor(HaplotypeProbabilities haplotypeProbabilities, double d) {
        super(haplotypeProbabilities.getHaplotype());
        this.hpOfTumor = haplotypeProbabilities;
        this.transitionMatrix = new double[][]{{1.0, 0.0, 0.0}, {d / 2.0, 1.0 - d, d / 2.0}, {0.0, 0.0, 1.0}};
    }

    @Override
    public double[] getLikelihoods() {
        double[] dArray = new double[3];
        double[] dArray2 = this.hpOfTumor.getLikelihoods();
        for (HaplotypeProbabilities.Genotype genotype : HaplotypeProbabilities.Genotype.values()) {
            for (HaplotypeProbabilities.Genotype genotype2 : HaplotypeProbabilities.Genotype.values()) {
                int n = genotype2.v;
                dArray[n] = dArray[n] + dArray2[genotype.v] * this.transitionMatrix[genotype.v][genotype2.v];
            }
        }
        return dArray;
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.hpOfTumor.getRepresentativeSnp();
    }

    @Override
    public void merge(HaplotypeProbabilities haplotypeProbabilities) {
        throw new IllegalArgumentException("Cannot merge HaplotypeProbabilityOfNormalGivenTumor. Merge the underlying object and create a new wrapper.");
    }

    @Override
    public int getObsAllele1() {
        return this.hpOfTumor.getObsAllele1();
    }

    @Override
    public int getObsAllele2() {
        return this.hpOfTumor.getObsAllele2();
    }

    @Override
    public int getTotalObs() {
        return this.hpOfTumor.getTotalObs();
    }

    @Override
    public boolean hasEvidence() {
        return this.hpOfTumor.hasEvidence();
    }
}

