/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.DiploidHaplotype;

public class Snp
implements Comparable<Snp> {
    private final String name;
    private final String chrom;
    private final int pos;
    private final byte allele1;
    private final byte allele2;
    private final double maf;
    private final List<String> fingerprintPanels;
    private final DiploidGenotype[] genotypes = new DiploidGenotype[3];

    public Snp(String string, String string2, int n, byte by, byte by2, double d, List<String> arrayList) {
        this.name = string;
        this.chrom = string2;
        this.pos = n;
        this.allele1 = StringUtil.toUpperCase((byte)by);
        this.allele2 = StringUtil.toUpperCase((byte)by2);
        this.maf = d;
        this.fingerprintPanels = arrayList == null ? new ArrayList() : arrayList;
        this.genotypes[0] = DiploidGenotype.fromBases(by, by);
        this.genotypes[1] = DiploidGenotype.fromBases(by, by2);
        this.genotypes[2] = DiploidGenotype.fromBases(by2, by2);
    }

    public Snp flip() {
        return new Snp(this.name, this.chrom, this.pos, this.allele2, this.allele1, 1.0 - this.maf, this.fingerprintPanels);
    }

    public String getName() {
        return this.name;
    }

    public String getChrom() {
        return this.chrom;
    }

    public int getPos() {
        return this.pos;
    }

    public byte getAllele1() {
        return this.allele1;
    }

    public byte getAllele2() {
        return this.allele2;
    }

    public double getMaf() {
        return this.maf;
    }

    public List<String> getFingerprintPanels() {
        return this.fingerprintPanels;
    }

    public DiploidGenotype getHomozygousAllele1Genotype() {
        return this.genotypes[0];
    }

    public DiploidGenotype getHeterogyzousGenotype() {
        return this.genotypes[1];
    }

    public DiploidGenotype getHomozygousAllele2Genotype() {
        return this.genotypes[2];
    }

    DiploidGenotype getGenotype(DiploidHaplotype diploidHaplotype) {
        return this.genotypes[diploidHaplotype.ordinal()];
    }

    int indexOf(DiploidGenotype diploidGenotype) {
        for (int i = 0; i < this.genotypes.length; ++i) {
            if (diploidGenotype != this.genotypes[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Genotype " + (Object)((Object)diploidGenotype) + " is not valid for this SNP.");
    }

    public String getAlleleString() {
        return StringUtil.bytesToString((byte[])new byte[]{this.allele1, StringUtil.toLowerCase((byte)this.allele2)});
    }

    @Override
    public int compareTo(Snp snp) {
        int n = this.chrom.compareTo(snp.chrom);
        if (n == 0) {
            n = this.pos - snp.pos;
        }
        return n;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Snp && this.compareTo((Snp)object) == 0;
    }

    public int hashCode() {
        int n = this.chrom.hashCode();
        n = 31 * n + this.pos;
        return n;
    }

    public String toString() {
        return this.chrom + ":" + this.pos;
    }
}

