/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Illumina;
import picard.illumina.IlluminaLaneMetrics;
import picard.illumina.IlluminaPhasingMetrics;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.Tile;
import picard.illumina.parser.TileMetricsUtil;

@CommandLineProgramProperties(usage="Collects Illumina lane metrics for the given basecalling analysis directory", usageShort="Collects Illumina lane metrics for the given basecalling analysis directory", programGroup=Illumina.class)
public class CollectIlluminaLaneMetrics
extends CommandLineProgram {
    static final String USAGE = "Collects Illumina lane metrics for the given basecalling analysis directory";
    @Option(doc="The Illumina run directory of the run for which the lane metrics are to be generated")
    public File RUN_DIRECTORY;
    @Option(doc="The directory to which the output file will be written")
    public File OUTPUT_DIRECTORY;
    @Option(doc="The prefix to be prepended to the file name of the output file; an appropriate suffix will be applied", shortName="O")
    public String OUTPUT_PREFIX;
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Sample Barcode, M for molecular barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"28T8M8B8S28T\" then the sequence may be split up into four reads:\n* read one with 28 cycles (bases) of template\n* read two with 8 cycles (bases) of molecular barcode (ex. unique molecular barcode)\n* read three with 8 cycles (bases) of sample barcode\n* 8 cycles (bases) skipped.\n* read four with 28 cycles (bases) of template\nThe skipped cycles would NOT be included in an output SAM/BAM file or in read groups therein.", shortName="RS")
    public ReadStructure READ_STRUCTURE;

    @Override
    protected int doWork() {
        MetricsFile metricsFile = this.getMetricsFile();
        MetricsFile metricsFile2 = this.getMetricsFile();
        IlluminaLaneMetricsCollector.collectLaneMetrics(this.RUN_DIRECTORY, this.OUTPUT_DIRECTORY, this.OUTPUT_PREFIX, metricsFile, metricsFile2, this.READ_STRUCTURE);
        return 0;
    }

    public static void main(String[] stringArray) {
        new CollectIlluminaLaneMetrics().instanceMainWithExit(stringArray);
    }

    public static class IlluminaLaneMetricsCollector {
        private static final Log LOG = Log.getInstance(IlluminaLaneMetricsCollector.class);

        public static Map<Integer, ? extends Collection<Tile>> readLaneTiles(File file, ReadStructure readStructure) {
            Collection<Tile> collection;
            try {
                collection = TileMetricsUtil.parseTileMetrics(TileMetricsUtil.renderTileMetricsFileFromBasecallingDirectory(file), readStructure);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PicardException("Unable to open laneMetrics file.", fileNotFoundException);
            }
            return collection.stream().collect(Collectors.groupingBy(Tile::getLaneNumber));
        }

        public static void collectLaneMetrics(File file, File file2, String string, MetricsFile<MetricBase, Comparable<?>> metricsFile, MetricsFile<MetricBase, Comparable<?>> metricsFile2, ReadStructure readStructure) {
            Map<Integer, ? extends Collection<Tile>> map = IlluminaLaneMetricsCollector.readLaneTiles(file, readStructure);
            IlluminaLaneMetricsCollector.writeLaneMetrics(map, file2, string, metricsFile);
            IlluminaLaneMetricsCollector.writePhasingMetrics(map, file2, string, metricsFile2);
        }

        public static File writePhasingMetrics(Map<Integer, ? extends Collection<Tile>> map, File file, String string, MetricsFile<MetricBase, Comparable<?>> metricsFile) {
            map.entrySet().stream().forEach(entry -> IlluminaPhasingMetrics.getPhasingMetricsForTiles(((Integer)entry.getKey()).longValue(), (Collection)entry.getValue()).forEach(arg_0 -> ((MetricsFile)metricsFile).addMetric(arg_0)));
            return IlluminaLaneMetricsCollector.writeMetrics(metricsFile, file, string, IlluminaPhasingMetrics.getExtension());
        }

        public static File writeLaneMetrics(Map<Integer, ? extends Collection<Tile>> map, File file, String string, MetricsFile<MetricBase, Comparable<?>> metricsFile) {
            map.entrySet().stream().forEach(entry -> {
                IlluminaLaneMetrics illuminaLaneMetrics = new IlluminaLaneMetrics();
                illuminaLaneMetrics.LANE = ((Integer)entry.getKey()).longValue();
                illuminaLaneMetrics.CLUSTER_DENSITY = IlluminaLaneMetricsCollector.calculateLaneDensityFromTiles((Collection)entry.getValue());
                metricsFile.addMetric((MetricBase)illuminaLaneMetrics);
            });
            return IlluminaLaneMetricsCollector.writeMetrics(metricsFile, file, string, IlluminaLaneMetrics.getExtension());
        }

        private static File writeMetrics(MetricsFile<MetricBase, Comparable<?>> metricsFile, File file, String string, String string2) {
            File file2 = new File(file, String.format("%s.%s", string, string2));
            LOG.info(new Object[]{String.format("Writing %s lane metrics to %s ...", metricsFile.getMetrics().size(), file2)});
            metricsFile.write(file2);
            return file2;
        }

        private static double calculateLaneDensityFromTiles(Collection<Tile> collection) {
            double d = 0.0;
            double d2 = 0.0;
            for (Tile tile : collection) {
                d += (double)(tile.getClusterCount() / tile.getClusterDensity());
                d2 += (double)tile.getClusterCount();
            }
            return d2 / d;
        }
    }
}

