/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.metrics.MetricBase;
import java.util.ArrayList;
import java.util.Collection;
import picard.illumina.LanePhasingMetricsCollector;
import picard.illumina.parser.Tile;
import picard.illumina.parser.TileTemplateRead;

public class IlluminaPhasingMetrics
extends MetricBase {
    public long LANE;
    public String TYPE_NAME;
    public double PHASING_APPLIED;
    public double PREPHASING_APPLIED;

    public static Collection<IlluminaPhasingMetrics> getPhasingMetricsForTiles(long l, Collection<Tile> collection) {
        LanePhasingMetricsCollector lanePhasingMetricsCollector = new LanePhasingMetricsCollector(collection);
        ArrayList<IlluminaPhasingMetrics> arrayList = new ArrayList<IlluminaPhasingMetrics>();
        for (TileTemplateRead tileTemplateRead : lanePhasingMetricsCollector.getMedianPhasingMap().keySet()) {
            IlluminaPhasingMetrics illuminaPhasingMetrics = new IlluminaPhasingMetrics();
            illuminaPhasingMetrics.LANE = l;
            illuminaPhasingMetrics.TYPE_NAME = tileTemplateRead.toString();
            illuminaPhasingMetrics.PHASING_APPLIED = lanePhasingMetricsCollector.getMedianPhasingMap().get((Object)tileTemplateRead).floatValue();
            illuminaPhasingMetrics.PREPHASING_APPLIED = lanePhasingMetricsCollector.getMedianPrePhasingMap().get((Object)tileTemplateRead).floatValue();
            arrayList.add(illuminaPhasingMetrics);
        }
        return arrayList;
    }

    public static String getExtension() {
        return "illumina_phasing_metrics";
    }
}

