/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import picard.illumina.parser.Tile;
import picard.illumina.parser.TileTemplateRead;
import picard.util.MathUtil;

public class LanePhasingMetricsCollector {
    private final Map<TileTemplateRead, Float> medianPhasingMap;
    private final Map<TileTemplateRead, Float> medianPrePhasingMap;

    public LanePhasingMetricsCollector(Collection<Tile> collection) {
        TreeMap<TileTemplateRead, Float> treeMap = new TreeMap<TileTemplateRead, Float>();
        TreeMap<TileTemplateRead, Float> treeMap2 = new TreeMap<TileTemplateRead, Float>();
        CollectionUtil.MultiMap multiMap = new CollectionUtil.MultiMap();
        CollectionUtil.MultiMap multiMap2 = new CollectionUtil.MultiMap();
        for (Tile object : collection) {
            for (TileTemplateRead tileTemplateRead : object.getPhasingMap().keySet()) {
                multiMap.append((Object)tileTemplateRead, (Object)object.getPhasingMap().get((Object)tileTemplateRead));
                multiMap2.append((Object)tileTemplateRead, (Object)object.getPrePhasingMap().get((Object)tileTemplateRead));
            }
        }
        for (TileTemplateRead tileTemplateRead : multiMap.keySet()) {
            treeMap.put(tileTemplateRead, Float.valueOf(LanePhasingMetricsCollector.medianPercentage((Collection)multiMap.get((Object)tileTemplateRead))));
            treeMap2.put(tileTemplateRead, Float.valueOf(LanePhasingMetricsCollector.medianPercentage((Collection)multiMap2.get((Object)tileTemplateRead))));
        }
        this.medianPhasingMap = Collections.unmodifiableMap(treeMap);
        this.medianPrePhasingMap = Collections.unmodifiableMap(treeMap2);
    }

    public Map<TileTemplateRead, Float> getMedianPhasingMap() {
        return this.medianPhasingMap;
    }

    public Map<TileTemplateRead, Float> getMedianPrePhasingMap() {
        return this.medianPrePhasingMap;
    }

    private static float medianPercentage(Collection<Float> collection) {
        double[] dArray = new double[collection.size()];
        int n = 0;
        for (Float f : collection) {
            dArray[n] = f.floatValue();
            ++n;
        }
        return (float)MathUtil.median(dArray) * 100.0f;
    }
}

