/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Illumina;
import picard.util.AdapterMarker;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;

@CommandLineProgramProperties(usage="Reads a SAM or BAM file and rewrites it with new adapter-trimming tags.\nClear any existing adapter-trimming tags (XT:i:).\nOnly works for unaligned files in query-name order.\nNote: This is a utility program and will not be run in the pipeline.\n", usageShort="Reads a SAM or BAM file and rewrites it with new adapter-trimming tags", programGroup=Illumina.class)
public class MarkIlluminaAdapters
extends CommandLineProgram {
    @Option(shortName="I")
    public File INPUT;
    @Option(doc="If output is not specified, just the metrics are generated", shortName="O", optional=true)
    public File OUTPUT;
    @Option(doc="Histogram showing counts of bases_clipped in how many reads", shortName="M")
    public File METRICS;
    @Option(doc="The minimum number of bases to match over when clipping single-end reads.")
    public int MIN_MATCH_BASES_SE = 12;
    @Option(doc="The minimum number of bases to match over (per-read) when clipping paired-end reads.")
    public int MIN_MATCH_BASES_PE = 6;
    @Option(doc="The maximum mismatch error rate to tolerate when clipping single-end reads.")
    public double MAX_ERROR_RATE_SE = 0.1;
    @Option(doc="The maximum mismatch error rate to tolerate when clipping paired-end reads.")
    public double MAX_ERROR_RATE_PE = 0.1;
    @Option(doc="DEPRECATED. Whether this is a paired-end run. No longer used.", shortName="PE", optional=true)
    public Boolean PAIRED_RUN;
    @Option(doc="Which adapters sequences to attempt to identify and clip.")
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS = CollectionUtil.makeList((Object[])new IlluminaUtil.IlluminaAdapterPair[]{IlluminaUtil.IlluminaAdapterPair.INDEXED, IlluminaUtil.IlluminaAdapterPair.DUAL_INDEXED, IlluminaUtil.IlluminaAdapterPair.PAIRED_END});
    @Option(doc="For specifying adapters other than standard Illumina", optional=true)
    public String FIVE_PRIME_ADAPTER;
    @Option(doc="For specifying adapters other than standard Illumina", optional=true)
    public String THREE_PRIME_ADAPTER;
    @Option(doc="Adapters are truncated to this length to speed adapter matching.  Set to a large number to effectively disable truncation.")
    public int ADAPTER_TRUNCATION_LENGTH = 30;
    @Option(doc="If looking for multiple adapter sequences, then after having seen this many adapters, shorten the list of sequences. Keep the adapters that were found most frequently in the input so far. Set to -1 if the input has a heterogeneous mix of adapters so shortening is undesirable.", shortName="APT")
    public int PRUNE_ADAPTER_LIST_AFTER_THIS_MANY_ADAPTERS_SEEN = 100;
    @Option(doc="If pruning the adapter list, keep only this many adapter sequences when pruning the list (plus any adapters that were tied with the adapters being kept).")
    public int NUM_ADAPTERS_TO_KEEP = 1;
    private static final Log log = Log.getInstance(MarkIlluminaAdapters.class);

    public static void main(String[] stringArray) {
        System.exit(new MarkIlluminaAdapters().instanceMain(stringArray));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.FIVE_PRIME_ADAPTER != null && this.THREE_PRIME_ADAPTER == null || this.THREE_PRIME_ADAPTER != null && this.FIVE_PRIME_ADAPTER == null) {
            return new String[]{"Either both or neither of THREE_PRIME_ADAPTER and FIVE_PRIME_ADAPTER must be set."};
        }
        return null;
    }

    @Override
    protected int doWork() {
        SAMRecord sAMRecord;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.METRICS);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        SAMFileHeader.SortOrder sortOrder = samReader.getFileHeader().getSortOrder();
        SAMFileWriter sAMFileWriter = null;
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
            sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(samReader.getFileHeader(), true, this.OUTPUT);
        }
        Histogram histogram = new Histogram("clipped_bases", "read_count");
        ProgressLogger progressLogger = new ArrayList();
        progressLogger.addAll(this.ADAPTERS);
        if (this.FIVE_PRIME_ADAPTER != null && this.THREE_PRIME_ADAPTER != null) {
            progressLogger.add(new CustomAdapterPair(this.FIVE_PRIME_ADAPTER, this.THREE_PRIME_ADAPTER));
        }
        AdapterPair[] adapterPairArray = progressLogger.toArray(new AdapterPair[progressLogger.size()]);
        progressLogger = new ProgressLogger(log, 1000000, "Read");
        SAMRecordIterator sAMRecordIterator = samReader.iterator();
        AdapterMarker adapterMarker = new AdapterMarker(this.ADAPTER_TRUNCATION_LENGTH, adapterPairArray).setMaxPairErrorRate(this.MAX_ERROR_RATE_PE).setMinPairMatchBases(this.MIN_MATCH_BASES_PE).setMaxSingleEndErrorRate(this.MAX_ERROR_RATE_SE).setMinSingleEndMatchBases(this.MIN_MATCH_BASES_SE).setNumAdaptersToKeep(this.NUM_ADAPTERS_TO_KEEP).setThresholdForSelectingAdaptersToKeep(this.PRUNE_ADAPTER_LIST_AFTER_THIS_MANY_ADAPTERS_SEEN);
        while (sAMRecordIterator.hasNext()) {
            sAMRecord = (SAMRecord)sAMRecordIterator.next();
            SAMRecord sAMRecord2 = sAMRecord.getReadPairedFlag() && sAMRecordIterator.hasNext() ? (SAMRecord)sAMRecordIterator.next() : null;
            sAMRecord.setAttribute("XT", null);
            if (sAMRecord.getReadPairedFlag()) {
                SAMRecord sAMRecord3;
                SAMRecord sAMRecord4;
                if (sortOrder != SAMFileHeader.SortOrder.queryname) {
                    throw new PicardException("Input BAM file must be sorted by queryname");
                }
                if (sAMRecord2 == null) {
                    throw new PicardException("Missing mate pair for paired read: " + sAMRecord.getReadName());
                }
                sAMRecord2.setAttribute("XT", null);
                if (!sAMRecord.getReadName().equals(sAMRecord2.getReadName())) {
                    throw new PicardException("Adjacent reads expected to be mate-pairs have different names: " + sAMRecord.getReadName() + ", " + sAMRecord2.getReadName());
                }
                if (sAMRecord.getFirstOfPairFlag() && sAMRecord2.getSecondOfPairFlag()) {
                    sAMRecord4 = sAMRecord;
                    sAMRecord3 = sAMRecord2;
                } else if (sAMRecord.getSecondOfPairFlag() && sAMRecord2.getFirstOfPairFlag()) {
                    sAMRecord4 = sAMRecord2;
                    sAMRecord3 = sAMRecord;
                } else {
                    throw new PicardException("Two reads with same name but not correctly marked as 1st/2nd of pair: " + sAMRecord.getReadName());
                }
                adapterMarker.adapterTrimIlluminaPairedReads(sAMRecord4, sAMRecord3);
            } else {
                adapterMarker.adapterTrimIlluminaSingleRead(sAMRecord);
            }
            for (SAMRecord sAMRecord5 : new SAMRecord[]{sAMRecord, sAMRecord2}) {
                Integer n;
                if (sAMRecord5 == null) continue;
                progressLogger.record(sAMRecord5);
                if (sAMFileWriter != null) {
                    sAMFileWriter.addAlignment(sAMRecord5);
                }
                if ((n = sAMRecord5.getIntegerAttribute("XT")) == null) continue;
                histogram.increment((Comparable)Integer.valueOf(sAMRecord5.getReadLength() - n + 1));
            }
        }
        if (sAMFileWriter != null) {
            sAMFileWriter.close();
        }
        sAMRecord = this.getMetricsFile();
        sAMRecord.setHistogram(histogram);
        sAMRecord.write(this.METRICS);
        CloserUtil.close((Object)samReader);
        return 0;
    }

    private final class CustomAdapterPair
    implements AdapterPair {
        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        private CustomAdapterPair(String string, String string2) {
            this.threePrime = string2;
            this.threePrimeBytes = StringUtil.stringToBytes((String)string2);
            this.fivePrime = string;
            this.fivePrimeReadOrder = SequenceUtil.reverseComplement((String)string);
            this.fivePrimeBytes = StringUtil.stringToBytes((String)string);
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes((String)this.fivePrimeReadOrder);
        }

        @Override
        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        @Override
        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        @Override
        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        @Override
        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }

        @Override
        public String getName() {
            return "Custom adapter pair";
        }
    }
}

