/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.PerTileParser;
import picard.illumina.parser.PfData;
import picard.illumina.parser.readers.FilterFileReader;

class FilterParser
extends PerTileParser<PfData> {
    private static Set<IlluminaDataType> supportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet((Object[])new IlluminaDataType[]{IlluminaDataType.PF}));

    public FilterParser(IlluminaFileMap illuminaFileMap) {
        super(illuminaFileMap);
    }

    public FilterParser(IlluminaFileMap illuminaFileMap, int n) {
        super(illuminaFileMap, n);
    }

    @Override
    protected CloseableIterator<PfData> makeTileIterator(final File file) {
        return new CloseableIterator<PfData>(){
            private FilterFileReader reader;
            {
                this.reader = new FilterFileReader(file);
            }

            public void close() {
                this.reader = null;
            }

            public boolean hasNext() {
                return this.reader.hasNext();
            }

            public PfData next() {
                final boolean bl = this.reader.next();
                return new PfData(){

                    @Override
                    public boolean isPf() {
                        return bl;
                    }
                };
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return supportedTypes;
    }
}

