/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.illumina.parser.MultiTileBclFileUtil;
import picard.illumina.parser.MultiTileFilterFileUtil;
import picard.illumina.parser.MultiTileLocsFileUtil;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.PerTileFileUtil;
import picard.illumina.parser.PerTilePerCycleFileUtil;
import picard.illumina.parser.fakers.BarcodeFileFaker;
import picard.illumina.parser.fakers.BclFileFaker;
import picard.illumina.parser.fakers.ClocsFileFaker;
import picard.illumina.parser.fakers.FilterFileFaker;
import picard.illumina.parser.fakers.LocsFileFaker;
import picard.illumina.parser.fakers.PosFileFaker;
import picard.illumina.parser.readers.TileMetricsOutReader;

public class IlluminaFileUtil {
    public static final Pattern CYCLE_SUBDIRECTORY_PATTERN = Pattern.compile("^C(\\d+)\\.1$");
    private final File basecallLaneDir;
    private final File intensityLaneDir;
    private final File basecallDir;
    private final File barcodeDir;
    private final File intensityDir;
    private final int lane;
    private final File tileMetricsOut;
    private final Map<SupportedIlluminaFormat, ParameterizedFileUtil> utils = new HashMap<SupportedIlluminaFormat, ParameterizedFileUtil>();

    public IlluminaFileUtil(File file, int n) {
        this(file, null, n);
    }

    public IlluminaFileUtil(File file, File file2, int n) {
        this.lane = n;
        this.basecallDir = file;
        this.barcodeDir = file2;
        this.intensityDir = file.getParentFile();
        File file3 = this.intensityDir.getParentFile();
        this.basecallLaneDir = new File(file, IlluminaFileUtil.longLaneStr(n));
        this.intensityLaneDir = new File(this.intensityDir, IlluminaFileUtil.longLaneStr(n));
        File file4 = new File(file3.getParentFile(), "InterOp");
        this.tileMetricsOut = new File(file4, "TileMetricsOut.bin");
    }

    public int getLane() {
        return this.lane;
    }

    public ParameterizedFileUtil getUtil(SupportedIlluminaFormat supportedIlluminaFormat) {
        ParameterizedFileUtil parameterizedFileUtil = this.utils.get((Object)supportedIlluminaFormat);
        if (parameterizedFileUtil == null) {
            switch (supportedIlluminaFormat) {
                case Bcl: {
                    PerTilePerCycleFileUtil perTilePerCycleFileUtil = new PerTilePerCycleFileUtil(".bcl", this.basecallLaneDir, new BclFileFaker(), this.lane);
                    PerTilePerCycleFileUtil perTilePerCycleFileUtil2 = new PerTilePerCycleFileUtil(".bcl.gz", this.basecallLaneDir, new BclFileFaker(), this.lane);
                    if (((ParameterizedFileUtil)perTilePerCycleFileUtil).filesAvailable() && !((ParameterizedFileUtil)perTilePerCycleFileUtil2).filesAvailable()) {
                        parameterizedFileUtil = perTilePerCycleFileUtil;
                    } else if (!((ParameterizedFileUtil)perTilePerCycleFileUtil).filesAvailable() && ((ParameterizedFileUtil)perTilePerCycleFileUtil2).filesAvailable()) {
                        parameterizedFileUtil = perTilePerCycleFileUtil2;
                    } else if (!((ParameterizedFileUtil)perTilePerCycleFileUtil).filesAvailable() && !((ParameterizedFileUtil)perTilePerCycleFileUtil2).filesAvailable()) {
                        parameterizedFileUtil = perTilePerCycleFileUtil;
                    } else {
                        throw new PicardException("Not all BCL files in " + this.basecallLaneDir.getAbsolutePath() + " have the same extension!");
                    }
                    this.utils.put(SupportedIlluminaFormat.Bcl, parameterizedFileUtil);
                    break;
                }
                case Locs: {
                    parameterizedFileUtil = new PerTileFileUtil(".locs", this.intensityLaneDir, new LocsFileFaker(), this.lane);
                    this.utils.put(SupportedIlluminaFormat.Locs, parameterizedFileUtil);
                    break;
                }
                case Clocs: {
                    parameterizedFileUtil = new PerTileFileUtil(".clocs", this.intensityLaneDir, new ClocsFileFaker(), this.lane);
                    this.utils.put(SupportedIlluminaFormat.Clocs, parameterizedFileUtil);
                    break;
                }
                case Pos: {
                    parameterizedFileUtil = new PerTileFileUtil("_pos.txt", this.intensityDir, new PosFileFaker(), this.lane);
                    this.utils.put(SupportedIlluminaFormat.Pos, parameterizedFileUtil);
                    break;
                }
                case Filter: {
                    parameterizedFileUtil = new PerTileFileUtil(".filter", this.basecallLaneDir, new FilterFileFaker(), this.lane);
                    this.utils.put(SupportedIlluminaFormat.Filter, parameterizedFileUtil);
                    break;
                }
                case Barcode: {
                    parameterizedFileUtil = new PerTileFileUtil("_barcode.txt", this.barcodeDir != null ? this.barcodeDir : this.basecallDir, new BarcodeFileFaker(), this.lane, false);
                    this.utils.put(SupportedIlluminaFormat.Barcode, parameterizedFileUtil);
                    break;
                }
                case MultiTileFilter: {
                    parameterizedFileUtil = new MultiTileFilterFileUtil(this.basecallLaneDir, this.lane);
                    this.utils.put(SupportedIlluminaFormat.MultiTileFilter, parameterizedFileUtil);
                    break;
                }
                case MultiTileLocs: {
                    parameterizedFileUtil = new MultiTileLocsFileUtil(new File(this.intensityDir, this.basecallLaneDir.getName()), this.basecallLaneDir, this.lane);
                    this.utils.put(SupportedIlluminaFormat.MultiTileLocs, parameterizedFileUtil);
                    break;
                }
                case MultiTileBcl: {
                    parameterizedFileUtil = new MultiTileBclFileUtil(this.basecallLaneDir, this.lane);
                    this.utils.put(SupportedIlluminaFormat.MultiTileBcl, parameterizedFileUtil);
                }
            }
        }
        return parameterizedFileUtil;
    }

    public List<Integer> getExpectedTiles() {
        IOUtil.assertFileIsReadable((File)this.tileMetricsOut);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TileMetricsOutReader tileMetricsOutReader = new TileMetricsOutReader(this.tileMetricsOut);
        while (tileMetricsOutReader.hasNext()) {
            TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics = (TileMetricsOutReader.IlluminaTileMetrics)tileMetricsOutReader.next();
            if (illuminaTileMetrics.getLaneNumber() != this.lane || treeSet.contains(illuminaTileMetrics.getTileNumber())) continue;
            treeSet.add(illuminaTileMetrics.getTileNumber());
        }
        CloserUtil.close((Object)tileMetricsOutReader);
        return new ArrayList<Integer>(treeSet);
    }

    public List<Integer> getActualTiles(List<SupportedIlluminaFormat> list) {
        if (list == null) {
            throw new PicardException("Format list provided to getTiles was null!");
        }
        if (list.isEmpty()) {
            throw new PicardException("0 Formats were specified.  You need to specify at least SupportedIlluminaFormat to use getTiles");
        }
        List<Integer> list2 = this.getUtil(list.get(0)).getTiles();
        for (int i = 1; i < list.size(); ++i) {
            List<Integer> list3 = this.getUtil(list.get(i)).getTiles();
            if (list2.size() == list3.size() && list2.containsAll(list3)) continue;
            throw new PicardException("Formats do not have the same number of tiles! " + this.summarizeTileCounts(list));
        }
        return list2;
    }

    public File tileMetricsOut() {
        return this.tileMetricsOut;
    }

    public static String longLaneStr(int n) {
        String string = String.valueOf(n);
        int n2 = 3 - string.length();
        for (int i = 0; i < n2; ++i) {
            string = "0" + string;
        }
        return "L" + string;
    }

    private String liToStr(List<Integer> list) {
        if (list.isEmpty()) {
            return "";
        }
        String string = String.valueOf(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            string = string + ", " + String.valueOf(list.get(i));
        }
        return string;
    }

    private String summarizeTileCounts(List<SupportedIlluminaFormat> list) {
        ParameterizedFileUtil parameterizedFileUtil = this.getUtil(list.get(0));
        List<Integer> list2 = parameterizedFileUtil.getTiles();
        String string = parameterizedFileUtil.extension + "(" + this.liToStr(list2) + ")";
        for (SupportedIlluminaFormat supportedIlluminaFormat : list) {
            parameterizedFileUtil = this.getUtil(supportedIlluminaFormat);
            list2 = parameterizedFileUtil.getTiles();
            string = string + ", " + parameterizedFileUtil.extension + "(" + this.liToStr(list2) + ")";
        }
        return string;
    }

    public static enum SupportedIlluminaFormat {
        Bcl,
        Locs,
        Clocs,
        Pos,
        Filter,
        Barcode,
        MultiTileFilter,
        MultiTileLocs,
        MultiTileBcl;

    }
}

