/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.illumina.parser.IlluminaData;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.IlluminaParser;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.fakers.BciFileFaker;
import picard.illumina.parser.fakers.FileFaker;

public abstract class MultiTileFileUtil<OUTPUT_RECORD extends IlluminaData>
extends ParameterizedFileUtil {
    protected final File bci;
    protected TileIndex tileIndex;
    protected File dataFile;

    MultiTileFileUtil(String string, File file, File file2, FileFaker fileFaker, int n) {
        super(false, string, file, fileFaker, n);
        this.bci = new File(file2, "s_" + n + ".bci");
        this.tileIndex = this.bci.exists() ? new TileIndex(this.bci) : null;
        File[] fileArray = IOUtil.getFilesMatchingRegexp((File)file, (Pattern)this.matchPattern);
        if (fileArray == null || fileArray.length == 0) {
            this.dataFile = null;
        } else if (fileArray.length == 1) {
            this.dataFile = fileArray[0];
        } else {
            throw new PicardException("More than one filter file found in " + file.getAbsolutePath());
        }
    }

    @Override
    public boolean filesAvailable() {
        return this.tileIndex != null && this.dataFile != null && this.dataFile.exists();
    }

    @Override
    public List<Integer> getTiles() {
        if (this.tileIndex == null) {
            return Collections.emptyList();
        }
        return this.tileIndex.getTiles();
    }

    @Override
    public List<String> verify(List<Integer> list, int[] nArray) {
        if (this.tileIndex == null) {
            return Collections.singletonList("Tile index(" + this.bci.getAbsolutePath() + ") does not exist!");
        }
        return this.tileIndex.verify(list);
    }

    @Override
    public List<String> fakeFiles(List<Integer> list, int[] nArray, IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat) {
        block4: {
            BciFileFaker bciFileFaker = new BciFileFaker();
            try {
                bciFileFaker.fakeBciFile(this.bci, list);
                this.tileIndex = new TileIndex(this.bci);
                this.faker.fakeFile(this.base, list, this.lane, this.extension);
                File[] fileArray = IOUtil.getFilesMatchingRegexp((File)this.base, (Pattern)this.matchPattern);
                if (fileArray == null || fileArray.length == 0) {
                    this.dataFile = null;
                    break block4;
                }
                if (fileArray.length == 1) {
                    this.dataFile = fileArray[0];
                    break block4;
                }
                throw new PicardException("More than one filter file found in " + this.base.getAbsolutePath());
            }
            catch (IOException iOException) {
                return Collections.singletonList("Could not create tile index file: " + this.bci.getAbsolutePath());
            }
        }
        return this.tileIndex.verify(list);
    }

    abstract IlluminaParser<OUTPUT_RECORD> makeParser(List<Integer> var1);
}

