/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.PeekIterator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import picard.PicardException;
import picard.illumina.parser.IlluminaData;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaParser;
import picard.illumina.parser.TileIndex;

public abstract class MultiTileParser<OUTPUT_RECORD extends IlluminaData>
implements IlluminaParser<OUTPUT_RECORD> {
    private final TileIndex tileIndex;
    private final Iterator<TileIndex.TileIndexRecord> tileIndexIterator;
    private final PeekIterator<Integer> requestedTilesIterator;
    private final Set<IlluminaDataType> supportedTypes;
    private int nextRecordIndex = 0;
    private int nextClusterInTile;
    private TileIndex.TileIndexRecord currentTile = null;

    public MultiTileParser(TileIndex tileIndex, List<Integer> list, Set<IlluminaDataType> set) {
        this.tileIndex = tileIndex;
        this.tileIndexIterator = tileIndex.iterator();
        this.requestedTilesIterator = new PeekIterator(list.iterator());
        this.supportedTypes = set;
    }

    @Override
    public void seekToTile(int n) {
        while (this.tileIndexIterator.hasNext()) {
            TileIndex.TileIndexRecord tileIndexRecord = this.tileIndexIterator.next();
            if (tileIndexRecord.tile > n) {
                throw new PicardException(String.format("Cannot seek backwards: next tile %d > tile sought %d", tileIndexRecord.tile, n));
            }
            if (tileIndexRecord.tile != n) continue;
            this.currentTile = tileIndexRecord;
            break;
        }
        if (this.nextRecordIndex > this.currentTile.indexOfFirstClusterInTile) {
            throw new PicardException(String.format("Seem to be in wrong position %d > %d", this.nextRecordIndex, this.currentTile.indexOfFirstClusterInTile));
        }
        this.skipRecords(this.currentTile.indexOfFirstClusterInTile - this.nextRecordIndex);
        this.nextRecordIndex = this.currentTile.indexOfFirstClusterInTile;
        this.nextClusterInTile = 0;
    }

    @Override
    public OUTPUT_RECORD next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        OUTPUT_RECORD OUTPUT_RECORD = this.readNext();
        ++this.nextClusterInTile;
        ++this.nextRecordIndex;
        return OUTPUT_RECORD;
    }

    @Override
    public boolean hasNext() {
        while ((this.currentTile == null || this.nextClusterInTile >= this.currentTile.numClustersInTile) && this.requestedTilesIterator.hasNext()) {
            this.seekToTile((Integer)this.requestedTilesIterator.next());
        }
        return this.currentTile != null && this.nextClusterInTile < this.currentTile.numClustersInTile;
    }

    @Override
    public int getTileOfNextCluster() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentTile != null && this.nextClusterInTile < this.currentTile.numClustersInTile) {
            return this.currentTile.tile;
        }
        return (Integer)this.requestedTilesIterator.peek();
    }

    @Override
    public void verifyData(List<Integer> list, int[] nArray) {
        List<String> list2 = this.tileIndex.verify(list);
        if (!list2.isEmpty()) {
            throw new PicardException(list2.get(0));
        }
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return this.supportedTypes;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    abstract OUTPUT_RECORD readNext();

    abstract void skipRecords(int var1);
}

