/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import picard.PicardException;

public class Range {
    public final int start;
    public final int end;
    public final int length;

    public Range(int n, int n2) {
        if (n2 < n) {
            throw new PicardException("Nonsensical Range(" + n + ", " + n2 + ")");
        }
        this.start = n;
        this.end = n2;
        this.length = n2 - n + 1;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        return range.start == this.start && range.end == this.end;
    }

    public int hashCode() {
        return (int)Math.pow(this.start, this.end);
    }

    public String toString() {
        return "Range(" + this.start + ", " + this.end + ", " + this.length + ")";
    }
}

