/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.zip.GZIPInputStream;
import picard.PicardException;
import picard.illumina.parser.BclData;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.readers.BclIndexReader;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.UnsignedTypeUtil;

public class BclReader
implements CloseableIterator<BclData> {
    private static final byte BASE_MASK = 3;
    private static final int HEADER_SIZE = 4;
    private static final byte[] BASE_LOOKUP = new byte[]{65, 67, 71, 84};
    private final InputStream[] streams;
    private final File[] streamFiles;
    private final int[] outputLengths;
    int[] numClustersPerCycle;
    private final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    private BclData queue = null;

    public BclReader(List<File> list, int[] nArray, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean bl) {
        try {
            this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
            this.outputLengths = nArray;
            int n = 0;
            for (int n2 : nArray) {
                n += n2;
            }
            this.streams = new InputStream[n];
            this.streamFiles = new File[n];
            this.numClustersPerCycle = new int[n];
            Object object = ByteBuffer.allocate(4);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                File file = list.get(i);
                if (file == null) {
                    this.close();
                    throw new RuntimeIOException(String.format("Could not find BCL file for cycle %d", i));
                }
                String string = file.getName();
                boolean bl3 = string.endsWith(".gz");
                InputStream inputStream = this.open(file, bl, bl3, bl2 = string.endsWith(".bgzf"));
                int n3 = inputStream.read(((ByteBuffer)object).array());
                if (n3 != 4) {
                    this.close();
                    throw new RuntimeIOException(String.format("BCL %s has invalid header structure.", file.getAbsoluteFile()));
                }
                this.numClustersPerCycle[i] = ((ByteBuffer)object).getInt();
                if (!bl2 && !bl3) {
                    this.assertProperFileStructure(file, this.numClustersPerCycle[i], inputStream);
                }
                this.streams[i] = inputStream;
                this.streamFiles[i] = file;
                ((ByteBuffer)object).clear();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
    }

    public static boolean isGzipped(File file) {
        return file.getAbsolutePath().endsWith(".gz");
    }

    public static boolean isBlockGzipped(File file) {
        return file.getAbsolutePath().endsWith(".bgzf");
    }

    public static long getNumberOfClusters(File file) {
        long l;
        Object object = null;
        try {
            object = BclReader.isBlockGzipped(file) ? new BlockCompressedInputStream(IOUtil.maybeBufferedSeekableStream((File)file)) : (BclReader.isGzipped(file) ? new GZIPInputStream(IOUtil.maybeBufferInputStream((InputStream)new FileInputStream(file))) : IOUtil.maybeBufferInputStream((InputStream)new FileInputStream(file)));
            l = BclReader.getNumberOfClusters(file.getAbsolutePath(), (InputStream)object);
        }
        catch (IOException iOException) {
            try {
                throw new PicardException("Could not open file " + file.getAbsolutePath() + " to get its cluster count: " + iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                CloserUtil.close(object);
                throw throwable;
            }
        }
        CloserUtil.close((Object)object);
        return l;
    }

    private static long getNumberOfClusters(String string, InputStream inputStream) {
        byte[] byArray = new byte[4];
        try {
            int n = inputStream.read(byArray);
            if (n != 4) {
                throw new PicardException("Malformed file, expected header of size 4 but received " + n);
            }
        }
        catch (IOException iOException) {
            throw new PicardException("Unable to read header for file (" + string + ")", iOException);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return UnsignedTypeUtil.uIntToLong(byteBuffer.getInt());
    }

    public BclReader(File file, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean bl) {
        try {
            this.outputLengths = new int[]{1};
            this.streams = new InputStream[1];
            this.streamFiles = new File[1];
            this.numClustersPerCycle = new int[]{1};
            this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            String string = file.getName();
            boolean bl2 = string.endsWith(".gz");
            boolean bl3 = string.endsWith(".bgzf");
            InputStream inputStream = this.open(file, bl, bl2, bl3);
            int n = inputStream.read(byteBuffer.array());
            if (n != 4) {
                throw new RuntimeIOException(String.format("BCL %s has invalid header structure.", file.getAbsoluteFile()));
            }
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.numClustersPerCycle[0] = byteBuffer.getInt();
            if (!bl3 && !bl2) {
                this.assertProperFileStructure(file, this.numClustersPerCycle[0], inputStream);
            }
            this.streams[0] = inputStream;
            this.streamFiles[0] = file;
        }
        catch (IOException iOException) {
            throw new PicardException("IOException opening file " + file.getAbsoluteFile(), iOException);
        }
    }

    void assertProperFileStructure(File file, int n, InputStream inputStream) {
        long l = file.length() - 4L;
        if ((long)n != l) {
            CloserUtil.close((Object)inputStream);
            throw new PicardException("Expected " + n + " in file but found " + l);
        }
    }

    InputStream open(File file, boolean bl, boolean bl2, boolean bl3) throws IOException {
        String string = file.getAbsolutePath();
        try {
            if (bl3) {
                return new BlockCompressedInputStream(IOUtil.maybeBufferedSeekableStream((File)file));
            }
            if (bl2) {
                if (bl) {
                    throw new IllegalArgumentException(String.format("Cannot create a seekable reader for gzip bcl: %s.", string));
                }
                return IOUtil.maybeBufferInputStream((InputStream)new GZIPInputStream((InputStream)new FileInputStream(file), Defaults.BUFFER_SIZE / 2), (int)(Defaults.BUFFER_SIZE / 2));
            }
            if (bl) {
                throw new IllegalArgumentException(String.format("Cannot create a seekable reader for provided bcl: %s.", string));
            }
            return IOUtil.maybeBufferInputStream((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PicardException("File not found: (" + string + ")", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new PicardException("Error reading file: (" + string + ")", iOException);
        }
    }

    public void close() {
        for (InputStream inputStream : this.streams) {
            CloserUtil.close((Object)inputStream);
        }
    }

    public boolean hasNext() {
        if (this.queue == null) {
            this.advance();
        }
        return this.queue != null;
    }

    private long getNumClusters() {
        return this.numClustersPerCycle[0];
    }

    protected void assertProperFileStructure(File file) {
        long l = file.length() - 4L;
        if ((long)this.numClustersPerCycle[0] != l) {
            throw new PicardException("Expected " + this.numClustersPerCycle[0] + " in file " + file.getAbsolutePath() + " but found " + l);
        }
    }

    public BclData next() {
        if (this.queue == null) {
            this.advance();
        }
        BclData bclData = this.queue;
        this.queue = null;
        return bclData;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    void advance() {
        int n = 0;
        BclData bclData = new BclData(this.outputLengths);
        for (int i = 0; i < this.outputLengths.length; ++i) {
            for (int j = 0; j < this.outputLengths[i]; ++j) {
                try {
                    int n2;
                    try {
                        n2 = this.streams[n].read();
                    }
                    catch (IOException iOException) {
                        throw new IOException(String.format("Error while reading from BCL file for cycle %d. Offending file on disk is %s", n + 1, this.streamFiles[n].getAbsolutePath()), iOException);
                    }
                    if (n2 == -1) {
                        this.queue = null;
                        return;
                    }
                    if (n2 == 0) {
                        bclData.bases[i][j] = 46;
                        bclData.qualities[i][j] = 2;
                    } else {
                        bclData.bases[i][j] = BASE_LOOKUP[n2 & 3];
                        bclData.qualities[i][j] = this.bclQualityEvaluationStrategy.reviseAndConditionallyLogQuality((byte)(n2 >>> 2));
                    }
                    ++n;
                    continue;
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException((Throwable)iOException);
                }
            }
        }
        this.queue = bclData;
    }

    public static BclReader makeSeekable(List<File> list, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, int[] nArray) {
        return new BclReader(list, nArray, bclQualityEvaluationStrategy, true);
    }

    public int seek(List<File> list, TileIndex tileIndex, int n) {
        int n2 = 0;
        int n3 = 0;
        for (InputStream inputStream : this.streams) {
            TileIndex.TileIndexRecord tileIndexRecord = tileIndex.findTile(n);
            BclIndexReader bclIndexReader = new BclIndexReader(list.get(n2));
            long l = bclIndexReader.get(tileIndexRecord.getZeroBasedTileNumber());
            if (!(inputStream instanceof BlockCompressedInputStream)) {
                throw new UnsupportedOperationException("Seeking only allowed on bzgf");
            }
            try {
                if (tileIndex.getNumTiles() != bclIndexReader.getNumTiles()) {
                    throw new PicardException(String.format("%s.getNumTiles(%d) != %s.getNumTiles(%d)", tileIndex.getFile().getAbsolutePath(), tileIndex.getNumTiles(), bclIndexReader.getBciFile().getAbsolutePath(), bclIndexReader.getNumTiles()));
                }
                ((BlockCompressedInputStream)inputStream).seek(l);
                n3 = tileIndexRecord.getNumClustersInTile();
            }
            catch (IOException iOException) {
                throw new PicardException("Problem seeking to " + l, iOException);
            }
            ++n2;
        }
        return n3;
    }
}

