/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import picard.PicardException;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.illumina.parser.readers.BinaryFileIterator;
import picard.illumina.parser.readers.MMapBackedIteratorFactory;
import picard.util.UnsignedTypeUtil;

public class LocsFileReader
extends AbstractIlluminaPositionFileReader {
    private static final int HEADER_SIZE = 12;
    private static final int BYTES_1_TO_4 = 1;
    private static final float VERSION = 1.0f;
    private BinaryFileIterator<Float> bbIterator;
    private long numClusters;
    private int nextCluster;

    public LocsFileReader(File file) {
        super(file);
        this.initialize(file);
    }

    public LocsFileReader(File file, int n, int n2) {
        super(file, n, n2);
        this.initialize(file);
    }

    private void initialize(File file) {
        this.bbIterator = MMapBackedIteratorFactory.getFloatIterator(12, file);
        ByteBuffer byteBuffer = this.bbIterator.getHeaderBytes();
        int n = byteBuffer.getInt();
        if (n != 1) {
            throw new PicardException("First header byte of locs files should be 1 value found(" + n + ")");
        }
        float f = byteBuffer.getFloat();
        if (f != 1.0f) {
            throw new PicardException("First header byte of locs files should be 1.0 value found(" + n + ")");
        }
        this.numClusters = UnsignedTypeUtil.uIntToLong(byteBuffer.getInt());
        this.bbIterator.assertTotalElementsEqual(this.numClusters * 2L);
    }

    @Override
    protected AbstractIlluminaPositionFileReader.PositionInfo unsafeNextInfo() {
        float f = this.bbIterator.next().floatValue();
        float f2 = this.bbIterator.next().floatValue();
        ++this.nextCluster;
        return new AbstractIlluminaPositionFileReader.PositionInfo(this, f, f2, this.getLane(), this.getTile());
    }

    @Override
    protected String makeExceptionMsg() {
        return "LocsFileReader(file=" + this.getFile().getAbsolutePath() + ", numClusters=" + this.numClusters + ") ";
    }

    @Override
    public boolean hasNext() {
        return (long)this.nextCluster < this.numClusters;
    }

    public void close() {
        this.bbIterator = null;
    }

    public void skipRecords(int n) {
        this.bbIterator.skipElements(n * 2);
    }
}

