/*
 * Decompiled with CFR 0.152.
 */
package picard.metrics;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.metrics.PerUnitMetricCollector;

public abstract class MultiLevelCollector<METRIC_TYPE extends MetricBase, Histogram_KEY extends Comparable, ARGTYPE> {
    public static final String UNKNOWN = "unknown";
    private PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> allReadCollector;
    private List<Distributor> outputOrderedDistributors;

    protected abstract ARGTYPE makeArg(SAMRecord var1, ReferenceSequence var2);

    protected abstract PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeChildCollector(String var1, String var2, String var3);

    protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeAllReadCollector() {
        return this.makeChildCollector(null, null, null);
    }

    protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeSampleCollector(SAMReadGroupRecord sAMReadGroupRecord) {
        return this.makeChildCollector(sAMReadGroupRecord.getSample(), null, null);
    }

    protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeLibraryCollector(SAMReadGroupRecord sAMReadGroupRecord) {
        return this.makeChildCollector(sAMReadGroupRecord.getSample(), sAMReadGroupRecord.getLibrary(), null);
    }

    protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeReadGroupCollector(SAMReadGroupRecord sAMReadGroupRecord) {
        return this.makeChildCollector(sAMReadGroupRecord.getSample(), sAMReadGroupRecord.getLibrary(), sAMReadGroupRecord.getPlatformUnit());
    }

    protected void setup(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list) {
        this.outputOrderedDistributors = new ArrayList<Distributor>(4);
        if (set.contains((Object)MetricAccumulationLevel.ALL_READS)) {
            this.outputOrderedDistributors.add(new AllReadsDistributor(list));
        }
        if (set.contains((Object)MetricAccumulationLevel.SAMPLE)) {
            this.outputOrderedDistributors.add(new SampleDistributor(list));
        }
        if (set.contains((Object)MetricAccumulationLevel.LIBRARY)) {
            this.outputOrderedDistributors.add(new LibraryDistributor(list));
        }
        if (set.contains((Object)MetricAccumulationLevel.READ_GROUP)) {
            this.outputOrderedDistributors.add(new ReadGroupCollector(list));
        }
    }

    public void acceptRecord(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        ARGTYPE ARGTYPE = this.makeArg(sAMRecord, referenceSequence);
        for (Distributor distributor : this.outputOrderedDistributors) {
            distributor.acceptRecord(ARGTYPE, sAMRecord.getReadGroup());
        }
    }

    public void finish() {
        for (Distributor distributor : this.outputOrderedDistributors) {
            distributor.finish();
        }
    }

    public PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> getAllReadsCollector() {
        return this.allReadCollector;
    }

    public void addAllLevelsToFile(MetricsFile<METRIC_TYPE, Histogram_KEY> metricsFile) {
        for (Distributor distributor : this.outputOrderedDistributors) {
            distributor.addToFile(metricsFile);
        }
    }

    private class ReadGroupCollector
    extends Distributor {
        public ReadGroupCollector(List<SAMReadGroupRecord> list) {
            super(list);
        }

        @Override
        protected String getKey(SAMReadGroupRecord sAMReadGroupRecord) {
            return sAMReadGroupRecord.getPlatformUnit();
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord sAMReadGroupRecord) {
            return MultiLevelCollector.this.makeReadGroupCollector(sAMReadGroupRecord);
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeUnknownCollector() {
            return MultiLevelCollector.this.makeChildCollector(MultiLevelCollector.UNKNOWN, MultiLevelCollector.UNKNOWN, MultiLevelCollector.UNKNOWN);
        }
    }

    private class LibraryDistributor
    extends Distributor {
        public LibraryDistributor(List<SAMReadGroupRecord> list) {
            super(list);
        }

        @Override
        protected String getKey(SAMReadGroupRecord sAMReadGroupRecord) {
            return sAMReadGroupRecord.getLibrary();
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord sAMReadGroupRecord) {
            return MultiLevelCollector.this.makeLibraryCollector(sAMReadGroupRecord);
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeUnknownCollector() {
            return MultiLevelCollector.this.makeChildCollector(MultiLevelCollector.UNKNOWN, MultiLevelCollector.UNKNOWN, null);
        }
    }

    private class SampleDistributor
    extends Distributor {
        public SampleDistributor(List<SAMReadGroupRecord> list) {
            super(list);
        }

        @Override
        protected String getKey(SAMReadGroupRecord sAMReadGroupRecord) {
            return sAMReadGroupRecord.getSample();
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord sAMReadGroupRecord) {
            return MultiLevelCollector.this.makeSampleCollector(sAMReadGroupRecord);
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeUnknownCollector() {
            return MultiLevelCollector.this.makeChildCollector(MultiLevelCollector.UNKNOWN, null, null);
        }
    }

    private class AllReadsDistributor
    extends Distributor {
        public AllReadsDistributor(List<SAMReadGroupRecord> list) {
            super(new ArrayList<SAMReadGroupRecord>());
            this.makeCollector(null);
        }

        @Override
        protected String getKey(SAMReadGroupRecord sAMReadGroupRecord) {
            return null;
        }

        @Override
        public void acceptRecord(ARGTYPE ARGTYPE, SAMReadGroupRecord sAMReadGroupRecord) {
            MultiLevelCollector.this.allReadCollector.acceptRecord(ARGTYPE);
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord sAMReadGroupRecord) {
            MultiLevelCollector.this.allReadCollector = MultiLevelCollector.this.makeAllReadCollector();
            return MultiLevelCollector.this.allReadCollector;
        }

        @Override
        protected PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeUnknownCollector() {
            throw new UnsupportedOperationException("Should not happen");
        }

        @Override
        public void finish() {
            MultiLevelCollector.this.allReadCollector.finish();
        }

        @Override
        public void addToFile(MetricsFile<METRIC_TYPE, Histogram_KEY> metricsFile) {
            MultiLevelCollector.this.allReadCollector.addMetricsToFile(metricsFile);
        }
    }

    private abstract class Distributor {
        private final Map<String, PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE>> collectors = new LinkedHashMap();

        protected abstract String getKey(SAMReadGroupRecord var1);

        protected abstract PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeCollector(SAMReadGroupRecord var1);

        protected abstract PerUnitMetricCollector<METRIC_TYPE, Histogram_KEY, ARGTYPE> makeUnknownCollector();

        public Distributor(List<SAMReadGroupRecord> list) {
            for (SAMReadGroupRecord sAMReadGroupRecord : list) {
                String string = this.getKey(sAMReadGroupRecord);
                if (this.collectors.containsKey(string)) continue;
                this.collectors.put(string, this.makeCollector(sAMReadGroupRecord));
            }
        }

        public void finish() {
            for (PerUnitMetricCollector perUnitMetricCollector : this.collectors.values()) {
                perUnitMetricCollector.finish();
            }
        }

        public void acceptRecord(ARGTYPE ARGTYPE, SAMReadGroupRecord sAMReadGroupRecord) {
            PerUnitMetricCollector perUnitMetricCollector;
            Object object = MultiLevelCollector.UNKNOWN;
            if (sAMReadGroupRecord != null && (perUnitMetricCollector = this.getKey(sAMReadGroupRecord)) != null) {
                object = perUnitMetricCollector;
            }
            if ((perUnitMetricCollector = this.collectors.get(object)) == null) {
                if (!MultiLevelCollector.UNKNOWN.equals(object)) {
                    throw new PicardException("Could not find collector for " + (String)object);
                }
                perUnitMetricCollector = this.makeUnknownCollector();
                this.collectors.put((String)object, perUnitMetricCollector);
            }
            perUnitMetricCollector.acceptRecord(ARGTYPE);
        }

        public void addToFile(MetricsFile<METRIC_TYPE, Histogram_KEY> metricsFile) {
            for (PerUnitMetricCollector perUnitMetricCollector : this.collectors.values()) {
                perUnitMetricCollector.addMetricsToFile(metricsFile);
            }
        }
    }
}

