/*
 * Decompiled with CFR 0.152.
 */
package picard.pedigree;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import picard.pedigree.Sex;

public class PedFile
extends TreeMap<String, PedTrio> {
    private static final Log log = Log.getInstance(PedFile.class);
    static final Pattern WHITESPACE = Pattern.compile("\\s+");
    static final Pattern TAB = Pattern.compile("\\t");
    private final Pattern delimiterPattern;
    private final String delimiterString;
    public static final Number NO_PHENO = new Integer(-9);
    public static final Sex UNKNOWN_SEX = Sex.Unknown;

    public PedFile(boolean bl) {
        this.delimiterPattern = bl ? TAB : WHITESPACE;
        this.delimiterString = bl ? "tabs" : "whitespace";
    }

    public void add(PedTrio pedTrio) {
        this.put(pedTrio.getIndividualId(), pedTrio);
    }

    public void write(File file) {
        IOUtil.assertFileIsWritable((File)file);
        BufferedWriter bufferedWriter = IOUtil.openFileForBufferedWriting((File)file);
        try {
            for (PedTrio pedTrio : this.values()) {
                bufferedWriter.write(pedTrio.getFamilyId());
                bufferedWriter.write("\t");
                bufferedWriter.write(pedTrio.getIndividualId());
                bufferedWriter.write("\t");
                bufferedWriter.write(pedTrio.getPaternalId());
                bufferedWriter.write("\t");
                bufferedWriter.write(pedTrio.getMaternalId());
                bufferedWriter.write("\t");
                bufferedWriter.write(String.valueOf(pedTrio.getSex().toCode()));
                bufferedWriter.write("\t");
                bufferedWriter.write(pedTrio.getPhenotype().toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("IOException while writing to file " + file.getAbsolutePath(), (Throwable)iOException);
        }
    }

    public static PedFile fromFile(File file, boolean bl) {
        PedFile pedFile = new PedFile(bl);
        IOUtil.assertFileIsReadable((File)file);
        for (String string : IOUtil.readLines((File)file)) {
            String[] stringArray = pedFile.delimiterPattern.split(string);
            if (stringArray.length != 6) {
                log.error(new Object[]{"Ped file line contained invalid number of fields, skipping: " + string});
                continue;
            }
            PedFile pedFile2 = pedFile;
            pedFile2.getClass();
            PedTrio pedTrio = pedFile2.new PedTrio(stringArray[0], stringArray[1], stringArray[2], stringArray[3], Sex.fromCode(Integer.parseInt(stringArray[4])), stringArray[5].contains(".") ? Double.parseDouble(stringArray[5]) : (double)Integer.parseInt(stringArray[5]));
            pedFile.add(pedTrio);
        }
        return pedFile;
    }

    public PedFile removeIncompleteTrios() {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            if (((PedTrio)iterator.next().getValue()).hasBothParents()) continue;
            iterator.remove();
        }
        return this;
    }

    public static PedFile fromSexMap(Map<String, Sex> map) {
        PedFile pedFile = new PedFile(true);
        for (Map.Entry<String, Sex> entry : map.entrySet()) {
            PedFile pedFile2 = pedFile;
            pedFile2.getClass();
            PedTrio pedTrio = pedFile2.new PedTrio(entry.getKey(), entry.getKey(), ".", ".", entry.getValue(), NO_PHENO);
            pedFile.add(pedTrio);
        }
        return pedFile;
    }

    public class PedTrio {
        private final String familyId;
        private final String individualId;
        private final String paternalId;
        private final String maternalId;
        private final Sex sex;
        private final Number phenotype;

        public PedTrio(String string, String string2, String string3, String string4, Sex sex, Number number) {
            if (PedFile.this.delimiterPattern.split(string).length != 1) {
                throw new IllegalArgumentException("FamilyID     cannot contain " + PedFile.this.delimiterString + ": [" + string + "]");
            }
            if (PedFile.this.delimiterPattern.split(string2).length != 1) {
                throw new IllegalArgumentException("IndividualID cannot contain " + PedFile.this.delimiterString + ": [" + string2 + "]");
            }
            if (PedFile.this.delimiterPattern.split(string3).length != 1) {
                throw new IllegalArgumentException("PaternalID   cannot contain " + PedFile.this.delimiterString + ": [" + string3 + "]");
            }
            if (PedFile.this.delimiterPattern.split(string4).length != 1) {
                throw new IllegalArgumentException("MaternalID   cannot contain " + PedFile.this.delimiterString + ": [" + string4 + "]");
            }
            this.familyId = string;
            this.individualId = string2;
            this.paternalId = string3;
            this.maternalId = string4;
            this.sex = sex;
            this.phenotype = number;
        }

        public boolean hasBothParents() {
            return this.paternalId != null && this.maternalId != null;
        }

        public String getFamilyId() {
            return this.familyId;
        }

        public String getIndividualId() {
            return this.individualId;
        }

        public String getPaternalId() {
            return this.paternalId;
        }

        public String getMaternalId() {
            return this.maternalId;
        }

        public Sex getSex() {
            return this.sex;
        }

        public Number getPhenotype() {
            return this.phenotype;
        }
    }
}

