/*
 * Decompiled with CFR 0.152.
 */
package picard.reference;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.IntervalListReferenceSequenceMask;
import htsjdk.samtools.util.StringUtil;
import htsjdk.samtools.util.WholeGenomeReferenceSequenceMask;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Fasta;

@CommandLineProgramProperties(usage="Counts the number of non-N bases in a fasta file.This tool takes any FASTA-formatted file and counts the number of non-N bases in it.Note that it requires that the fasta file have associated index (.fai) and dictionary (.dict) files.<br /><h4>Usage example:</h4><pre>java -jar picard.jar NonNFastaSize \\<br />      I=input_sequence.fasta \\<br />      O=count.txt</pre><hr />", usageShort="Counts the number of non-N bases in a fasta file.", programGroup=Fasta.class)
public class NonNFastaSize
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Counts the number of non-N bases in a fasta file.";
    static final String USAGE_DETAILS = "This tool takes any FASTA-formatted file and counts the number of non-N bases in it.Note that it requires that the fasta file have associated index (.fai) and dictionary (.dict) files.<br /><h4>Usage example:</h4><pre>java -jar picard.jar NonNFastaSize \\<br />      I=input_sequence.fasta \\<br />      O=count.txt</pre><hr />";
    @Option(shortName="I", doc="The input FASTA file.")
    public File INPUT;
    @Option(shortName="O", doc="The output file in which to record the count.")
    public File OUTPUT;
    @Option(shortName="INTERVALS", doc="An interval list file that contains the locations of the positions to assess.  If not provided, the entire reference will be used", optional=true)
    public File INTERVALS = null;

    public static void main(String[] stringArray) {
        new NonNFastaSize().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IntervalListReferenceSequenceMask intervalListReferenceSequenceMask;
        SAMFileHeader sAMFileHeader;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.INPUT);
        if (this.INTERVALS != null) {
            IOUtil.assertFileIsReadable((File)this.INTERVALS);
            sAMFileHeader = IntervalList.fromFile((File)this.INTERVALS);
            intervalListReferenceSequenceMask = new IntervalListReferenceSequenceMask((IntervalList)sAMFileHeader);
        } else {
            sAMFileHeader = new SAMFileHeader();
            sAMFileHeader.setSequenceDictionary(referenceSequenceFile.getSequenceDictionary());
            intervalListReferenceSequenceMask = new WholeGenomeReferenceSequenceMask(sAMFileHeader);
        }
        long l = 0L;
        for (SAMSequenceRecord sAMSequenceRecord : referenceSequenceFile.getSequenceDictionary().getSequences()) {
            ReferenceSequence referenceSequence = referenceSequenceFile.getSequence(sAMSequenceRecord.getSequenceName());
            byte[] byArray = referenceSequence.getBases();
            StringUtil.toUpperCase((byte[])byArray);
            for (int i = 0; i < byArray.length; ++i) {
                if (!intervalListReferenceSequenceMask.get(referenceSequence.getContigIndex(), i + 1)) continue;
                l += byArray[i] == 78 ? 0L : 1L;
            }
        }
        try {
            BufferedWriter bufferedWriter = IOUtil.openFileForBufferedWriting((File)this.OUTPUT);
            bufferedWriter.write(l + "\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), iOException);
        }
        return 0;
    }
}

