/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Iso8601Date;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Replace read groups in a BAM file.This tool enables the user to replace all read groups in the INPUT file with a single new read group and assign all reads to this read group in the OUTPUT BAM file.<br /><br />For more information about read groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a> <br /><br /> This tool accepts INPUT BAM and SAM files or URLs from the Global Alliance for Genomics and Health (GA4GH) (see http://ga4gh.org/#/documentation).<h4>Usage example:</h4><pre>java -jar picard.jar AddOrReplaceReadGroups \\<br />      I=input.bam \\<br />      O=output.bam \\<br />      RGID=4 \\<br />      RGLB=lib1 \\<br />      RGPL=illumina \\<br />      RGPU=unit1 \\<br />      RGSM=20</pre><hr />", usageShort="Replace read groups in a BAM file.", programGroup=SamOrBam.class)
public class AddOrReplaceReadGroups
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Replace read groups in a BAM file.";
    static final String USAGE_DETAILS = "This tool enables the user to replace all read groups in the INPUT file with a single new read group and assign all reads to this read group in the OUTPUT BAM file.<br /><br />For more information about read groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a> <br /><br /> This tool accepts INPUT BAM and SAM files or URLs from the Global Alliance for Genomics and Health (GA4GH) (see http://ga4gh.org/#/documentation).<h4>Usage example:</h4><pre>java -jar picard.jar AddOrReplaceReadGroups \\<br />      I=input.bam \\<br />      O=output.bam \\<br />      RGID=4 \\<br />      RGLB=lib1 \\<br />      RGPL=illumina \\<br />      RGPU=unit1 \\<br />      RGSM=20</pre><hr />";
    @Option(shortName="I", doc="Input file (BAM or SAM or a GA4GH url).")
    public String INPUT = null;
    @Option(shortName="O", doc="Output file (BAM or SAM).")
    public File OUTPUT = null;
    @Option(shortName="SO", optional=true, doc="Optional sort order to output in. If not supplied OUTPUT is in the same order as INPUT.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Option(shortName="ID", doc="Read Group ID")
    public String RGID = "1";
    @Option(shortName="LB", doc="Read Group library")
    public String RGLB;
    @Option(shortName="PL", doc="Read Group platform (e.g. illumina, solid)")
    public String RGPL;
    @Option(shortName="PU", doc="Read Group platform unit (eg. run barcode)")
    public String RGPU;
    @Option(shortName="SM", doc="Read Group sample name")
    public String RGSM;
    @Option(shortName="CN", doc="Read Group sequencing center name", optional=true)
    public String RGCN;
    @Option(shortName="DS", doc="Read Group description", optional=true)
    public String RGDS;
    @Option(shortName="DT", doc="Read Group run date", optional=true)
    public Iso8601Date RGDT;
    @Option(shortName="PI", doc="Read Group predicted insert size", optional=true)
    public Integer RGPI;
    @Option(shortName="PG", doc="Read Group program group", optional=true)
    public String RGPG;
    @Option(shortName="PM", doc="Read Group platform model", optional=true)
    public String RGPM;
    private final Log log = Log.getInstance(AddOrReplaceReadGroups.class);

    public static void main(String[] stringArray) {
        new AddOrReplaceReadGroups().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertInputIsValid((String)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(SamInputResource.of((String)this.INPUT));
        SAMReadGroupRecord sAMReadGroupRecord = new SAMReadGroupRecord(this.RGID);
        sAMReadGroupRecord.setLibrary(this.RGLB);
        sAMReadGroupRecord.setPlatform(this.RGPL);
        sAMReadGroupRecord.setSample(this.RGSM);
        sAMReadGroupRecord.setPlatformUnit(this.RGPU);
        if (this.RGCN != null) {
            sAMReadGroupRecord.setSequencingCenter(this.RGCN);
        }
        if (this.RGDS != null) {
            sAMReadGroupRecord.setDescription(this.RGDS);
        }
        if (this.RGDT != null) {
            sAMReadGroupRecord.setRunDate((Date)this.RGDT);
        }
        if (this.RGPI != null) {
            sAMReadGroupRecord.setPredictedMedianInsertSize(this.RGPI);
        }
        if (this.RGPG != null) {
            sAMReadGroupRecord.setProgramGroup(this.RGPG);
        }
        if (this.RGPM != null) {
            sAMReadGroupRecord.setPlatformModel(this.RGPM);
        }
        this.log.info(new Object[]{String.format("Created read group ID=%s PL=%s LB=%s SM=%s%n", sAMReadGroupRecord.getId(), sAMReadGroupRecord.getPlatform(), sAMReadGroupRecord.getLibrary(), sAMReadGroupRecord.getSample())});
        SAMFileHeader sAMFileHeader = samReader.getFileHeader();
        SAMFileHeader sAMFileHeader2 = sAMFileHeader.clone();
        sAMFileHeader2.setReadGroups(Arrays.asList(sAMReadGroupRecord));
        if (this.SORT_ORDER != null) {
            sAMFileHeader2.setSortOrder(this.SORT_ORDER);
        }
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader2, sAMFileHeader2.getSortOrder() == sAMFileHeader.getSortOrder(), this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(this.log);
        for (SAMRecord sAMRecord : samReader) {
            sAMRecord.setAttribute(SAMTag.RG.name(), (Object)this.RGID);
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        CloserUtil.close((Object)samReader);
        sAMFileWriter.close();
        return 0;
    }
}

