/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Generates a BAM index \".bai\" file.  This tool creates an index file for the input BAM that allows fast look-up of data in a BAM file, lke an index on a database. Note that this tool cannot be run on SAM files, and that the input BAM file must be sorted in coordinate order.<h4>Usage example:</h4><pre>java -jar picard.jar BuildBamIndex \\<br />      I=input.bam</pre><hr />", usageShort="Generates a BAM index \".bai\" file.  ", programGroup=SamOrBam.class)
public class BuildBamIndex
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Generates a BAM index \".bai\" file.  ";
    static final String USAGE_DETAILS = "This tool creates an index file for the input BAM that allows fast look-up of data in a BAM file, lke an index on a database. Note that this tool cannot be run on SAM files, and that the input BAM file must be sorted in coordinate order.<h4>Usage example:</h4><pre>java -jar picard.jar BuildBamIndex \\<br />      I=input.bam</pre><hr />";
    private static final Log log = Log.getInstance(BuildBamIndex.class);
    @Option(shortName="I", doc="A BAM file or GA4GH URL to process. Must be sorted in coordinate order.")
    public String INPUT;
    URL inputUrl = null;
    File inputFile = null;
    @Option(shortName="O", doc="The BAM index file. Defaults to x.bai if INPUT is x.bam, otherwise INPUT.bai.\nIf INPUT is a URL and OUTPUT is unspecified, defaults to a file in the current directory.", optional=true)
    public File OUTPUT;

    public static void main(String[] stringArray) {
        System.exit(new BuildBamIndex().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        String string;
        try {
            this.inputUrl = new URL(this.INPUT);
        }
        catch (MalformedURLException malformedURLException) {
            this.inputFile = new File(this.INPUT);
        }
        if (this.OUTPUT == null) {
            if (this.inputUrl != null) {
                String string2 = this.inputUrl.getPath();
                int n = string2.lastIndexOf("/");
                string = string2.substring(n + 1, string2.length());
            } else {
                string = this.inputFile.getAbsolutePath();
            }
            if (string.endsWith(".bam")) {
                int n = string.lastIndexOf(".");
                this.OUTPUT = new File(string.substring(0, n) + ".bai");
            } else {
                this.OUTPUT = new File(string + ".bai");
            }
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.inputUrl != null) {
            string = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).disable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE}).enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS}).open(SamInputResource.of((URL)this.inputUrl));
        } else {
            IOUtil.assertFileIsReadable((File)this.inputFile);
            string = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS}).open(this.inputFile);
        }
        if (string.type() != SamReader.Type.BAM_TYPE) {
            throw new SAMException("Input file must be bam file, not sam file.");
        }
        if (!string.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Input bam file must be sorted by coordinate");
        }
        BAMIndexer.createIndex((SamReader)string, (File)this.OUTPUT);
        log.info(new Object[]{"Successfully wrote bam index file " + this.OUTPUT});
        CloserUtil.close((Object)string);
        return 0;
    }
}

