/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Creates a hash code based on the read groups (RG).  This tool creates a hash code based on identifying information in the read groups (RG) of a \".BAM\" or \"SAM\" file header.  Addition or removal of RGs changes the hash code, enabling the user to quickly determine if changes have been made to the read group information. <br /><h4>Usage example:</h4><pre>java -jar picard.jar CalculateReadGroupChecksum \\<br />      I=input.bam</pre>Please see the AddOrReplaceReadGroups tool documentation for information regarding the addition, subtraction, or merging of read groups.<hr />", usageShort="Creates a hash code based on the read groups (RG).  ", programGroup=SamOrBam.class)
public class CalculateReadGroupChecksum
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Creates a hash code based on the read groups (RG).  ";
    static final String USAGE_DETAILS = "This tool creates a hash code based on identifying information in the read groups (RG) of a \".BAM\" or \"SAM\" file header.  Addition or removal of RGs changes the hash code, enabling the user to quickly determine if changes have been made to the read group information. <br /><h4>Usage example:</h4><pre>java -jar picard.jar CalculateReadGroupChecksum \\<br />      I=input.bam</pre>Please see the AddOrReplaceReadGroups tool documentation for information regarding the addition, subtraction, or merging of read groups.<hr />";
    private static final String OUTPUT_FILE_EXTENSION = ".read_group_md5";
    @Option(shortName="I", doc="The input SAM or BAM file. ")
    public File INPUT;
    @Option(shortName="O", doc="The file to which the hash code should be written.", optional=true)
    public File OUTPUT;

    public static void main(String[] stringArray) {
        new CalculateReadGroupChecksum().instanceMainWithExit(stringArray);
    }

    public static String getOutputFileName(File file) {
        return file.getName() + OUTPUT_FILE_EXTENSION;
    }

    @Override
    protected int doWork() {
        File file = this.OUTPUT == null ? new File(this.INPUT.getParentFile(), CalculateReadGroupChecksum.getOutputFileName(this.INPUT)) : this.OUTPUT;
        IOUtil.assertFileIsWritable((File)file);
        String string = SAMUtils.calculateReadGroupRecordChecksum((File)this.INPUT, (File)this.REFERENCE_SEQUENCE);
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new PicardException("Could not write the computed hash (" + string + ") to the output file: " + iOException.getMessage(), iOException);
        }
        return 0;
    }
}

