/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Verify mate-pair information between mates and fix if needed.This tool ensures that all mate-pair information is in sync between each read and its mate pair.  If no OUTPUT file is supplied then the output is written to a temporary file and then copied over the INPUT file.  Reads marked with the secondary alignment flag are written to the output file unchanged.<h4>Usage example:</h4><pre>java -jar picard.jar FixMateInformation \\<br />       I=input.bam \\ <br />       O=fixed_mate.bam</pre> <hr />", usageShort="Verify mate-pair information between mates and fix if needed.", programGroup=SamOrBam.class)
public class FixMateInformation
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Verify mate-pair information between mates and fix if needed.";
    static final String USAGE_DETAILS = "This tool ensures that all mate-pair information is in sync between each read and its mate pair.  If no OUTPUT file is supplied then the output is written to a temporary file and then copied over the INPUT file.  Reads marked with the secondary alignment flag are written to the output file unchanged.<h4>Usage example:</h4><pre>java -jar picard.jar FixMateInformation \\<br />       I=input.bam \\ <br />       O=fixed_mate.bam</pre> <hr />";
    @Option(shortName="I", doc="The input file to check and fix.")
    public List<File> INPUT;
    @Option(shortName="O", optional=true, doc="The output file to write to. If no output file is supplied, the input file is overwritten.")
    public File OUTPUT;
    @Option(shortName="SO", optional=true, doc="Optional sort order if the OUTPUT file should be sorted differently than the INPUT file.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Option(doc="If true, assume that the input file is queryname sorted, even if the header says otherwise.", shortName="AS")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="MC", optional=true, doc="Adds the mate CIGAR tag (MC) if true, does not if false.")
    public Boolean ADD_MATE_CIGAR = true;
    @Option(doc="If true, ignore missing mates, otherwise will throw an exception when missing mates are found.", optional=true)
    public Boolean IGNORE_MISSING_MATES = true;
    private static final Log log = Log.getInstance(FixMateInformation.class);
    protected SAMFileWriter out;

    public static void main(String[] stringArray) {
        new FixMateInformation().instanceMainWithExit(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doWork() {
        SAMRecordIterator sAMRecordIterator;
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        File file2;
        boolean bl2 = true;
        ArrayList<SamReader> arrayList = new ArrayList<SamReader>();
        for (File file2 : this.INPUT) {
            IOUtil.assertFileIsReadable((File)file2);
            object3 = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(file2);
            arrayList.add((SamReader)object3);
            if (object3.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.queryname) continue;
            bl2 = false;
        }
        if (this.OUTPUT != null) {
            this.OUTPUT = this.OUTPUT.getAbsoluteFile();
        }
        boolean bl3 = bl = this.OUTPUT != null;
        if (bl) {
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
        } else {
            if (this.INPUT.size() != 1) {
                throw new PicardException("Must specify either an explicit OUTPUT file or a single INPUT file to be overridden.");
            }
            file2 = this.INPUT.get(0).getAbsoluteFile();
            object3 = file2.getParentFile().getAbsoluteFile();
            try {
                IOUtil.assertFileIsWritable((File)file2);
                IOUtil.assertDirectoryIsWritable((File)object3);
                this.OUTPUT = File.createTempFile(file2.getName() + ".being_fixed.", ".bam", (File)object3);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Could not create tmp file in " + ((File)object3).getAbsolutePath());
            }
        }
        if (this.INPUT.size() > 1) {
            object2 = new ArrayList(arrayList.size());
            for (SamReader samReader : arrayList) {
                object2.add(samReader.getFileHeader());
            }
            object = bl2 ? SAMFileHeader.SortOrder.queryname : SAMFileHeader.SortOrder.unsorted;
            SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger((SAMFileHeader.SortOrder)object, object2, false);
            sAMRecordIterator = new MergingSamRecordIterator(samFileHeaderMerger, arrayList, false);
            object3 = samFileHeaderMerger.getMergedHeader();
        } else {
            sAMRecordIterator = ((SamReader)arrayList.get(0)).iterator();
            object3 = ((SamReader)arrayList.get(0)).getFileHeader();
        }
        if (this.ASSUME_SORTED || bl2) {
            file2 = new SamPairUtil.SetMateInfoIterator((Iterator)new PeekableIterator((Iterator)sAMRecordIterator), this.ADD_MATE_CIGAR.booleanValue(), this.IGNORE_MISSING_MATES.booleanValue());
        } else {
            log.info(new Object[]{"Sorting input into queryname order."});
            object2 = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec((SAMFileHeader)object3), (Comparator)new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM, (Collection)this.TMP_DIR);
            while (sAMRecordIterator.hasNext()) {
                object2.add(sAMRecordIterator.next());
            }
            file2 = new SamPairUtil.SetMateInfoIterator((Iterator)new PeekableIterator<SAMRecord>((Iterator)object2.iterator(), (SortingCollection)object2){
                final /* synthetic */ SortingCollection val$sorter;
                {
                    this.val$sorter = sortingCollection;
                    super(iterator);
                }

                public void close() {
                    super.close();
                    this.val$sorter.cleanup();
                }
            }, this.ADD_MATE_CIGAR.booleanValue(), this.IGNORE_MISSING_MATES.booleanValue());
            log.info(new Object[]{"Sorting by queryname complete."});
        }
        object2 = this.SORT_ORDER == null ? ((SamReader)arrayList.get(0)).getFileHeader().getSortOrder() : this.SORT_ORDER;
        log.info(new Object[]{"Output will be sorted by " + object2});
        object3.setSortOrder((SAMFileHeader.SortOrder)object2);
        if (this.CREATE_INDEX.booleanValue() && object3.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
        }
        this.createSamFileWriter((SAMFileHeader)object3);
        log.info(new Object[]{"Traversing query name sorted records and fixing up mate pair information."});
        sAMRecordIterator = new ProgressLogger(log);
        while (file2.hasNext()) {
            object2 = (SAMRecord)file2.next();
            this.out.addAlignment((SAMRecord)object2);
            sAMRecordIterator.record((SAMRecord)object2);
        }
        file2.close();
        if (object3.getSortOrder() == SAMFileHeader.SortOrder.queryname) {
            log.info(new Object[]{"Closing output file."});
        } else {
            log.info(new Object[]{"Finished processing reads; re-sorting output file."});
        }
        this.closeWriter();
        if (!bl) {
            log.info(new Object[]{"Replacing input file with fixed file."});
            object2 = this.INPUT.get(0).getAbsoluteFile();
            object = new File(((File)object2).getParentFile(), ((File)object2).getName() + ".old");
            if (!((File)object).exists() && ((File)object2).renameTo((File)object)) {
                File file3;
                File file4;
                if (!this.OUTPUT.renameTo((File)object2)) {
                    log.error(new Object[]{"Could not move new file to " + ((File)object2).getAbsolutePath()});
                    log.error(new Object[]{"Input file preserved as: " + ((File)object).getAbsolutePath()});
                    log.error(new Object[]{"New file preserved as: " + this.OUTPUT.getAbsolutePath()});
                    return 1;
                }
                if (!((File)object).delete()) {
                    log.warn(new Object[]{"Could not delete old file: " + ((File)object).getAbsolutePath()});
                    return 1;
                }
                if (this.CREATE_INDEX.booleanValue() && !(file4 = new File(this.OUTPUT.getParent(), this.OUTPUT.getName().substring(0, this.OUTPUT.getName().length() - 4) + ".bai")).renameTo(file3 = new File(((File)object2).getParent(), ((File)object2).getName().substring(0, ((File)object2).getName().length() - 4) + ".bai"))) {
                    log.warn(new Object[]{"Could not overwrite index file: " + file3.getAbsolutePath()});
                }
            } else {
                log.error(new Object[]{"Could not move input file out of the way: " + ((File)object2).getAbsolutePath()});
                if (!this.OUTPUT.delete()) {
                    log.error(new Object[]{"Could not delete temporary file: " + this.OUTPUT.getAbsolutePath()});
                }
                return 1;
            }
        }
        CloserUtil.close(arrayList);
        return 0;
    }

    protected void createSamFileWriter(SAMFileHeader sAMFileHeader) {
        this.out = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, sAMFileHeader.getSortOrder() == SAMFileHeader.SortOrder.queryname, this.OUTPUT);
    }

    protected void writeAlignment(SAMRecord sAMRecord) {
        this.out.addAlignment(sAMRecord);
    }

    protected void closeWriter() {
        this.out.close();
    }
}

