/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Concatenate one or more BAM files as efficiently as possibleThis tool performs a rapid \"gather\" operation on BAM files after scatter operations where the same process has been performed on different regions of a BAM file creating many smaller BAM files that now need to be concatenated (reassembled) back together.<br /><br />Assumes that the list of BAM files provided as INPUT are in the order that they should be concatenated and simply concatenates the bodies of the BAM files while retaining the header from the first file.  Operates via copying of the gzip blocks directly for speed but also supports generation of an MD5 on the output and indexing of the output BAM file. Only supports BAM files, does not support SAM files.<h4>Usage example:</h4><pre>java -jar picard.jar GatherBamFiles \\<br />      I=input1.bam \\ <br />      I=input2.bam \\ <br />      O=gathered_files.bam</pre> <hr />", usageShort="Concatenate one or more BAM files as efficiently as possible", programGroup=SamOrBam.class)
public class GatherBamFiles
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Concatenate one or more BAM files as efficiently as possible";
    static final String USAGE_DETAILS = "This tool performs a rapid \"gather\" operation on BAM files after scatter operations where the same process has been performed on different regions of a BAM file creating many smaller BAM files that now need to be concatenated (reassembled) back together.<br /><br />Assumes that the list of BAM files provided as INPUT are in the order that they should be concatenated and simply concatenates the bodies of the BAM files while retaining the header from the first file.  Operates via copying of the gzip blocks directly for speed but also supports generation of an MD5 on the output and indexing of the output BAM file. Only supports BAM files, does not support SAM files.<h4>Usage example:</h4><pre>java -jar picard.jar GatherBamFiles \\<br />      I=input1.bam \\ <br />      I=input2.bam \\ <br />      O=gathered_files.bam</pre> <hr />";
    @Option(shortName="I", doc="Two or more BAM files or text files containing lists of BAM files (one per line).")
    public List<File> INPUT;
    @Option(shortName="O", doc="The output BAM file to write.")
    public File OUTPUT;
    private static final Log log = Log.getInstance(GatherBamFiles.class);

    public static void main(String[] stringArray) {
        GatherBamFiles gatherBamFiles = new GatherBamFiles();
        gatherBamFiles.CREATE_INDEX = true;
        gatherBamFiles.instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        List list = IOUtil.unrollFiles(this.INPUT, (String[])new String[]{".bam", ".sam"});
        for (File file : list) {
            IOUtil.assertFileIsReadable((File)file);
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.determineBlockCopyingStatus(list)) {
            BamFileIoUtils.gatherWithBlockCopying((List)list, (File)this.OUTPUT, (boolean)this.CREATE_INDEX, (boolean)this.CREATE_MD5_FILE);
        } else {
            GatherBamFiles.gatherNormally(list, this.OUTPUT, this.CREATE_INDEX, this.CREATE_MD5_FILE, this.REFERENCE_SEQUENCE);
        }
        return 0;
    }

    private boolean determineBlockCopyingStatus(List<File> list) {
        boolean bl = true;
        for (File file : list) {
            if (BamFileIoUtils.isBamFile((File)file)) continue;
            bl = false;
        }
        return bl;
    }

    private static void gatherNormally(List<File> list, File file, boolean bl, boolean bl2, File file2) {
        SAMFileHeader sAMFileHeader = SamReaderFactory.makeDefault().referenceSequence(file2).getFileHeader(list.get(0));
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().setCreateIndex(bl).setCreateMd5File(bl2).makeSAMOrBAMWriter(sAMFileHeader, true, file);
        for (File file3 : list) {
            log.info(new Object[]{"Gathering " + file3.getAbsolutePath()});
            SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(file2).open(file3);
            for (SAMRecord sAMRecord : samReader) {
                sAMFileWriter.addAlignment(sAMRecord);
            }
            CloserUtil.close((Object)samReader);
        }
        sAMFileWriter.close();
    }
}

