/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMRecordUtil;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.FilteringIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.FastqQualityFormat;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.QualityEncodingDetector;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Reverts SAM or BAM files to a previous state.  This tool removes or restores certain properties of the SAM records, including alignment information, which can be used to produce an unmapped BAM (uBAM) from a previously aligned BAM. It is also capable of restoring the original quality scores of a BAM file that has already undergone base quality score recalibration (BQSR) if theoriginal qualities were retained.<h4>Usage example:</h4><pre>java -jar picard.jar RevertSam \\<br />     I=input.bam \\<br />     O=reverted.bam</pre><hr />", usageShort="Reverts SAM or BAM files to a previous state.  ", programGroup=SamOrBam.class)
public class RevertSam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Reverts SAM or BAM files to a previous state.  ";
    static final String USAGE_DETAILS = "This tool removes or restores certain properties of the SAM records, including alignment information, which can be used to produce an unmapped BAM (uBAM) from a previously aligned BAM. It is also capable of restoring the original quality scores of a BAM file that has already undergone base quality score recalibration (BQSR) if theoriginal qualities were retained.<h4>Usage example:</h4><pre>java -jar picard.jar RevertSam \\<br />     I=input.bam \\<br />     O=reverted.bam</pre><hr />";
    @Option(shortName="I", doc="The input SAM/BAM file to revert the state of.")
    public File INPUT;
    @Option(shortName="O", doc="The output SAM/BAM file to create.")
    public File OUTPUT;
    @Option(shortName="SO", doc="The sort order to create the reverted output file with.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.queryname;
    @Option(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Option(doc="Remove duplicate read flags from all reads.  Note that if this is true and REMOVE_ALIGNMENT_INFORMATION==false,  the output may have the unusual but sometimes desirable trait of having unmapped reads that are marked as duplicates.")
    public boolean REMOVE_DUPLICATE_INFORMATION = true;
    @Option(doc="Remove all alignment information from the file.")
    public boolean REMOVE_ALIGNMENT_INFORMATION = true;
    @Option(doc="When removing alignment information, the set of optional tags to remove.")
    public List<String> ATTRIBUTE_TO_CLEAR = new ArrayList<String>(){
        {
            this.add(SAMTag.NM.name());
            this.add(SAMTag.UQ.name());
            this.add(SAMTag.PG.name());
            this.add(SAMTag.MD.name());
            this.add(SAMTag.MQ.name());
            this.add(SAMTag.SA.name());
            this.add(SAMTag.MC.name());
            this.add(SAMTag.AS.name());
        }
    };
    @Option(doc="WARNING: This option is potentially destructive. If enabled will discard reads in order to produce a consistent output BAM. Reads discarded include (but are not limited to) paired reads with missing mates, duplicated records, records with mismatches in length of bases and qualities. This option can only be enabled if the output sort order is queryname and will always cause sorting to occur.")
    public boolean SANITIZE = false;
    @Option(doc="If SANITIZE=true and higher than MAX_DISCARD_FRACTION reads are discarded due to sanitization thenthe program will exit with an Exception instead of exiting cleanly. Output BAM will still be valid.")
    public double MAX_DISCARD_FRACTION = 0.01;
    @Option(doc="The sample alias to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias ", shortName="ALIAS", optional=true)
    public String SAMPLE_ALIAS;
    @Option(doc="The library name to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias ", shortName="LIB", optional=true)
    public String LIBRARY_NAME;
    private static final Log log = Log.getInstance(RevertSam.class);

    public static void main(String[] stringArray) {
        new RevertSam().instanceMainWithExit(stringArray);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.SANITIZE && this.SORT_ORDER != SAMFileHeader.SortOrder.queryname) {
            return new String[]{"SORT_ORDER must be queryname when sanitization is enabled with SANITIZE=true."};
        }
        return null;
    }

    @Override
    protected int doWork() {
        Object object2;
        boolean bl;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        boolean bl2 = this.SANITIZE;
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).validationStringency(this.VALIDATION_STRINGENCY).open(this.INPUT);
        SAMFileHeader sAMFileHeader = samReader.getFileHeader();
        List list = sAMFileHeader.getReadGroups();
        if (this.SAMPLE_ALIAS != null || this.LIBRARY_NAME != null) {
            bl = true;
            boolean bl3 = true;
            for (int i = 1; i < list.size(); ++i) {
                if (!((SAMReadGroupRecord)list.get(0)).getSample().equals(((SAMReadGroupRecord)list.get(i)).getSample())) {
                    bl = false;
                }
                if (((SAMReadGroupRecord)list.get(0)).getLibrary().equals(((SAMReadGroupRecord)list.get(i)).getLibrary())) continue;
                bl3 = false;
            }
            if (this.SAMPLE_ALIAS != null && !bl) {
                throw new PicardException("Read groups have multiple values for sample.  A value for SAMPLE_ALIAS cannot be supplied.");
            }
            if (this.LIBRARY_NAME != null && !bl3) {
                throw new PicardException("Read groups have multiple values for library name.  A value for library name cannot be supplied.");
            }
        }
        bl = sAMFileHeader.getSortOrder() == this.SORT_ORDER || this.SORT_ORDER == SAMFileHeader.SortOrder.queryname && this.SANITIZE;
        SAMFileHeader sAMFileHeader2 = new SAMFileHeader();
        for (Object object2 : sAMFileHeader.getReadGroups()) {
            if (this.SAMPLE_ALIAS != null) {
                object2.setSample(this.SAMPLE_ALIAS);
            }
            if (this.LIBRARY_NAME != null) {
                object2.setLibrary(this.LIBRARY_NAME);
            }
            sAMFileHeader2.addReadGroup(object2);
        }
        sAMFileHeader2.setSortOrder(this.SORT_ORDER);
        if (!this.REMOVE_ALIGNMENT_INFORMATION) {
            sAMFileHeader2.setSequenceDictionary(sAMFileHeader.getSequenceDictionary());
            sAMFileHeader2.setProgramRecords(sAMFileHeader.getProgramRecords());
        }
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader2, bl, this.OUTPUT);
        object2 = bl2 ? SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(sAMFileHeader2), (Comparator)new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM) : null;
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000, "Reverted");
        for (SAMRecord sAMRecord : samReader) {
            if (sAMRecord.isSecondaryOrSupplementary()) continue;
            progressLogger.record(sAMRecord);
            this.revertSamRecord(sAMRecord);
            if (bl2) {
                object2.add((Object)sAMRecord);
                continue;
            }
            sAMFileWriter.addAlignment(sAMRecord);
        }
        if (!bl2) {
            sAMFileWriter.close();
        } else {
            long l = 0L;
            long l2 = 0L;
            PeekableIterator peekableIterator = new PeekableIterator((Iterator)object2.iterator());
            HashMap<SAMReadGroupRecord, FastqQualityFormat> hashMap = new HashMap<SAMReadGroupRecord, FastqQualityFormat>();
            for (Object object3 : sAMFileHeader.getReadGroups()) {
                SamReader samReader2 = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).validationStringency(this.VALIDATION_STRINGENCY).open(this.INPUT);
                SamRecordFilter samRecordFilter = new SamRecordFilter((SAMReadGroupRecord)object3){
                    final /* synthetic */ SAMReadGroupRecord val$rg;
                    {
                        this.val$rg = sAMReadGroupRecord;
                    }

                    public boolean filterOut(SAMRecord sAMRecord) {
                        return !sAMRecord.getReadGroup().getId().equals(this.val$rg.getId());
                    }

                    public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
                        throw new UnsupportedOperationException();
                    }
                };
                hashMap.put((SAMReadGroupRecord)object3, QualityEncodingDetector.detect((long)10000L, (CloseableIterator)new FilteringIterator((Iterator)samReader2.iterator(), samRecordFilter), (boolean)this.RESTORE_ORIGINAL_QUALITIES));
                CloserUtil.close((Object)samReader2);
            }
            for (Object object3 : hashMap.keySet()) {
                log.info(new Object[]{"Detected quality format for " + object3.getReadGroupId() + ": " + hashMap.get(object3)});
            }
            if (hashMap.values().contains(FastqQualityFormat.Solexa)) {
                log.error(new Object[]{"No quality score encoding conversion implemented for " + FastqQualityFormat.Solexa});
                return -1;
            }
            Iterator<Object> iterator = new ProgressLogger(log, 1000000, "Sanitized");
            block5: while (peekableIterator.hasNext()) {
                Object object4;
                Object object3;
                object3 = this.fetchByReadName((PeekableIterator<SAMRecord>)peekableIterator);
                l += (long)object3.size();
                Iterator iterator2 = object3.iterator();
                while (iterator2.hasNext()) {
                    SAMRecord sAMRecord = (SAMRecord)iterator2.next();
                    if (sAMRecord.getReadBases().length == sAMRecord.getBaseQualities().length) continue;
                    log.debug(new Object[]{"Discarding " + object3.size() + " reads with name " + sAMRecord.getReadName() + " for mismatching bases and quals length."});
                    l2 += (long)object3.size();
                    continue block5;
                }
                if (!((SAMRecord)object3.get(0)).getReadPairedFlag() && object3.size() > 1) {
                    log.debug(new Object[]{"Discarding " + object3.size() + " reads with name " + ((SAMRecord)object3.get(0)).getReadName() + " because they claim to be unpaired."});
                    l2 += (long)object3.size();
                    continue;
                }
                if (((SAMRecord)object3.get(0)).getReadPairedFlag()) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    object4 = object3.iterator();
                    while (object4.hasNext()) {
                        SAMRecord sAMRecord = (SAMRecord)object4.next();
                        if (!sAMRecord.getReadPairedFlag()) {
                            ++n3;
                        }
                        if (sAMRecord.getFirstOfPairFlag()) {
                            ++n;
                        }
                        if (!sAMRecord.getSecondOfPairFlag()) continue;
                        ++n2;
                    }
                    if (n3 > 0 || n != 1 || n2 != 1) {
                        log.debug(new Object[]{"Discarding " + object3.size() + " reads with name " + ((SAMRecord)object3.get(0)).getReadName() + " because pairing information in corrupt."});
                        l2 += (long)object3.size();
                        continue;
                    }
                }
                Iterator iterator3 = object3.iterator();
                while (iterator3.hasNext()) {
                    SAMRecord sAMRecord = (SAMRecord)iterator3.next();
                    FastqQualityFormat fastqQualityFormat = (FastqQualityFormat)hashMap.get(sAMRecord.getReadGroup());
                    if (!fastqQualityFormat.equals((Object)FastqQualityFormat.Standard)) {
                        object4 = sAMRecord.getBaseQualities();
                        int n = 0;
                        while (n < ((Object)object4).length) {
                            Object object5 = object4;
                            int n4 = n++;
                            object5[n4] = (byte)(object5[n4] - 31);
                        }
                        sAMRecord.setBaseQualities((byte[])object4);
                    }
                    sAMFileWriter.addAlignment(sAMRecord);
                    iterator.record(sAMRecord);
                }
            }
            sAMFileWriter.close();
            double d = (double)l2 / (double)l;
            DecimalFormat decimalFormat = new DecimalFormat("0.000%");
            log.info(new Object[]{"Discarded " + l2 + " out of " + l + " (" + decimalFormat.format(d) + ") reads in order to sanitize output."});
            if ((double)l2 / (double)l > this.MAX_DISCARD_FRACTION) {
                throw new PicardException("Discarded " + decimalFormat.format(d) + " which is above MAX_DISCARD_FRACTION of " + decimalFormat.format(this.MAX_DISCARD_FRACTION));
            }
        }
        CloserUtil.close((Object)samReader);
        return 0;
    }

    private List<SAMRecord> fetchByReadName(PeekableIterator<SAMRecord> peekableIterator) {
        LinkedList<SAMRecord> linkedList = new LinkedList<SAMRecord>();
        if (peekableIterator.hasNext()) {
            SAMRecord sAMRecord = (SAMRecord)peekableIterator.next();
            linkedList.add(sAMRecord);
            while (peekableIterator.hasNext() && ((SAMRecord)peekableIterator.peek()).getReadName().equals(sAMRecord.getReadName())) {
                linkedList.add((SAMRecord)peekableIterator.next());
            }
        }
        return linkedList;
    }

    public void revertSamRecord(SAMRecord sAMRecord) {
        Object object;
        if (this.RESTORE_ORIGINAL_QUALITIES && (object = sAMRecord.getOriginalBaseQualities()) != null) {
            sAMRecord.setBaseQualities((byte[])object);
            sAMRecord.setOriginalBaseQualities(null);
        }
        if (this.REMOVE_DUPLICATE_INFORMATION) {
            sAMRecord.setDuplicateReadFlag(false);
        }
        if (this.REMOVE_ALIGNMENT_INFORMATION) {
            if (sAMRecord.getReadNegativeStrandFlag()) {
                SAMRecordUtil.reverseComplement((SAMRecord)sAMRecord);
                sAMRecord.setReadNegativeStrandFlag(false);
            }
            sAMRecord.setReferenceIndex(-1);
            sAMRecord.setAlignmentStart(0);
            sAMRecord.setCigarString("*");
            sAMRecord.setMappingQuality(0);
            if (!sAMRecord.getReadUnmappedFlag()) {
                sAMRecord.setInferredInsertSize(0);
                sAMRecord.setNotPrimaryAlignmentFlag(false);
                sAMRecord.setProperPairFlag(false);
                sAMRecord.setReadUnmappedFlag(true);
            }
            if (sAMRecord.getReadPairedFlag()) {
                sAMRecord.setMateAlignmentStart(0);
                sAMRecord.setMateNegativeStrandFlag(false);
                sAMRecord.setMateReferenceIndex(-1);
                sAMRecord.setMateUnmappedFlag(true);
            }
            object = this.ATTRIBUTE_TO_CLEAR.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                sAMRecord.setAttribute(string, null);
            }
        }
    }
}

