/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.ProgressLoggerInterface;
import java.io.File;
import java.util.stream.StreamSupport;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;
import picard.sam.AbstractAlignmentMerger;

@CommandLineProgramProperties(usage="Fixes the UQ and NM tags in a SAM file.  This tool takes in a SAM or BAM file (sorted by coordinate) and calculates the NM and UQ tags by comparing with the reference.<br />This may be needed when MergeBamAlignment was run with SORT_ORDER different from 'coordinate' and thus could not fix\nthese tags then.<br /><h4>Usage example:</h4><pre>java -jar picard.jar SetNmAndUqTags \\<br />      I=sorted.bam \\<br />      O=fixed.bam \\<br /></pre><hr />", usageShort="Fixes the UQ and NM tags in a SAM file.  ", programGroup=SamOrBam.class)
public class SetNmAndUqTags
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Fixes the UQ and NM tags in a SAM file.  ";
    static final String USAGE_DETAILS = "This tool takes in a SAM or BAM file (sorted by coordinate) and calculates the NM and UQ tags by comparing with the reference.<br />This may be needed when MergeBamAlignment was run with SORT_ORDER different from 'coordinate' and thus could not fix\nthese tags then.<br /><h4>Usage example:</h4><pre>java -jar picard.jar SetNmAndUqTags \\<br />      I=sorted.bam \\<br />      O=fixed.bam \\<br /></pre><hr />";
    @Option(doc="The BAM or SAM file to fix.", shortName="I")
    public File INPUT;
    @Option(doc="The fixed BAM or SAM output file. ", shortName="O")
    public File OUTPUT;
    @Option(doc="Whether the file contains bisulfite sequence (used when calculating the NM tag).")
    public boolean IS_BISULFITE_SEQUENCE = false;
    private final Log log = Log.getInstance(SetNmAndUqTags.class);

    @Override
    protected String[] customCommandLineValidation() {
        if (this.REFERENCE_SEQUENCE == null) {
            return new String[]{"Must have a non-null REFERENCE_SEQUENCE"};
        }
        return super.customCommandLineValidation();
    }

    public static void main(String[] stringArray) {
        new SetNmAndUqTags().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        if (samReader.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new SAMException("Input must be coordinate-sorted for this program to run. Found: " + samReader.getFileHeader().getSortOrder());
        }
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(samReader.getFileHeader(), true, this.OUTPUT);
        sAMFileWriter.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.log, 10000000, "Wrote", "records"));
        ReferenceSequenceFileWalker referenceSequenceFileWalker = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        StreamSupport.stream(samReader.spliterator(), false).peek(sAMRecord -> {
            if (!sAMRecord.getReadUnmappedFlag()) {
                AbstractAlignmentMerger.fixNMandUQ(sAMRecord, referenceSequenceFileWalker, this.IS_BISULFITE_SEQUENCE);
            }
        }).forEach(arg_0 -> ((SAMFileWriter)sAMFileWriter).addAlignment(arg_0));
        CloserUtil.close((Object)samReader);
        sAMFileWriter.close();
        return 0;
    }
}

