/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Histogram;
import java.util.HashMap;
import java.util.Map;
import picard.sam.DuplicationMetrics;

public class LibraryIdGenerator {
    private final SAMFileHeader header;
    private final Map<String, Short> libraryIds = new HashMap<String, Short>();
    private short nextLibraryId = 1;
    private final Map<String, DuplicationMetrics> metricsByLibrary = new HashMap<String, DuplicationMetrics>();
    private final Histogram<Short> opticalDuplicatesByLibraryId = new Histogram();

    public LibraryIdGenerator(SAMFileHeader sAMFileHeader) {
        this.header = sAMFileHeader;
        for (SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
            String string = sAMReadGroupRecord.getLibrary();
            DuplicationMetrics duplicationMetrics = this.metricsByLibrary.get(string);
            if (duplicationMetrics != null) continue;
            duplicationMetrics = new DuplicationMetrics();
            duplicationMetrics.LIBRARY = string;
            this.metricsByLibrary.put(string, duplicationMetrics);
        }
    }

    public Map<String, Short> getLibraryIdsMap() {
        return this.libraryIds;
    }

    public Map<String, DuplicationMetrics> getMetricsByLibraryMap() {
        return this.metricsByLibrary;
    }

    public Histogram<Short> getOpticalDuplicatesByLibraryIdMap() {
        return this.opticalDuplicatesByLibraryId;
    }

    public static String getLibraryName(SAMFileHeader sAMFileHeader, SAMRecord sAMRecord) {
        String string;
        SAMReadGroupRecord sAMReadGroupRecord;
        String string2 = (String)sAMRecord.getAttribute("RG");
        if (string2 != null && (sAMReadGroupRecord = sAMFileHeader.getReadGroup(string2)) != null && null != (string = sAMReadGroupRecord.getLibrary())) {
            return string;
        }
        return "Unknown Library";
    }

    public short getLibraryId(SAMRecord sAMRecord) {
        String string = LibraryIdGenerator.getLibraryName(this.header, sAMRecord);
        Short s = this.libraryIds.get(string);
        if (s == null) {
            short s2 = this.nextLibraryId;
            this.nextLibraryId = (short)(s2 + 1);
            s = s2;
            this.libraryIds.put(string, s);
        }
        return s;
    }

    public DuplicationMetrics getMetricsByLibrary(String string) {
        return this.metricsByLibrary.get(string);
    }

    public void addMetricsByLibrary(String string, DuplicationMetrics duplicationMetrics) {
        this.metricsByLibrary.put(string, duplicationMetrics);
    }

    public long getNumberOfOpticalDuplicateClusters() {
        return (long)this.opticalDuplicatesByLibraryId.getSumOfValues();
    }
}

