/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.util.List;
import picard.sam.util.PhysicalLocation;
import picard.sam.util.ReadNameParser;

public class OpticalDuplicateFinder
extends ReadNameParser {
    public int opticalDuplicatePixelDistance;
    public static final int DEFAULT_OPTICAL_DUPLICATE_DISTANCE = 100;
    public static final int DEFAULT_BIG_DUPLICATE_SET_SIZE = 1000;
    private int bigDuplicateSetSize = 1000;

    public void setBigDuplicateSetSize(int n) {
        this.bigDuplicateSetSize = n;
    }

    public OpticalDuplicateFinder() {
        this.opticalDuplicatePixelDistance = 100;
    }

    public OpticalDuplicateFinder(String string, int n, Log log) {
        super(string, log);
        this.opticalDuplicatePixelDistance = n;
    }

    public boolean[] findOpticalDuplicates(List<? extends PhysicalLocation> list, PhysicalLocation physicalLocation) {
        PhysicalLocation physicalLocation2;
        int n;
        ProgressLogger progressLogger;
        ProgressLogger progressLogger2;
        Log log;
        boolean bl;
        if (list.size() < 2) {
            return new boolean[list.size()];
        }
        int n2 = list.size();
        boolean[] blArray = new boolean[n2];
        int n3 = this.opticalDuplicatePixelDistance;
        PhysicalLocation physicalLocation3 = this.keeperOrNull(list, physicalLocation);
        boolean bl2 = bl = n2 > this.bigDuplicateSetSize;
        if (bl) {
            log = Log.getInstance(OpticalDuplicateFinder.class);
            progressLogger2 = new ProgressLogger(log, 10000, "compared", "ReadEnds to keeper");
            progressLogger = new ProgressLogger(log, 1000, "compared", "ReadEnds to others");
            log.info(new Object[]{"Large duplicate set. size = " + n2});
            log.debug(new Object[]{"About to compare to keeper:" + physicalLocation3});
        } else {
            log = null;
            progressLogger2 = null;
            progressLogger = null;
        }
        if (physicalLocation3 != null) {
            for (n = 0; n < n2; ++n) {
                physicalLocation2 = list.get(n);
                blArray[n] = this.closeEnough(physicalLocation3, physicalLocation2, n3);
                if (!bl) continue;
                progressLogger2.record(String.format("%d", physicalLocation2.getReadGroup()), physicalLocation2.getX());
            }
        }
        if (bl) {
            log.debug(new Object[]{"Done with comparing to keeper, now the rest."});
        }
        for (n = 0; n < n2; ++n) {
            physicalLocation2 = list.get(n);
            if (physicalLocation2 == physicalLocation3) continue;
            if (bl) {
                progressLogger.record(String.format("%d", physicalLocation2.getReadGroup()), physicalLocation2.getX());
            }
            for (int i = n + 1; i < n2; ++i) {
                PhysicalLocation physicalLocation4 = list.get(i);
                if (physicalLocation4 == physicalLocation3 || blArray[n] && blArray[i] || !this.closeEnough(physicalLocation2, physicalLocation4, n3)) continue;
                int n4 = blArray[i] ? n : i;
                blArray[n4] = true;
            }
        }
        return blArray;
    }

    private PhysicalLocation keeperOrNull(List<? extends PhysicalLocation> list, PhysicalLocation physicalLocation) {
        if (physicalLocation != null && physicalLocation.hasLocation()) {
            for (PhysicalLocation physicalLocation2 : list) {
                if (physicalLocation2 != physicalLocation) continue;
                return physicalLocation;
            }
        }
        return null;
    }

    private boolean closeEnough(PhysicalLocation physicalLocation, PhysicalLocation physicalLocation2, int n) {
        return physicalLocation != physicalLocation2 && physicalLocation.hasLocation() && physicalLocation2.hasLocation() && physicalLocation.getReadGroup() == physicalLocation2.getReadGroup() && physicalLocation.getTile() == physicalLocation2.getTile() && Math.abs(physicalLocation.getX() - physicalLocation2.getX()) <= n && Math.abs(physicalLocation.getY() - physicalLocation2.getY()) <= n;
    }
}

