/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.CloseableIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class AsyncIterator<T>
implements CloseableIterator<T> {
    private static volatile int threadsCreated = 0;
    public static final int DEFAULT_QUEUE_SIZE = 2000;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final BlockingQueue<T> queue;
    private final Thread reader;
    private final ReaderRunnable readerRunnable;
    private final AtomicReference<Throwable> ex = new AtomicReference<Object>(null);
    private T theNext = null;
    private final CloseableIterator<T> underlyingIterator;

    public AsyncIterator(CloseableIterator<T> closeableIterator, int n, String string) {
        this.underlyingIterator = closeableIterator;
        this.queue = new ArrayBlockingQueue<T>(n);
        this.readerRunnable = new ReaderRunnable();
        this.reader = new Thread((Runnable)this.readerRunnable, string + threadsCreated++);
        this.reader.setDaemon(true);
        this.reader.start();
        this.getNext();
    }

    private void getNext() {
        this.assertOpen();
        this.checkAndRethrow();
        try {
            this.theNext = null;
            while (!this.queue.isEmpty() || !this.readerRunnable.isDone()) {
                this.theNext = this.queue.poll(5L, TimeUnit.SECONDS);
                this.checkAndRethrow();
                if (this.theNext == null) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted queueing item for writing.", interruptedException);
        }
        this.checkAndRethrow();
    }

    public boolean hasNext() {
        this.assertOpen();
        return this.theNext != null;
    }

    public T next() {
        this.assertOpen();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T t = this.theNext;
        this.getNext();
        return t;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.checkAndRethrow();
        this.assertOpen();
        this.isClosed.set(true);
        try {
            this.reader.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting on reader thread.", interruptedException);
        }
        this.underlyingIterator.close();
        this.checkAndRethrow();
        this.queue.clear();
    }

    private void assertOpen() {
        if (this.isClosed.get()) {
            throw new RuntimeException("AsyncIterator already closed.");
        }
    }

    private void checkAndRethrow() {
        Throwable throwable = this.ex.get();
        if (throwable != null) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    private class ReaderRunnable
    implements Runnable {
        private final AtomicBoolean readerDone = new AtomicBoolean(false);

        private ReaderRunnable() {
        }

        public boolean isDone() {
            return this.readerDone.get();
        }

        @Override
        public void run() {
            try {
                boolean bl = false;
                while (!AsyncIterator.this.isClosed.get() && !bl) {
                    try {
                        if (!AsyncIterator.this.underlyingIterator.hasNext()) {
                            bl = true;
                            continue;
                        }
                        Object object = AsyncIterator.this.underlyingIterator.next();
                        while (!AsyncIterator.this.isClosed.get() && !AsyncIterator.this.queue.offer(object, 2L, TimeUnit.SECONDS)) {
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            catch (Throwable throwable) {
                AsyncIterator.this.ex.compareAndSet(null, throwable);
            }
            finally {
                this.readerDone.set(true);
            }
        }
    }
}

