/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.bed.BEDCodec;
import htsjdk.tribble.bed.BEDFeature;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Intervals;

@CommandLineProgramProperties(usage="Converts a BED file to a Picard Interval List.  This tool provides easy conversion from BED to the Picard interval_list format which is required by many Picard processing tools. Note that the coordinate system of BED files is such that the first base or position in a sequence is numbered \"0\", while in interval_list files it is numbered \"1\".<br /><br />BED files contain sequence data displayed in a flexible format that includes nine optional fields, in addition to three required fields within the annotation tracks. The required fields of a BED file include:<pre>     chrom - The name of the chromosome (e.g. chr20) or scaffold (e.g. scaffold10671) <br />     chromStart - The starting position of the feature in the chromosome or scaffold. The first base in a chromosome is numbered \"0\" <br />     chromEnd - The ending position of the feature in the chromosome or scaffold.  The chromEnd base is not included in the display of the feature. For example, the first 100 bases of a chromosome are defined as chromStart=0, chromEnd=100, and span the bases numbered 0-99.</pre>In each annotation track, the number of fields per line must be consistent throughout a data set. For additional information regarding BED files and the annotation field options, please see: http://genome.ucsc.edu/FAQ/FAQformat.html#format1.<br /> <br /> Interval_list files contain sequence data distributed into intervals. The interval_list file format is relatively simple and reflects the SAM alignment format to a degree.  A SAM style header must be present in the file that lists the sequence records against which the intervals are described.  After the header, the file then contains records, one per line in plain text format with the following values tab-separated::<pre>      -Sequence name (SN) - The name of the sequence in the file for identification purposes, can be chromosome number e.g. chr20 <br />      -Start position - Interval start position (starts at +1) <br />      -End position - Interval end position (1-based, end inclusive) <br />      -Strand - Indicates +/- strand for the interval (either + or -) <br />      -Interval name - (Each interval should have a unique name) </pre>  <br /><br />This tool requires sequence dictionary file (with \".dict\" extension), which can be created from a reference sequence using Picard's CreateSequenceDictionary tool.<h4>Usage example:</h4><pre>java -jar picard.jar BedToIntervalList \\<br />      I=input.bed \\<br />      O=list.interval_list \\<br />      SD=reference_sequence.dict</pre><br /> <br /> <hr />", usageShort="Converts a BED file to a Picard Interval List.  ", programGroup=Intervals.class)
public class BedToIntervalList
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Converts a BED file to a Picard Interval List.  ";
    static final String USAGE_DETAILS = "This tool provides easy conversion from BED to the Picard interval_list format which is required by many Picard processing tools. Note that the coordinate system of BED files is such that the first base or position in a sequence is numbered \"0\", while in interval_list files it is numbered \"1\".<br /><br />BED files contain sequence data displayed in a flexible format that includes nine optional fields, in addition to three required fields within the annotation tracks. The required fields of a BED file include:<pre>     chrom - The name of the chromosome (e.g. chr20) or scaffold (e.g. scaffold10671) <br />     chromStart - The starting position of the feature in the chromosome or scaffold. The first base in a chromosome is numbered \"0\" <br />     chromEnd - The ending position of the feature in the chromosome or scaffold.  The chromEnd base is not included in the display of the feature. For example, the first 100 bases of a chromosome are defined as chromStart=0, chromEnd=100, and span the bases numbered 0-99.</pre>In each annotation track, the number of fields per line must be consistent throughout a data set. For additional information regarding BED files and the annotation field options, please see: http://genome.ucsc.edu/FAQ/FAQformat.html#format1.<br /> <br /> Interval_list files contain sequence data distributed into intervals. The interval_list file format is relatively simple and reflects the SAM alignment format to a degree.  A SAM style header must be present in the file that lists the sequence records against which the intervals are described.  After the header, the file then contains records, one per line in plain text format with the following values tab-separated::<pre>      -Sequence name (SN) - The name of the sequence in the file for identification purposes, can be chromosome number e.g. chr20 <br />      -Start position - Interval start position (starts at +1) <br />      -End position - Interval end position (1-based, end inclusive) <br />      -Strand - Indicates +/- strand for the interval (either + or -) <br />      -Interval name - (Each interval should have a unique name) </pre>  <br /><br />This tool requires sequence dictionary file (with \".dict\" extension), which can be created from a reference sequence using Picard's CreateSequenceDictionary tool.<h4>Usage example:</h4><pre>java -jar picard.jar BedToIntervalList \\<br />      I=input.bed \\<br />      O=list.interval_list \\<br />      SD=reference_sequence.dict</pre><br /> <br /> <hr />";
    @Option(shortName="I", doc="The input BED file")
    public File INPUT;
    @Option(shortName="SD", doc="The sequence dictionary")
    public File SEQUENCE_DICTIONARY;
    @Option(shortName="O", doc="The output Picard Interval List")
    public File OUTPUT;
    @Option(doc="If true, sort the output interval list before writing it.")
    public boolean SORT = true;
    @Option(doc="If true, unique the output interval list by merging overlapping regions, before writing it (implies sort=true).")
    public boolean UNIQUE = false;
    final Log LOG = Log.getInstance(this.getClass());

    public static void main(String[] stringArray) {
        new BedToIntervalList().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        try {
            BEDFeature bEDFeature;
            SAMFileHeader sAMFileHeader = new SAMFileHeader();
            SAMSequenceDictionary sAMSequenceDictionary = SAMSequenceDictionaryExtractor.extractDictionary((File)this.SEQUENCE_DICTIONARY);
            sAMFileHeader.setSequenceDictionary(sAMSequenceDictionary);
            sAMFileHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
            IntervalList intervalList = new IntervalList(sAMFileHeader);
            AbstractFeatureReader abstractFeatureReader = AbstractFeatureReader.getFeatureReader((String)this.INPUT.getAbsolutePath(), (FeatureCodec)new BEDCodec(BEDCodec.StartOffset.ZERO), (boolean)false);
            CloseableTribbleIterator closeableTribbleIterator = abstractFeatureReader.iterator();
            ProgressLogger progressLogger = new ProgressLogger(this.LOG, 1000000);
            while (closeableTribbleIterator.hasNext()) {
                SAMSequenceRecord sAMSequenceRecord;
                bEDFeature = (BEDFeature)closeableTribbleIterator.next();
                String string = bEDFeature.getContig();
                int n = bEDFeature.getStart() + 1;
                int n2 = bEDFeature.getEnd();
                String string2 = bEDFeature.getName();
                if (string2.isEmpty()) {
                    string2 = null;
                }
                if (null == (sAMSequenceRecord = sAMFileHeader.getSequenceDictionary().getSequence(string))) {
                    throw new PicardException(String.format("Sequence '%s' was not found in the sequence dictionary", string));
                }
                if (n < 1) {
                    throw new PicardException(String.format("Start on sequence '%s' was less than one: %d", string, n));
                }
                if (sAMSequenceRecord.getSequenceLength() < n) {
                    throw new PicardException(String.format("Start on sequence '%s' was past the end: %d < %d", string, sAMSequenceRecord.getSequenceLength(), n));
                }
                if (n2 < 1) {
                    throw new PicardException(String.format("End on sequence '%s' was less than one: %d", string, n2));
                }
                if (sAMSequenceRecord.getSequenceLength() < n2) {
                    throw new PicardException(String.format("End on sequence '%s' was past the end: %d < %d", string, sAMSequenceRecord.getSequenceLength(), n2));
                }
                if (n2 < n - 1) {
                    throw new PicardException(String.format("On sequence '%s', end < start-1: %d <= %d", string, n2, n));
                }
                boolean bl = bEDFeature.getStrand() == Strand.NEGATIVE;
                Interval interval = new Interval(string, n, n2, bl, string2);
                intervalList.add(interval);
                progressLogger.record(string, n);
            }
            CloserUtil.close((Object)abstractFeatureReader);
            bEDFeature = intervalList;
            if (this.SORT) {
                bEDFeature = bEDFeature.sorted();
            }
            if (this.UNIQUE) {
                bEDFeature = bEDFeature.uniqued();
            }
            bEDFeature.write(this.OUTPUT);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return 0;
    }
}

