/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import picard.util.VariantType;
import picard.vcf.ByIntervalListVariantContextIterator;

public class DbSnpBitSetUtil {
    private final Map<String, BitSet> sequenceToBitSet = new HashMap<String, BitSet>();

    private DbSnpBitSetUtil() {
    }

    public DbSnpBitSetUtil(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        this(file, sAMSequenceDictionary, EnumSet.noneOf(VariantType.class));
    }

    public DbSnpBitSetUtil(File file, SAMSequenceDictionary sAMSequenceDictionary, Collection<VariantType> collection) {
        this(file, sAMSequenceDictionary, collection, null);
    }

    public DbSnpBitSetUtil(File file, SAMSequenceDictionary sAMSequenceDictionary, Collection<VariantType> collection, IntervalList intervalList) {
        if (file == null) {
            throw new IllegalArgumentException("null dbSnpFile");
        }
        HashMap<DbSnpBitSetUtil, Set<VariantType>> hashMap = new HashMap<DbSnpBitSetUtil, Set<VariantType>>();
        hashMap.put(this, EnumSet.copyOf(collection));
        DbSnpBitSetUtil.loadVcf(file, sAMSequenceDictionary, hashMap, intervalList);
    }

    public static DbSnpBitSets createSnpAndIndelBitSets(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        return DbSnpBitSetUtil.createSnpAndIndelBitSets(file, sAMSequenceDictionary, null);
    }

    public static DbSnpBitSets createSnpAndIndelBitSets(File file, SAMSequenceDictionary sAMSequenceDictionary, IntervalList intervalList) {
        DbSnpBitSets dbSnpBitSets = new DbSnpBitSets();
        dbSnpBitSets.snps = new DbSnpBitSetUtil();
        dbSnpBitSets.indels = new DbSnpBitSetUtil();
        HashMap<DbSnpBitSetUtil, Set<VariantType>> hashMap = new HashMap<DbSnpBitSetUtil, Set<VariantType>>();
        hashMap.put(dbSnpBitSets.snps, EnumSet.of(VariantType.SNP));
        hashMap.put(dbSnpBitSets.indels, EnumSet.of(VariantType.insertion, VariantType.deletion));
        DbSnpBitSetUtil.loadVcf(file, sAMSequenceDictionary, hashMap, intervalList);
        return dbSnpBitSets;
    }

    private static void loadVcf(File file, SAMSequenceDictionary sAMSequenceDictionary, Map<DbSnpBitSetUtil, Set<VariantType>> map, IntervalList intervalList) {
        VCFFileReader vCFFileReader = new VCFFileReader(file, intervalList != null);
        ByIntervalListVariantContextIterator byIntervalListVariantContextIterator = intervalList != null ? new ByIntervalListVariantContextIterator(vCFFileReader, intervalList) : vCFFileReader.iterator();
        while (byIntervalListVariantContextIterator.hasNext()) {
            VariantContext variantContext = (VariantContext)byIntervalListVariantContextIterator.next();
            for (Map.Entry<DbSnpBitSetUtil, Set<VariantType>> entry : map.entrySet()) {
                int n;
                DbSnpBitSetUtil dbSnpBitSetUtil = entry.getKey();
                Set<VariantType> set = entry.getValue();
                BitSet bitSet = dbSnpBitSetUtil.sequenceToBitSet.get(variantContext.getContig());
                if (bitSet == null) {
                    n = sAMSequenceDictionary == null ? variantContext.getEnd() + 1 : sAMSequenceDictionary.getSequence(variantContext.getContig()).getSequenceLength() + 1;
                    bitSet = new BitSet(n);
                    dbSnpBitSetUtil.sequenceToBitSet.put(variantContext.getContig(), bitSet);
                }
                if (!(set.isEmpty() || variantContext.isSNP() && set.contains((Object)VariantType.SNP) || variantContext.isIndel() && set.contains((Object)VariantType.insertion)) && (!variantContext.isIndel() || !set.contains((Object)VariantType.deletion))) continue;
                for (n = variantContext.getStart(); n <= variantContext.getEnd(); ++n) {
                    bitSet.set(n, true);
                }
            }
        }
        CloserUtil.close((Object)vCFFileReader);
    }

    public boolean isDbSnpSite(String string, int n) {
        return this.sequenceToBitSet.get(string) != null && n <= this.sequenceToBitSet.get(string).length() && this.sequenceToBitSet.get(string).get(n);
    }

    public static class DbSnpBitSets {
        public DbSnpBitSetUtil snps;
        public DbSnpBitSetUtil indels;
    }
}

