/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.SolexaQualityConverter;
import htsjdk.samtools.util.StringUtil;
import java.util.List;
import picard.PicardException;
import picard.util.AdapterPair;

public class IlluminaUtil {
    public static final String BARCODE_DELIMITER = "-";

    public static Integer getTileFromReadName(String string) {
        int n;
        int n2;
        int n3 = string.indexOf(58);
        if (n3 > 0 && (n2 = string.indexOf(58, n3 + 1)) > 0 && (n = string.indexOf(58, n2 + 1)) > 0) {
            return Integer.parseInt(string.substring(n2 + 1, n));
        }
        return null;
    }

    public static byte[] makePhredBinaryFromSolexaQualityAscii_1_3(String string) {
        return IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(string, 0, string.length());
    }

    public static byte[] makePhredBinaryFromSolexaQualityAscii_1_3(String string, int n, int n2) {
        byte[] byArray = StringUtil.stringToBytes((String)string, (int)n, (int)n2);
        SolexaQualityConverter.getSingleton().convertSolexa_1_3_QualityCharsToPhredBinary(byArray);
        return byArray;
    }

    public static void convertSolexaQualityAscii_1_1_ToPhredBinary(byte[] byArray) {
        SolexaQualityConverter.getSingleton().convertSolexaQualityCharsToPhredBinary(byArray);
    }

    public static byte getSolexaQualityCharFromFourQualities(String[] stringArray, int n, FormatUtil formatUtil) {
        int n2;
        int n3;
        int n4 = Integer.MIN_VALUE;
        for (n3 = n2 = (n - 1) * 4; n3 < n2 + 4; ++n3) {
            int n5 = formatUtil.parseInt(stringArray[n3]);
            if (n5 <= n4) continue;
            n4 = n5;
        }
        n3 = n4 + 64;
        if (n3 > 255) {
            throw new PicardException("Quality too large: " + n4);
        }
        return (byte)(n3 & 0xFF);
    }

    public static String barcodeSeqsToString(List<String> list) {
        return IlluminaUtil.barcodeSeqsToString(list.toArray(new String[list.size()]));
    }

    public static String barcodeSeqsToString(String[] stringArray) {
        return IlluminaUtil.stringSeqsToString(stringArray, BARCODE_DELIMITER);
    }

    public static String barcodeSeqsToString(byte[][] byArray) {
        return IlluminaUtil.byteArrayToString(byArray, BARCODE_DELIMITER);
    }

    public static String stringSeqsToString(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String byteArrayToString(byte[][] byArray, String string) {
        String[] stringArray = new String[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            stringArray[i] = StringUtil.bytesToString((byte[])byArray[i]);
        }
        return IlluminaUtil.stringSeqsToString(stringArray, string);
    }

    public static enum IlluminaAdapterPair implements AdapterPair
    {
        PAIRED_END("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCGGTTCAGCAGGAATGCCGAGACCGATCTCGTATGCCGTCTTCTGCTTG"),
        INDEXED("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCACACGTCTGAACTCCAGTCACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        SINGLE_END("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCTCGTATGCCGTCTTCTGCTTG"),
        NEXTERA_V1("AATGATACGGCGACCACCGAGATCTACACGCCTCCCTCGCGCCATCAGAGATGTGTATAAGAGACAG", "CTGTCTCTTATACACATCTCTGAGCGGGCTGGCAAGGCAGACCGNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        NEXTERA_V2("AATGATACGGCGACCACCGAGATCTACACNNNNNNNNTCGTCGGCAGCGTCAGATGTGTATAAGAGACAG", "CTGTCTCTTATACACATCTCCGAGCCCACGAGACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        DUAL_INDEXED("AATGATACGGCGACCACCGAGATCTNNNNNNNNACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCACACGTCTGAACTCCAGTCACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        FLUIDIGM("AATGATACGGCGACCACCGAGATCTACACTGACGACATGGTTCTACA", "AGACCAAGTCTCTGCTACCGTANNNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        TRUSEQ_SMALLRNA("AATGATACGGCGACCACCGAGATCTACACGTTCAGAGTTCTACAGTCCGACGATC", "TGGAATTCTCGGGTGCCAAGGAACTCCAGTCACNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        ALTERNATIVE_SINGLE_END("AATGATACGGCGACCACCGACAGGTTCAGAGTTCTACAGTCCGACGATC", "TCGTATGCCGTCTTCTGCTTG");

        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        private IlluminaAdapterPair(String string2, String string3) {
            this.threePrime = string3;
            this.threePrimeBytes = StringUtil.stringToBytes((String)string3);
            this.fivePrime = string2;
            this.fivePrimeReadOrder = SequenceUtil.reverseComplement((String)string2);
            this.fivePrimeBytes = StringUtil.stringToBytes((String)string2);
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes((String)this.fivePrimeReadOrder);
        }

        @Override
        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        @Override
        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        @Override
        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        @Override
        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

